/*
 * Decompiled with CFR 0.152.
 */
package com.landicorp.android.eptapi.utils;

import android.content.Context;
import android.os.Parcel;
import android.view.inputmethod.InputMethodManager;
import com.landicorp.android.eptapi.exception.RequestException;
import com.landicorp.android.eptapi.service.MasterController;
import java.lang.reflect.Method;

public class IMEUtil {
    public static void useDefaultIME() throws RequestException {
        MasterController.getInstance().request(0xFF0001);
    }

    public static void useGoogleIME() throws RequestException {
        Parcel data = Parcel.obtain();
        data.writeInt(1);
        try {
            MasterController.getInstance().request(0xFF0001, data);
        }
        finally {
            data.recycle();
        }
    }

    public static void disableIME(Context context) {
        InputMethodManager im = (InputMethodManager)context.getSystemService("input_method");
        IMEUtil.IM_disable(im);
    }

    public static void enableIME(Context context) {
        InputMethodManager im = (InputMethodManager)context.getSystemService("input_method");
        IMEUtil.IM_enable(im);
    }

    private static void IM_enable(InputMethodManager imm) {
        try {
            Class[] PARAM_TYPES = new Class[]{Integer.TYPE, Object.class};
            Method setInputMethodPara = imm.getClass().getMethod("setInputMethodPara", PARAM_TYPES);
            if (setInputMethodPara != null) {
                setInputMethodPara.invoke((Object)imm, 1, null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void IM_disable(InputMethodManager imm) {
        try {
            Class[] PARAM_TYPES = new Class[]{Integer.TYPE, Object.class};
            Method setInputMethodPara = imm.getClass().getMethod("setInputMethodPara", PARAM_TYPES);
            if (setInputMethodPara != null) {
                setInputMethodPara.invoke((Object)imm, 2, null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

