/*
 * Decompiled with CFR 0.152.
 */
package com.landicorp.android.eptapi.emv;

import android.os.Parcel;
import com.landicorp.android.eptapi.exception.RequestException;
import com.landicorp.android.eptapi.log.Logger;
import com.landicorp.android.eptapi.service.MasterController;
import com.landicorp.android.eptapi.utils.BinaryData;
import com.landicorp.android.eptapi.utils.BytesUtil;
import java.util.ArrayList;
import java.util.List;

public abstract class EmvRequestExecutor {
    static final Logger logger = Logger.getLogger(EmvRequestExecutor.class);
    static final int ERROR_NONE = 0;
    static final int ERROR_FAIL = 1;
    private int requestCode;
    private String packageName;

    public EmvRequestExecutor(int requestCode) {
        this.requestCode = requestCode;
        this.packageName = MasterController.getInstance().getDefaultAppName();
    }

    public EmvRequestExecutor(String packageName, int requestCode) {
        this.packageName = packageName;
        this.requestCode = requestCode;
    }

    public abstract void makeRequestData(Parcel var1);

    public abstract void handleResponseData(Parcel var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int execute(int code) {
        Parcel data = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        try {
            data.writeInt(code);
            this.makeRequestData(data);
            MasterController.getInstance().request(this.packageName, this.requestCode, data, reply);
            if (reply.dataAvail() == 0) {
                logger.error("# execute[" + this.requestCode + " | " + code + " ] | reply data size error!", new Object[0]);
                this.handleResponseData(reply);
                int n = 0;
                return n;
            }
            int ret = reply.readInt();
            logger.debug("# execute[" + this.requestCode + " | " + code + " ] | ret: " + ret, new Object[0]);
            this.handleResponseData(reply);
            int n = ret;
            return n;
        }
        catch (RequestException e) {
            e.printStackTrace();
            this.onException(e);
            int n = 1;
            return n;
        }
        finally {
            data.recycle();
            reply.recycle();
        }
    }

    public static <T extends BinaryData> List<T> getList(Parcel resp, Class<T> clazz) {
        ArrayList l = new ArrayList();
        EmvRequestExecutor.getList(resp, clazz, l);
        return l;
    }

    public static void getList(Parcel resp, Class<? extends BinaryData> clazz, List list) {
        int size = resp.readInt();
        while (size-- > 0) {
            BinaryData info = null;
            try {
                info = clazz.newInstance();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            EmvRequestExecutor.readBinaryDataFromParcel(resp, info);
            list.add(info);
        }
    }

    public void parcelList(Parcel parcel, List list) {
        parcel.writeInt(list.size());
        for (int i = 0; i < list.size(); ++i) {
            this.parcelBinaryData(parcel, (BinaryData)list.get(i));
        }
    }

    public void parcelStringList(Parcel parcel, List<String> list) {
        parcel.writeInt(list.size());
        for (int i = 0; i < list.size(); ++i) {
            parcel.writeByteArray(BytesUtil.hexString2Bytes(list.get(i)));
        }
    }

    public void parcelBinaryData(Parcel p, BinaryData data) {
        p.writeByteArray(data.toBinary());
    }

    public static void readBinaryDataFromParcel(Parcel p, BinaryData data) {
        data.fromBinary(p.createByteArray());
    }

    public void onException(RequestException e) {
    }
}

