/*
 * Decompiled with CFR 0.152.
 */
package com.landicorp.android.eptapi.dualscreen;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.RemoteException;
import com.landicorp.android.eptapi.dualscreen.DSMConnectListener;
import com.landicorp.android.eptapi.dualscreen.DualScreenProxy;
import com.landicorp.android.eptapi.log.Logger;

class DualScreenService {
    static final Logger logger = Logger.getLogger(DualScreenService.class);
    private static final DualScreenService instance = new DualScreenService();
    private Context mContext;
    private IBinder serviceBinder;
    private DSMConnectListener listener;
    private Handler mHandler = new Handler(Looper.getMainLooper());
    private ServiceConnection serviceConnection = new ServiceConnection(){

        public void onServiceConnected(ComponentName cmpName, IBinder service) {
            logger.debug("------------- service [com.android.dualscreenmanager] connected! -------------", new Object[0]);
            DualScreenService.this.attachService(service);
            DualScreenService.this.notifyReady();
        }

        public void onServiceDisconnected(ComponentName cmpName) {
            logger.error("------------- service [com.android.dualscreenmanager] disconnected! -------------", new Object[0]);
            DualScreenService.this.detachService();
            DualScreenService.this.notifyDisconnect();
        }
    };

    private DualScreenService() {
    }

    public static DualScreenService me() {
        return instance;
    }

    public void init(Context context) {
        this.mContext = context;
    }

    public void connect(DSMConnectListener listener) {
        this.listener = listener;
        if (this.isConnected()) {
            this.notifyReady();
            return;
        }
        Intent intent = new Intent();
        intent.setClassName("com.android.dualscreenmanager", "com.android.dualscreenmanager.DualScreenManagerService");
        boolean success = this.mContext.bindService(intent, this.serviceConnection, 1);
        logger.warn("----------------- bind service[com.android.dualscreenmanager] " + (success ? "success" : "fail") + "---------------------", new Object[0]);
        if (!success) {
            this.notifyError();
        }
    }

    public void disconnect() {
        if (this.isConnected()) {
            logger.warn("----------------- unbind service[com.android.dualscreenmanager] ---------------------", new Object[0]);
            this.mContext.unbindService(this.serviceConnection);
            this.listener = null;
            this.detachService();
        }
    }

    private boolean isConnected() {
        return this.serviceBinder != null && this.serviceBinder.isBinderAlive();
    }

    private void linkToDeath(IBinder service) {
        try {
            if (service != null) {
                service.linkToDeath(new IBinder.DeathRecipient(){

                    public void binderDied() {
                        logger.error("------------- service [com.android.dualscreenmanager] binder died!!!-------------", new Object[0]);
                        DualScreenService.this.detachService();
                        DualScreenService.this.notifyDisconnect();
                    }
                }, 0);
            }
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    private void attachService(IBinder service) {
        this.serviceBinder = service;
        DualScreenProxy.getInstance().attachImpl(service);
        this.linkToDeath(this.serviceBinder);
    }

    private void detachService() {
        this.serviceBinder = null;
        DualScreenProxy.getInstance().detachImpl();
    }

    private void notifyReady() {
        if (this.listener != null) {
            this.listener.onReady(null);
            this.listener = null;
        }
    }

    private void notifyError() {
        if (this.listener != null) {
            this.listener.onError();
            this.listener = null;
        }
    }

    private void notifyDisconnect() {
        if (this.listener != null) {
            this.listener.onDisconnect();
            this.listener = null;
        }
    }
}

