/*
 * Decompiled with CFR 0.152.
 */
package com.landicorp.android.eptapi.dualscreen;

import android.content.Intent;
import android.os.IBinder;
import android.os.RemoteException;
import com.android.dualscreenmanager.aidl.IDataListener;
import com.android.dualscreenmanager.aidl.IDualScreenManagerService;
import com.landicorp.android.eptapi.dualscreen.DualScreenManager;
import com.landicorp.android.eptapi.log.Logger;
import java.util.List;

class DualScreenProxy
implements DualScreenManager {
    static final Logger logger = Logger.getLogger(DualScreenProxy.class);
    private static final DualScreenProxy instance = new DualScreenProxy();
    private IDualScreenManagerService dsmService;

    private DualScreenProxy() {
    }

    public static DualScreenProxy getInstance() {
        return instance;
    }

    public void attachImpl(IBinder binder) {
        this.dsmService = IDualScreenManagerService.Stub.asInterface(binder);
    }

    public void detachImpl() {
        this.dsmService = null;
    }

    @Override
    public int startOnSubScreen(final String packageName, final String className, final byte[] data) {
        return new InvokeWrapper(){

            @Override
            protected int onInvoke() throws RemoteException {
                return DualScreenProxy.this.dsmService.startOnSubScreen(packageName, className, data);
            }
        }.invoke();
    }

    @Override
    public int startActivityOnSubScreen(final Intent intent) {
        return new InvokeWrapper(){

            @Override
            protected int onInvoke() throws RemoteException {
                return DualScreenProxy.this.dsmService.startActivityOnSubScreen(intent);
            }
        }.invoke();
    }

    @Override
    public int setSubScreenApp(final String packageName) {
        return new InvokeWrapper(){

            @Override
            protected int onInvoke() throws RemoteException {
                return DualScreenProxy.this.dsmService.setSubScreenApp(packageName);
            }
        }.invoke();
    }

    @Override
    public int getSubScreenApps(final List<String> apps) {
        return new InvokeWrapper(){

            @Override
            protected int onInvoke() throws RemoteException {
                return DualScreenProxy.this.dsmService.getSubScreenApps(apps);
            }
        }.invoke();
    }

    @Override
    public int removeSubScreenApp(final String packageName) {
        return new InvokeWrapper(){

            @Override
            protected int onInvoke() throws RemoteException {
                return DualScreenProxy.this.dsmService.removeSubScreenApp(packageName);
            }
        }.invoke();
    }

    @Override
    public int getCurrentMode() {
        return new InvokeWrapper(){

            @Override
            protected int onInvoke() throws RemoteException {
                return DualScreenProxy.this.dsmService.getCurrentMode();
            }
        }.invoke();
    }

    @Override
    public int getWindowDisplayScreen(final IBinder windowToken) {
        return new InvokeWrapper(){

            @Override
            protected int onInvoke() throws RemoteException {
                return DualScreenProxy.this.dsmService.getWindowDisplayScreen(windowToken);
            }
        }.invoke();
    }

    @Override
    public int getSubScreenTouchable() {
        return new InvokeWrapper(){

            @Override
            protected int onInvoke() throws RemoteException {
                return DualScreenProxy.this.dsmService.getSubScreenTouchable();
            }
        }.invoke();
    }

    @Override
    public int setSubScreenTouchable(final boolean touchable) {
        return new InvokeWrapper(){

            @Override
            protected int onInvoke() throws RemoteException {
                return DualScreenProxy.this.dsmService.setSubScreenTouchable(touchable);
            }
        }.invoke();
    }

    @Override
    public int getSubScreenButtonEnable() {
        return new InvokeWrapper(){

            @Override
            protected int onInvoke() throws RemoteException {
                return DualScreenProxy.this.dsmService.getSubScreenButtonEnable();
            }
        }.invoke();
    }

    @Override
    public int setSubScreenButtonEnable(final boolean enable) {
        return new InvokeWrapper(){

            @Override
            protected int onInvoke() throws RemoteException {
                return DualScreenProxy.this.dsmService.setSubScreenButtonEnable(enable);
            }
        }.invoke();
    }

    @Override
    public int getSubScreenFocus() {
        return new InvokeWrapper(){

            @Override
            protected int onInvoke() throws RemoteException {
                return DualScreenProxy.this.dsmService.getSubScreenFocus();
            }
        }.invoke();
    }

    @Override
    public int setSubScreenFocus(final boolean haveFocus) {
        return new InvokeWrapper(){

            @Override
            protected int onInvoke() throws RemoteException {
                return DualScreenProxy.this.dsmService.setSubScreenFocus(haveFocus);
            }
        }.invoke();
    }

    @Override
    public int getSubScreenBrightness() {
        return new InvokeWrapper(){

            @Override
            protected int onInvoke() throws RemoteException {
                return DualScreenProxy.this.dsmService.getSubScreenBrightness();
            }
        }.invoke();
    }

    @Override
    public int setSubScreenBrightness(final int brightness) {
        return new InvokeWrapper(){

            @Override
            protected int onInvoke() throws RemoteException {
                return DualScreenProxy.this.dsmService.setSubScreenBrightness(brightness);
            }
        }.invoke();
    }

    @Override
    public int getSubScreenKeepScreenOn() {
        return new InvokeWrapper(){

            @Override
            protected int onInvoke() throws RemoteException {
                return DualScreenProxy.this.dsmService.getSubScreenKeepScreenOn();
            }
        }.invoke();
    }

    @Override
    public int setSubScreenKeepScreenOn(final boolean keepScreenOn) {
        return new InvokeWrapper(){

            @Override
            protected int onInvoke() throws RemoteException {
                return DualScreenProxy.this.dsmService.setSubScreenKeepScreenOn(keepScreenOn);
            }
        }.invoke();
    }

    @Override
    public int registerDataListener(final String id, final DualScreenManager.DataListener listener) {
        return new InvokeWrapper(){

            @Override
            protected int onInvoke() throws RemoteException {
                return DualScreenProxy.this.dsmService.registerDataListener(id, new IDataListener.Stub(){

                    @Override
                    public void onReceive(byte[] data) throws RemoteException {
                        if (listener != null) {
                            listener.onReceive(data);
                        }
                    }
                });
            }
        }.invoke();
    }

    @Override
    public int unregisterDataListener(final String id) {
        return new InvokeWrapper(){

            @Override
            protected int onInvoke() throws RemoteException {
                return DualScreenProxy.this.dsmService.unregisterDataListener(id);
            }
        }.invoke();
    }

    @Override
    public int sendData(final String id, final byte[] data) {
        return new InvokeWrapper(){

            @Override
            protected int onInvoke() throws RemoteException {
                return DualScreenProxy.this.dsmService.sendData(id, data);
            }
        }.invoke();
    }

    @Override
    public int setMirrorMainScreenByForce(final boolean mirror) {
        return new InvokeWrapper(){

            @Override
            protected int onInvoke() throws RemoteException {
                return DualScreenProxy.this.dsmService.setMirrorMainScreenByForce(mirror);
            }
        }.invoke();
    }

    @Override
    public int getMirrorMainScreenByForce() {
        return new InvokeWrapper(){

            @Override
            protected int onInvoke() throws RemoteException {
                return DualScreenProxy.this.dsmService.getMirrorMainScreenByForce();
            }
        }.invoke();
    }

    private abstract class InvokeWrapper {
        private InvokeWrapper() {
        }

        public final int invoke() {
            if (DualScreenProxy.this.dsmService == null || !DualScreenProxy.this.dsmService.asBinder().isBinderAlive()) {
                logger.error("/// InvokeWrapper | dsmService is down!!!", new Object[0]);
                return 65281;
            }
            try {
                return this.onInvoke();
            }
            catch (RemoteException e) {
                e.printStackTrace();
                return 65280;
            }
        }

        protected abstract int onInvoke() throws RemoteException;
    }
}

