/*
 * Decompiled with CFR 0.152.
 */
package com.landicorp.android.eptapi.dualscreen;

import android.content.Context;
import com.landicorp.android.eptapi.dualscreen.DSMConnectListener;
import com.landicorp.android.eptapi.dualscreen.DualScreenManager;
import com.landicorp.android.eptapi.dualscreen.DualScreenProxy;
import com.landicorp.android.eptapi.dualscreen.DualScreenService;
import com.landicorp.android.eptapi.utils.Precondition;

public final class DualScreenHelper {
    private static final String AECR = "AECR";
    private static final DualScreenHelper instance = new DualScreenHelper();
    private Context mContext;

    private DualScreenHelper() {
    }

    public static DualScreenHelper getInstance() {
        return instance;
    }

    public void init(Context context) {
        this.mContext = context;
    }

    public void connect(final DSMConnectListener listener) {
        Precondition.checkNotNull(listener, "listener can't be null!");
        DualScreenService dsmService = DualScreenService.me();
        dsmService.init(this.mContext);
        dsmService.connect(new DSMConnectListener(){

            @Override
            public void onReady(DualScreenManager dsm) {
                listener.onReady(DualScreenProxy.getInstance());
            }

            @Override
            public void onError() {
                listener.onError();
            }

            @Override
            public void onDisconnect() {
                listener.onDisconnect();
            }
        });
    }

    public void disconnect() {
        DualScreenService.me().disconnect();
    }
}

