/*
 * Decompiled with CFR 0.152.
 */
package com.landicorp.android.eptapi.dock;

import android.os.Parcel;
import com.landicorp.android.eptapi.exception.RequestException;
import com.landicorp.android.eptapi.log.Logger;
import com.landicorp.android.eptapi.service.MasterController;
import com.landicorp.android.eptapi.utils.StringUtil;

abstract class Interactor {
    static final Logger logger = Logger.getLogger(Interactor.class);
    static final int ERROR_NONE = 0;
    static final int ERROR_FAIL = 1;
    private String packageName;
    private String dockerName;
    private MasterController mMCtrl = MasterController.getInstance();

    public Interactor(String packageName, String dockerName) {
        this.packageName = packageName;
        this.dockerName = dockerName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int interact(int actionCode) {
        Parcel data = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        try {
            data.writeInt(actionCode);
            data.writeByteArray(StringUtil.getGBK(this.dockerName));
            this.onRequest(data);
            this.mMCtrl.request(this.packageName, 5120, data, reply);
            if (reply.dataAvail() == 0) {
                logger.error("# interact | reply data size error!", new Object[0]);
                int n = 1;
                return n;
            }
            int retCode = reply.readInt();
            if (retCode == 0) {
                this.onResponse(reply);
            }
            int n = retCode;
            return n;
        }
        catch (RequestException e) {
            e.printStackTrace();
            int n = 1;
            return n;
        }
        finally {
            data.recycle();
            reply.recycle();
        }
    }

    void onRequest(Parcel data) {
    }

    void onResponse(Parcel reply) {
    }
}

