/*
 * Decompiled with CFR 0.152.
 */
package com.landicorp.android.eptapi.dock;

import com.landicorp.android.eptapi.utils.BytesUtil;
import com.landicorp.android.eptapi.utils.CStruct;
import java.util.Arrays;

public class EthernetInfo
extends CStruct {
    private static final int LEN = 40;
    int mode;
    byte[] ip = new byte[40];
    byte[] netmask = new byte[40];
    byte[] gateway = new byte[40];
    byte[] dns1 = new byte[40];
    byte[] dns2 = new byte[40];
    byte[] dns3 = new byte[40];
    byte[] innerIp = new byte[40];

    public int getMode() {
        return this.mode;
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    public String getIp() {
        return BytesUtil.fromBytes(EthernetInfo.trimData(this.ip));
    }

    public void setIp(String ip) {
        this.setBytes(this.ip, BytesUtil.toBytes(ip));
    }

    public String getNetmask() {
        return BytesUtil.fromBytes(EthernetInfo.trimData(this.netmask));
    }

    public void setNetmask(String netmask) {
        this.setBytes(this.netmask, BytesUtil.toBytes(netmask));
    }

    public String getGateway() {
        return BytesUtil.fromBytes(EthernetInfo.trimData(this.gateway));
    }

    public void setGateway(String gateway) {
        this.setBytes(this.gateway, BytesUtil.toBytes(gateway));
    }

    public String getDns1() {
        return BytesUtil.fromBytes(EthernetInfo.trimData(this.dns1));
    }

    public void setDns1(String dns1) {
        this.setBytes(this.dns1, BytesUtil.toBytes(dns1));
    }

    public String getDns2() {
        return BytesUtil.fromBytes(EthernetInfo.trimData(this.dns2));
    }

    public void setDns2(String dns2) {
        this.setBytes(this.dns2, BytesUtil.toBytes(dns2));
    }

    public String getDns3() {
        return BytesUtil.fromBytes(EthernetInfo.trimData(this.dns3));
    }

    public void setDns3(String dns3) {
        this.setBytes(this.dns3, BytesUtil.toBytes(dns3));
    }

    public String getInnerIp() {
        return BytesUtil.fromBytes(EthernetInfo.trimData(this.innerIp));
    }

    public void setInnerIp(String innerIp) {
        this.setBytes(this.innerIp, BytesUtil.toBytes(innerIp));
    }

    private static byte[] trimData(byte[] data) {
        int i;
        if (data == null || data.length == 0) {
            return data;
        }
        int start = -1;
        int end = 0;
        for (i = 0; i < data.length; ++i) {
            if (!EthernetInfo.isVisibleCharacter(data[i])) continue;
            start = i;
            break;
        }
        if (start == -1) {
            return new byte[0];
        }
        for (i = data.length - 1; i >= 0; --i) {
            if (!EthernetInfo.isVisibleCharacter(data[i])) continue;
            end = i;
            break;
        }
        return Arrays.copyOfRange(data, start, end + 1);
    }

    private static boolean isVisibleCharacter(byte chr) {
        return chr >= 32 && chr <= 126;
    }

    @Override
    protected String[] getDeclaredMemberNames() {
        return new String[]{"mode", "ip", "netmask", "gateway", "dns1", "dns2", "dns3", "innerIp"};
    }
}

