/*
 * Decompiled with CFR 0.152.
 */
package com.landicorp.android.eptapi.device.factory;

import com.landicorp.android.eptapi.card.At1604Driver;
import com.landicorp.android.eptapi.card.At1608Driver;
import com.landicorp.android.eptapi.card.At24CxxDriver;
import com.landicorp.android.eptapi.card.InsertCpuCardDriver;
import com.landicorp.android.eptapi.card.InsertDriver;
import com.landicorp.android.eptapi.card.MifareDriver;
import com.landicorp.android.eptapi.card.RFCpuCardDriver;
import com.landicorp.android.eptapi.card.RFDriver;
import com.landicorp.android.eptapi.card.Sim4428Driver;
import com.landicorp.android.eptapi.card.Sim4442Driver;
import com.landicorp.android.eptapi.service.MasterController;
import java.util.HashMap;
import java.util.Map;

public class CardDriverFactory {
    private static Map<String, CardDriverFactory> sInstances = new HashMap<String, CardDriverFactory>();
    private HashMap<String, InsertDriver> mInsertDrivers = new HashMap();
    private HashMap<String, RFDriver> mRFDrivers = new HashMap();
    private String packageName;

    protected CardDriverFactory(String packageName) {
        this.packageName = packageName;
        this.initInsertDrivers();
        this.initRFDrivers();
    }

    private void initInsertDrivers() {
        this.mInsertDrivers.put("CPU", new InsertCpuCardDriver(this.packageName, "USERCARD"));
        this.mInsertDrivers.put("AT102", new At1604Driver(this.packageName, 4));
        this.mInsertDrivers.put("SIM4442", new Sim4442Driver(this.packageName, "USERCARD"));
        this.mInsertDrivers.put("SIM4428", new Sim4428Driver(this.packageName, "USERCARD"));
        this.mInsertDrivers.put("AT24C01", new At24CxxDriver(this.packageName, 0, "USERCARD"));
        this.mInsertDrivers.put("AT24C02", new At24CxxDriver(this.packageName, 1, "USERCARD"));
        this.mInsertDrivers.put("AT24C04", new At24CxxDriver(this.packageName, 2, "USERCARD"));
        this.mInsertDrivers.put("AT24C08", new At24CxxDriver(this.packageName, 3, "USERCARD"));
        this.mInsertDrivers.put("AT24C16", new At24CxxDriver(this.packageName, 4, "USERCARD"));
        this.mInsertDrivers.put("AT24C32", new At24CxxDriver(this.packageName, 5, "USERCARD"));
        this.mInsertDrivers.put("AT24C64", new At24CxxDriver(this.packageName, 6, "USERCARD"));
        this.mInsertDrivers.put("AT24C128", new At24CxxDriver(this.packageName, 7, "USERCARD"));
        this.mInsertDrivers.put("AT24C256", new At24CxxDriver(this.packageName, 8, "USERCARD"));
        this.mInsertDrivers.put("AT1608", new At1608Driver(this.packageName, "USERCARD"));
        this.mInsertDrivers.put("AT153", new At1608Driver(this.packageName, "USERCARD"));
    }

    private void initRFDrivers() {
        this.mRFDrivers.put("CPU", new RFCpuCardDriver(this.packageName, "USERCARD"));
        this.mRFDrivers.put("PRO", new RFCpuCardDriver(this.packageName, "USERCARD"));
        this.mRFDrivers.put("S50", new MifareDriver(this.packageName, "USERCARD"));
        this.mRFDrivers.put("S70", new MifareDriver(this.packageName, "USERCARD"));
        this.mRFDrivers.put("ULTRALIGHT", new MifareDriver(this.packageName, "USERCARD"));
    }

    public static CardDriverFactory getInstance() {
        return CardDriverFactory.getInstance(MasterController.getInstance().getDefaultAppName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CardDriverFactory getInstance(String packageName) {
        Map<String, CardDriverFactory> map = sInstances;
        synchronized (map) {
            if (sInstances.containsKey(packageName)) {
                return sInstances.get(packageName);
            }
            CardDriverFactory factory = new CardDriverFactory(packageName);
            sInstances.put(packageName, factory);
            return factory;
        }
    }

    public synchronized InsertDriver createInsertCardDriver(String deviceName, String driverName) {
        String key = null;
        key = deviceName.equals("USERCARD") ? driverName : deviceName + "/" + driverName;
        InsertDriver driver = this.mInsertDrivers.get(key);
        if (driver != null) {
            return driver;
        }
        if (driverName.equals("CPU")) {
            driver = new InsertCpuCardDriver(this.packageName, deviceName);
        } else if (driverName.equals("AT153")) {
            driver = new At1608Driver(this.packageName, deviceName);
        } else if (driverName.equals("AT1608")) {
            driver = new At1608Driver(this.packageName, deviceName);
        } else if (driverName.equals("AT102")) {
            driver = new At1604Driver(this.packageName, 4, deviceName);
        } else if (driverName.equals("SIM4442")) {
            driver = new Sim4442Driver(this.packageName, deviceName);
        } else if (driverName.equals("SIM4428")) {
            driver = new Sim4428Driver(this.packageName, deviceName);
        } else if (driverName.equals("AT24C01")) {
            driver = new At24CxxDriver(this.packageName, 0, deviceName);
        } else if (driverName.equals("AT24C02")) {
            driver = new At24CxxDriver(this.packageName, 1, deviceName);
        } else if (driverName.equals("AT24C04")) {
            driver = new At24CxxDriver(this.packageName, 2, deviceName);
        } else if (driverName.equals("AT24C08")) {
            driver = new At24CxxDriver(this.packageName, 3, deviceName);
        } else if (driverName.equals("AT24C16")) {
            driver = new At24CxxDriver(this.packageName, 4, deviceName);
        } else if (driverName.equals("AT24C32")) {
            driver = new At24CxxDriver(this.packageName, 5, deviceName);
        } else if (driverName.equals("AT24C64")) {
            driver = new At24CxxDriver(this.packageName, 6, deviceName);
        } else if (driverName.equals("AT24C128")) {
            driver = new At24CxxDriver(this.packageName, 7, deviceName);
        } else if (driverName.equals("AT24C256")) {
            driver = new At24CxxDriver(this.packageName, 8, deviceName);
        }
        this.mInsertDrivers.put(key, driver);
        return driver;
    }

    public synchronized RFDriver createRFCardDriver(String deviceName, String driverName) {
        String key = null;
        key = deviceName.equals("USERCARD") ? driverName : deviceName + "/" + driverName;
        RFDriver driver = this.mRFDrivers.get(key);
        if (driver != null) {
            return driver;
        }
        if (driverName.equals("CPU")) {
            driver = new RFCpuCardDriver(this.packageName, deviceName);
        } else if (driverName.equals("PRO")) {
            driver = new RFCpuCardDriver(this.packageName, deviceName);
        } else if (driverName.equals("S50")) {
            driver = new MifareDriver(this.packageName, deviceName);
        } else if (driverName.equals("S70")) {
            driver = new MifareDriver(this.packageName, deviceName);
        } else if (driverName.equals("ULTRALIGHT")) {
            driver = new MifareDriver(this.packageName, deviceName);
        }
        this.mRFDrivers.put(key, driver);
        return driver;
    }
}

