/*
 * Decompiled with CFR 0.152.
 */
package com.landicorp.android.eptapi.device;

import android.os.Parcel;
import com.landicorp.android.eptapi.exception.RequestException;
import com.landicorp.android.eptapi.log.Logger;
import com.landicorp.android.eptapi.service.MasterController;
import com.landicorp.android.eptapi.utils.BytesBuffer;
import com.landicorp.android.eptapi.utils.IntegerBuffer;
import com.landicorp.android.eptapi.utils.Precondition;
import com.landicorp.android.eptapi.utils.StringUtil;

public class VBTSerialPort {
    static final Logger logger = Logger.getLogger(VBTSerialPort.class);
    public static final int BPS_1200 = 1;
    public static final int BPS_2400 = 2;
    public static final int BPS_4800 = 3;
    public static final int BPS_9600 = 4;
    public static final int BPS_14400 = 5;
    public static final int BPS_28800 = 6;
    public static final int BPS_19200 = 7;
    public static final int BPS_57600 = 8;
    public static final int BPS_115200 = 9;
    public static final int BPS_38400 = 10;
    public static final int PAR_EVEN = 69;
    public static final int PAR_ODD = 79;
    public static final int PAR_NONE = 78;
    public static final int DBS_7 = 7;
    public static final int DBS_8 = 8;
    public static final int ERROR_NONE = 0;
    public static final int ERROR_UNKNOWN = 1;
    public static final int ERROR_FAIL = 2;
    public static final int ERROR_DEVICE_DISABLE = 32;
    public static final int ERROR_HANDLE = 139;
    public static final int ERROR_ABNORMAL = 141;
    public static final int ERROR_UNSUPPORT = 254;
    public static final int BTBASE_UNAVAILABLE = 153;
    public static final int BTBASE_CONNECTED = 0;
    public static final int BTBASE_DISENABLE = 256;
    public static final int BTBASE_UNPAIRED = 257;
    public static final int BTBASE_DISCONNECT = 258;
    public static final int BTBASE_CONNECT_FAIL = 259;
    public static final int BTBASE_SET_FAIL = 260;
    public static final int BTBASE_ERROR_PARAM = 261;
    public static final int BTBASE_COMM_OCCUPIED = 263;
    private String deviceName;
    private String packageName;
    private volatile boolean isOpen;
    private MasterController mMCtl = MasterController.getInstance();

    public VBTSerialPort(String deviceName) {
        this.deviceName = deviceName;
        this.packageName = MasterController.getInstance().getDefaultAppName();
    }

    public int open(final int bps, final int par, final int dps) {
        int ret = new RemoteInvoker(){

            @Override
            protected void onRequest(Parcel data) {
                data.writeInt(bps);
                data.writeInt(par);
                data.writeInt(dps);
            }
        }.invoke(4865);
        this.isOpen = ret == 0;
        return ret;
    }

    public int close() {
        if (!this.isOpen) {
            return 139;
        }
        int ret = new RemoteInvoker(){}.invoke(4866);
        if (ret == 0) {
            this.isOpen = false;
        }
        return ret;
    }

    public int write(final byte[] sendData, final int timeout) {
        Precondition.checkArgument(timeout >= 0, "timeout can't be negative!");
        if (!this.isOpen) {
            return 139;
        }
        return new RemoteInvoker(){

            @Override
            protected void onRequest(Parcel data) {
                data.writeByteArray(sendData);
                data.writeInt(timeout);
            }
        }.invoke(4867);
    }

    public int read(final int expectedLen, final BytesBuffer buffer, final int timeout) {
        Precondition.checkArgument(expectedLen >= 0, "expectedLen can't be negative!");
        Precondition.checkArgument(timeout >= 0, "timeout can't be negative!");
        if (!this.isOpen) {
            return 139;
        }
        return new RemoteInvoker(){

            @Override
            protected void onRequest(Parcel data) {
                data.writeInt(expectedLen);
                data.writeInt(timeout);
            }

            @Override
            protected void onResponse(Parcel reply) {
                if (buffer != null && reply.dataAvail() > 0) {
                    buffer.setData(reply.createByteArray());
                }
            }
        }.invoke(4868);
    }

    public boolean isBufferEmpty() {
        if (!this.isOpen) {
            return true;
        }
        final IntegerBuffer baseStatus = new IntegerBuffer();
        int ret = new RemoteInvoker(){

            @Override
            protected void onResponse(Parcel reply) {
                baseStatus.setData(reply.readInt());
            }
        }.invoke(4869);
        return ret == 0 ? baseStatus.getData() != 0 : true;
    }

    public int clearBuffer() {
        if (!this.isOpen) {
            return 139;
        }
        return new RemoteInvoker(){}.invoke(4870);
    }

    public int getBaseState() {
        final IntegerBuffer status = new IntegerBuffer();
        int ret = new RemoteInvoker(){

            @Override
            protected void onResponse(Parcel reply) {
                status.setData(reply.readInt());
            }
        }.invoke(4871);
        return ret == 0 ? status.getData() : ret;
    }

    private abstract class RemoteInvoker {
        private RemoteInvoker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final int invoke(int requestCode) {
            Parcel data = Parcel.obtain();
            Parcel reply = Parcel.obtain();
            try {
                data.writeByteArray(StringUtil.getGBK(VBTSerialPort.this.deviceName));
                this.onRequest(data);
                VBTSerialPort.this.mMCtl.request(VBTSerialPort.this.packageName, requestCode, data, reply);
                if (reply.dataAvail() == 0) {
                    logger.error("# RemoteInvoker | reply data error!", new Object[0]);
                    int n = 2;
                    return n;
                }
                int ret = reply.readInt();
                this.onResponse(reply);
                int n = ret;
                return n;
            }
            catch (RequestException e) {
                e.printStackTrace();
                int n = 2;
                return n;
            }
            finally {
                data.recycle();
                reply.recycle();
            }
        }

        protected void onRequest(Parcel data) {
        }

        protected void onResponse(Parcel reply) {
        }
    }
}

