/*
 * Decompiled with CFR 0.152.
 */
package com.landicorp.android.eptapi.device;

import android.app.Activity;
import android.os.Parcel;
import android.text.TextUtils;
import com.landicorp.android.eptapi.card.RFDriver;
import com.landicorp.android.eptapi.device.factory.CardDriverFactory;
import com.landicorp.android.eptapi.exception.RequestException;
import com.landicorp.android.eptapi.listener.RemoteListener;
import com.landicorp.android.eptapi.log.Logger;
import com.landicorp.android.eptapi.service.MasterController;
import com.landicorp.android.eptapi.service.ServiceVariable;
import com.landicorp.android.eptapi.utils.BytesBuffer;
import com.landicorp.android.eptapi.utils.DeviceKeys;
import com.landicorp.android.eptapi.utils.IntegerBuffer;
import com.landicorp.android.eptapi.utils.PausableHandler;
import com.landicorp.android.eptapi.utils.Precondition;
import com.landicorp.android.eptapi.utils.StringUtil;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class RFCardReader {
    static final Logger logger = Logger.getLogger(RFCardReader.class);
    public static final int OPEN_MODE_TYPEA = 0;
    public static final int OPEN_MODE_TYPEB = 8;
    public static final int OPEN_MODE_TYPEF = 16;
    public static final int LED_YELLOW = 0;
    public static final int LED_BLUE = 1;
    public static final int LED_GREEN = 2;
    public static final int LED_RED = 3;
    public static final int POLL_CARD_MODE_DEFAULT = 0;
    public static final int POLL_CARD_MODE_MULCARD = 1;
    private static final int POLL_CARD_MODE_VAS = 2;
    private static final int POLL_CARD_MODE_VAS_TYPE = 12;
    private static final int POLL_CARD_MODE_FELICA = 16;
    public static final int POLL_CARD_MODE_ULTRALIGHT = 32;
    private static final int POLL_CARD_MODE_ALL = 62;
    public static final int ERROR_NONE = 0;
    public static final int ERROR_FAIL = 1;
    public static final int ERROR_COMMAND = 136;
    public static final int ERROR_DEVICE_USED = 137;
    public static final int ERROR_PARAM = 139;
    public static final int ERROR_DEVICE_DISABLE = 141;
    public static final int ERROR_TRANSERR = 162;
    public static final int ERROR_PROTERR = 163;
    public static final int ERROR_MULTIERR = 164;
    public static final int ERROR_CARDTIMEOUT = 167;
    public static final int ERROR_CARDNOACT = 179;
    public static final int ERROR_NOCARD = 165;
    public static final int CARD_TYPE_S50 = 0;
    public static final int CARD_TYPE_S70 = 1;
    public static final int CARD_TYPE_PRO = 2;
    public static final int CARD_TYPE_S50_PRO = 3;
    public static final int CARD_TYPE_S70_PRO = 4;
    public static final int CARD_TYPE_TYPEB = 5;
    private static final int CARD_TYPE_VAS = 6;
    private static final int CARD_TYPE_FELICA = 7;
    public static final int CARD_TYPE_ULTRALIGHT = 8;
    public static final String CARD_DRIVER_S50 = "S50";
    public static final String CARD_DRIVER_S70 = "S70";
    public static final String CARD_DRIVER_PRO = "PRO";
    public static final String CARD_DRIVER_TYPEB = "CPU";
    private static final String CARD_DRIVER_VAS = "VAS";
    private static final String CARD_DRIVER_FELICA = "FELICA";
    public static final String CARD_DRIVER_ULTRALIGHT = "ULTRALIGHT";
    public static final int IOCTRL_CMD_POLLDETECT = 1;
    public static final int IOCTRL_CMD_CLASSICFORMAT = 2;
    public static final int IOCTRL_CMD_APDUFORMAT = 3;
    public static final int POWER_SAVE_CONFIG = 1;
    public static final int POWER_SAVE_POLL_FACTOR = 2;
    public static final int POWER_SAVE_CARRIER_TIMEOUT = 3;
    public static final int PARAM_FSDI = 1;
    public static final int PARAM_RXCONTROL2 = 2;
    public static final int PARAM_RXTHRESHOLD_A = 3;
    public static final int PARAM_RXTHRESHOLD_B = 4;
    public static final int PARAM_MODCONDUCTANCE = 5;
    public static final int PARAM_RXWAIT_A = 6;
    public static final int PARAM_RXWAIT_B = 7;
    public static final int PARAM_MFOUTSELECT = 8;
    public static final int PARAM_TESTDIGISELECT = 9;
    public static final int PARAM_TESTANASELECT = 10;
    public static final int PARAM_HIGHBAUDRATE_ENABLE = 11;
    public static final int PARAM_SETCARDTYPE = 13;
    public static final int PARAM_EMVCONFIG = 14;
    public static final int PARAM_SETFSC = 15;
    public static final int PARAM_GAINA = 16;
    public static final int PARAM_GAINB = 17;
    public static final int PARAM_CIDSUPPORT = 18;
    public static final int PARAM_TYPEBCONFIG = 12;
    public static final String DEVICE_INTERNAL = "USERCARD";
    public static final String DEVICE_EXTERNAL = "EXTRFCARD";
    @Deprecated
    public static final String EXTRFCOM_READER_PREFIX = "EXTRFCOM";
    @Deprecated
    public static final String USER_CARD = "USERCARD";
    private static final Map<String, RFCardReader> INSTANCES = new ConcurrentHashMap<String, RFCardReader>();
    private int mOnSearchListenerID = 0;
    private int mOnActivateListenerID = 0;
    private int mOnIOCtlListenerID = 0;
    private String deviceName = "USERCARD";
    private MasterController mMCtl = MasterController.getInstance();
    private String packageName;

    private RFCardReader() {
        this("USERCARD");
    }

    private RFCardReader(String deviceName) {
        this.deviceName = deviceName;
    }

    public static RFCardReader getInstance() {
        return RFCardReader.getInstance(MasterController.getInstance().getDefaultAppName(), "USERCARD");
    }

    public static RFCardReader getInstance(String packageName) {
        return RFCardReader.getInstance(packageName, "USERCARD");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RFCardReader getInstance(String packageName, String deviceName) {
        Precondition.checkNotEmpty(packageName);
        Precondition.checkNotEmpty(deviceName);
        Map<String, RFCardReader> map = INSTANCES;
        synchronized (map) {
            String key = DeviceKeys.createKey(packageName, deviceName);
            if (INSTANCES.containsKey(key)) {
                return INSTANCES.get(key);
            }
            RFCardReader rfCardReader = new RFCardReader(deviceName);
            rfCardReader.packageName = packageName;
            INSTANCES.put(key, rfCardReader);
            return rfCardReader;
        }
    }

    public static synchronized RFCardReader getOtherInstance(String deviceName) {
        return RFCardReader.getInstance(MasterController.getInstance().getDefaultAppName(), deviceName);
    }

    public static synchronized RFCardReader getOtherInstance(String packageName, String deviceName) {
        return RFCardReader.getInstance(packageName, deviceName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeInstance(String packageName) {
        Map<String, RFCardReader> map = INSTANCES;
        synchronized (map) {
            for (String key : INSTANCES.keySet()) {
                RFCardReader rfCardReader;
                if (!DeviceKeys.matchPackageName(key, packageName) || (rfCardReader = INSTANCES.remove(key)) == null) continue;
                rfCardReader.stopIoctlLocal();
                rfCardReader.stopSearchLocal();
                rfCardReader.stopActivateLocal();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int openDevice(int openMode) throws RequestException {
        Parcel data = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        try {
            data.writeInt(openMode);
            data.writeByteArray(StringUtil.getGBK(this.deviceName));
            MasterController.getInstance().request(this.packageName, 533, data, reply);
            int n = reply.readInt();
            return n;
        }
        finally {
            data.recycle();
            reply.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int closeDevice() throws RequestException {
        Parcel data = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        try {
            data.writeByteArray(StringUtil.getGBK(this.deviceName));
            MasterController.getInstance().request(this.packageName, 534, data, reply);
            int n = reply.readInt();
            return n;
        }
        finally {
            data.recycle();
            reply.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setParameter(int paramName, int value) {
        Parcel data = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        try {
            data.writeInt(paramName);
            data.writeInt(value);
            data.writeByteArray(StringUtil.getGBK(this.deviceName));
            this.mMCtl.request(this.packageName, 527, data, reply);
            boolean bl = reply.dataAvail() > 0 && reply.readInt() == 0;
            return bl;
        }
        catch (RequestException e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            data.recycle();
            reply.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setTime(int time) throws RequestException {
        Parcel data = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        try {
            data.writeInt(time);
            data.writeByteArray(StringUtil.getGBK(this.deviceName));
            this.mMCtl.request(this.packageName, 532, data, reply);
            int n = reply.readInt();
            return n;
        }
        finally {
            data.recycle();
            reply.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int pollCard(int pollMode, IntegerBuffer cardType) throws RequestException {
        Parcel data = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        try {
            data.writeByteArray(StringUtil.getGBK(this.deviceName));
            data.writeInt(pollMode);
            this.mMCtl.request(this.packageName, 540, data, reply);
            int retCode = reply.readInt();
            if (retCode == 0 && cardType != null) {
                cardType.setData(reply.readInt());
            }
            int n = retCode;
            return n;
        }
        finally {
            data.recycle();
            reply.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void searchCard(Activity a, OnSearchListener listener) throws RequestException {
        Precondition.checkNotNull(listener);
        if (null != ServiceVariable.getListener(this.packageName, this.mOnSearchListenerID)) {
            logger.error("### searchCard has not finished! ###", new Object[0]);
            listener.onFail(1);
            return;
        }
        OnSearchListener onSearchListener = listener;
        synchronized (onSearchListener) {
            if (listener.isStarted() && listener.getReader() != this) {
                throw new IllegalArgumentException("one listener cannot be used to listen two devices!");
            }
            listener.setReader(this);
            listener.setStarted(true);
            listener.setPackageName(this.packageName);
        }
        Parcel data = Parcel.obtain();
        data.writeByteArray(StringUtil.getGBK(this.deviceName));
        data.writeInt(0);
        data.writeInt(0);
        try {
            this.mMCtl.setTaskID(this.packageName, a);
            this.mOnSearchListenerID = ServiceVariable.saveListener(this.packageName, listener);
            this.mMCtl.requestCallback(this.packageName, 513, data, listener);
        }
        finally {
            data.recycle();
        }
    }

    public synchronized void searchCard(OnSearchListener listener) throws RequestException {
        this.searchCardInner(0, listener);
    }

    public synchronized void searchCard(OnSearchListenerEx listener) throws RequestException {
        this.searchCardInner(0, listener);
    }

    public synchronized void searchCard(int pollMode, OnSearchListener listener) throws RequestException {
        this.searchCardInner(pollMode, listener);
    }

    public synchronized void searchCard(int pollMode, OnSearchListenerEx listener) throws RequestException {
        this.searchCardInner(pollMode, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void searchCardInner(int pollMode, BaseSearchListener listener) throws RequestException {
        Precondition.checkNotNull(listener);
        if (null != ServiceVariable.getListener(this.packageName, this.mOnSearchListenerID)) {
            logger.error("### searchCard has not finished! ###", new Object[0]);
            listener.onFail(1);
            return;
        }
        BaseSearchListener baseSearchListener = listener;
        synchronized (baseSearchListener) {
            if (listener.isStarted() && listener.getReader() != this) {
                throw new IllegalArgumentException("one listener cannot be used to listen two devices!");
            }
            listener.setReader(this);
            listener.setStarted(true);
            listener.setPackageName(this.packageName);
        }
        Parcel data = Parcel.obtain();
        data.writeByteArray(StringUtil.getGBK(this.deviceName));
        data.writeInt(0);
        data.writeInt(pollMode);
        try {
            this.mMCtl.setTaskID(this.packageName, -1);
            this.mOnSearchListenerID = ServiceVariable.saveListener(this.packageName, listener);
            this.mMCtl.requestCallback(this.packageName, 513, data, listener);
        }
        finally {
            data.recycle();
        }
    }

    public synchronized void searchCardAndActivate(OnSearchAndActivateListener listener) throws RequestException {
        this.searchCardAndActivateInner(0, listener);
    }

    public synchronized void searchCardAndActivate(OnSearchAndActivateListenerEx listener) throws RequestException {
        this.searchCardAndActivateInner(0, listener);
    }

    public synchronized void searchCardAndActivate(int pollMode, OnSearchAndActivateListener listener) throws RequestException {
        this.searchCardAndActivateInner(pollMode, listener);
    }

    public synchronized void searchCardAndActivate(int pollMode, OnSearchAndActivateListenerEx listener) throws RequestException {
        this.searchCardAndActivateInner(pollMode, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void searchCardAndActivateInner(int pollMode, BaseSearchListener listener) throws RequestException {
        Precondition.checkNotNull(listener);
        if (null != ServiceVariable.getListener(this.packageName, this.mOnSearchListenerID)) {
            logger.error("### searchCardAndActivate has not finished! ###", new Object[0]);
            listener.onFail(1);
            return;
        }
        BaseSearchListener baseSearchListener = listener;
        synchronized (baseSearchListener) {
            if (listener.isStarted() && listener.getReader() != this) {
                throw new IllegalArgumentException("one listener cannot be used to listen two devices!");
            }
            listener.setReader(this);
            listener.setStarted(true);
            listener.setPackageName(this.packageName);
        }
        int[][] driverMap = new int[][]{{0, 0}, {1, 1}, {3, 2}, {4, 2}, {2, 2}, {5, 5}, {6, 6}, {7, 7}, {8, 8}};
        Parcel data = Parcel.obtain();
        data.writeByteArray(StringUtil.getGBK(this.deviceName));
        data.writeInt(driverMap.length);
        for (int i = 0; i < driverMap.length; ++i) {
            data.writeInt(driverMap[i][0]);
            data.writeInt(driverMap[i][1]);
        }
        data.writeInt(pollMode);
        try {
            this.mOnSearchListenerID = ServiceVariable.saveListener(this.packageName, listener);
            this.mMCtl.requestCallback(this.packageName, 513, data, listener);
        }
        finally {
            data.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean turnOnLed(int led) {
        Parcel data = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        try {
            data.writeInt(1);
            data.writeInt(led);
            data.writeByteArray(StringUtil.getGBK(this.deviceName));
            this.mMCtl.request(this.packageName, 526, data, reply);
            boolean bl = reply.dataAvail() > 0 && reply.readInt() == 0;
            return bl;
        }
        catch (RequestException e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            data.recycle();
            reply.recycle();
        }
    }

    public boolean trunOnLed(int led) {
        return this.turnOnLed(led);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean turnOffLed(int led) {
        Parcel data = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        try {
            data.writeInt(0);
            data.writeInt(led);
            data.writeByteArray(StringUtil.getGBK(this.deviceName));
            this.mMCtl.request(this.packageName, 526, data, reply);
            boolean bl = reply.dataAvail() > 0 && reply.readInt() == 0;
            return bl;
        }
        catch (RequestException e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            data.recycle();
            reply.recycle();
        }
    }

    public boolean trunOffLed(int led) {
        return this.turnOffLed(led);
    }

    public synchronized void stopSearch() throws RequestException {
        this.stopIoctlLocal();
        if (this.stopSearchLocal()) {
            Parcel data = Parcel.obtain();
            try {
                data.writeByteArray(StringUtil.getGBK(this.deviceName));
                this.mMCtl.request(this.packageName, 514, data);
            }
            finally {
                data.recycle();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exists() throws RequestException {
        Parcel reply = Parcel.obtain();
        Parcel data = Parcel.obtain();
        try {
            data.writeByteArray(StringUtil.getGBK(this.deviceName));
            this.mMCtl.request(this.packageName, 515, data, reply);
            boolean bl = reply.readInt() == 1;
            return bl;
        }
        finally {
            data.recycle();
            reply.recycle();
        }
    }

    public RFDriver getDriver(String driverName) {
        return CardDriverFactory.getInstance(this.packageName).createRFCardDriver(this.deviceName, driverName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int activate(String driverName, BytesBuffer responseData) throws RequestException {
        Precondition.checkNotEmpty(driverName);
        Precondition.checkNotNull(responseData);
        Parcel data = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        try {
            data.writeByteArray(StringUtil.getGBK(driverName));
            data.writeByteArray(StringUtil.getGBK(this.deviceName));
            this.mMCtl.request(this.packageName, 528, data, reply);
            int ret = reply.readInt();
            responseData.setData(reply.createByteArray());
            int n = ret;
            return n;
        }
        finally {
            data.recycle();
            reply.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int deactivate() throws RequestException {
        Parcel data = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        try {
            int ret;
            data.writeByteArray(StringUtil.getGBK(this.deviceName));
            this.mMCtl.request(this.packageName, 531, data, reply);
            int n = ret = reply.readInt();
            return n;
        }
        finally {
            data.recycle();
            reply.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void activate(String driverName, OnActiveListener listener) throws RequestException {
        Precondition.checkNotEmpty(driverName);
        Precondition.checkNotNull(listener);
        RFDriver driver = this.getDriver(driverName);
        if (driver == null) {
            listener.notifyUnsupport(driverName);
            return;
        }
        if (null != ServiceVariable.getListener(this.packageName, this.mOnActivateListenerID)) {
            logger.error("### activate has not finished! ###", new Object[0]);
            listener.onActivateError(1);
            return;
        }
        OnActiveListener onActiveListener = listener;
        synchronized (onActiveListener) {
            if (listener.isStarted() && listener.getReader() != this) {
                throw new IllegalArgumentException("one listener cannot be used to listen two devices!");
            }
            listener.setReader(this);
            listener.setStarted(true);
            listener.setPackageName(this.packageName);
        }
        listener.setDriver(driver);
        Parcel data = Parcel.obtain();
        try {
            data.writeByteArray(StringUtil.getGBK(driverName));
            data.writeByteArray(StringUtil.getGBK(this.deviceName));
            this.mOnActivateListenerID = ServiceVariable.saveListener(this.packageName, listener);
            this.mMCtl.requestCallback(this.packageName, 517, data, listener);
        }
        finally {
            data.recycle();
        }
    }

    private synchronized boolean stopSearchLocal() {
        Integer l = ServiceVariable.removeListener(this.packageName, this.mOnSearchListenerID);
        if (l == null) {
            return false;
        }
        this.mMCtl.uninstallListener(this.packageName, l);
        return true;
    }

    private synchronized void stopActivateLocal() {
        Integer listener = ServiceVariable.removeListener(this.packageName, this.mOnActivateListenerID);
        if (listener == null) {
            return;
        }
        this.mMCtl.uninstallListener(this.packageName, listener);
    }

    public synchronized void halt() throws RequestException {
        this.stopIoctlLocal();
        this.stopSearchLocal();
        this.stopActivateLocal();
        Parcel data = Parcel.obtain();
        try {
            data.writeByteArray(StringUtil.getGBK(this.deviceName));
            this.mMCtl.request(this.packageName, 514, data);
        }
        finally {
            data.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setPowerSave(int type, int value) throws RequestException {
        Parcel data = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        try {
            data.writeInt(type);
            data.writeInt(value);
            this.mMCtl.request(this.packageName, 538, data, reply);
            int n = reply.readInt();
            return n;
        }
        finally {
            data.recycle();
            reply.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPowerSave(int type, IntegerBuffer value) throws RequestException {
        Parcel data = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        try {
            data.writeInt(type);
            this.mMCtl.request(this.packageName, 539, data, reply);
            int ret = reply.readInt();
            if (ret == 0 && value != null) {
                value.setData(reply.readInt());
            }
            int n = ret;
            return n;
        }
        finally {
            data.recycle();
            reply.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int rfcardIOControl(int ioCmd, byte[] sendData, BytesBuffer recvData) throws RequestException {
        Parcel data = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        try {
            data.writeByteArray(StringUtil.getGBK(this.deviceName));
            data.writeInt(ioCmd);
            data.writeByteArray(sendData);
            this.mMCtl.request(this.packageName, 541, data, reply);
            int ret = reply.readInt();
            if (recvData != null) {
                recvData.setData(reply.createByteArray());
            }
            int n = ret;
            return n;
        }
        finally {
            data.recycle();
            reply.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int ioctl(int ioCmd, byte[] inData, BytesBuffer outData) throws RequestException {
        Parcel data = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        try {
            data.writeByteArray(StringUtil.getGBK(this.deviceName));
            data.writeInt(ioCmd);
            data.writeByteArray(inData);
            this.mMCtl.request(this.packageName, 541, data, reply);
            int ret = reply.readInt();
            if (outData != null) {
                outData.setData(reply.createByteArray());
            }
            int n = ret;
            return n;
        }
        finally {
            data.recycle();
            reply.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void ioctl(int ioCmd, byte[] inData, OnIOCtlListener listener) throws RequestException {
        Precondition.checkNotNull(listener);
        if (null != ServiceVariable.getListener(this.packageName, this.mOnIOCtlListenerID)) {
            logger.error("### ioctl has not finished! ###", new Object[0]);
            listener.onError(ioCmd, 1);
            return;
        }
        OnIOCtlListener onIOCtlListener = listener;
        synchronized (onIOCtlListener) {
            if (listener.isStarted() && listener.getReader() != this) {
                throw new IllegalArgumentException("one listener cannot be used to listen two devices!");
            }
            listener.setReader(this);
            listener.setStarted(true);
            listener.setPackageName(this.packageName);
        }
        Parcel data = Parcel.obtain();
        data.writeByteArray(StringUtil.getGBK(this.deviceName));
        data.writeInt(ioCmd);
        data.writeByteArray(inData);
        try {
            this.mMCtl.setTaskID(this.packageName, -1);
            this.mOnIOCtlListenerID = ServiceVariable.saveListener(this.packageName, listener);
            this.mMCtl.requestCallback(this.packageName, 542, data, listener);
        }
        finally {
            data.recycle();
        }
    }

    private synchronized void stopIoctlLocal() {
        Integer listener = ServiceVariable.removeListener(this.packageName, this.mOnIOCtlListenerID);
        if (listener != null) {
            this.mMCtl.uninstallListener(this.packageName, listener);
            return;
        }
    }

    public static abstract class OnIOCtlListener
    extends RemoteListener {
        static final int ID = 775;
        private RFCardReader reader;
        private boolean isStarted;

        public OnIOCtlListener() {
        }

        public OnIOCtlListener(PausableHandler handler) {
            super(handler);
        }

        public void setStarted(boolean b) {
            this.isStarted = b;
        }

        public boolean isStarted() {
            return this.isStarted;
        }

        @Override
        protected final void onListened(Parcel data) {
            this.stopIoctlInner();
            int errorCode = data.readInt();
            int ioCmd = data.readInt();
            if (errorCode == 0) {
                byte[] outData = data.createByteArray();
                String deviceName = data.readString();
                if (!TextUtils.isEmpty((CharSequence)deviceName) && !deviceName.equals(this.reader.deviceName)) {
                    this.onError(ioCmd, 1);
                    return;
                }
                this.onSuccess(ioCmd, outData);
            } else {
                this.onError(ioCmd, errorCode);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void stopIoctlInner() {
            RFCardReader reader = this.reader;
            OnIOCtlListener onIOCtlListener = this;
            synchronized (onIOCtlListener) {
                this.setStarted(false);
            }
            reader.stopIoctlLocal();
        }

        public abstract void onSuccess(int var1, byte[] var2);

        public abstract void onError(int var1, int var2);

        public RFCardReader getReader() {
            return this.reader;
        }

        void setReader(RFCardReader reader) {
            this.reader = reader;
        }

        @Override
        public final int getEventId() {
            return 775;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onDetached() {
            OnIOCtlListener onIOCtlListener = this;
            synchronized (onIOCtlListener) {
                this.setStarted(false);
            }
        }
    }

    public static abstract class OnSearchAndActivateListenerEx
    extends OnSearchListenerEx {
        boolean forSearch = true;

        public OnSearchAndActivateListenerEx(boolean runOnUi) {
            if (!runOnUi) {
                this.setRunOnIPCThread();
            }
        }

        public OnSearchAndActivateListenerEx() {
            this(true);
        }

        @Override
        public final void onCardPass(int cardType) {
            if (this.dataListened.dataAvail() > 0) {
                this.forSearch = false;
                int activateRet = this.dataListened.readInt();
                int driverType = this.dataListened.readInt();
                byte[] activateResp = this.dataListened.createByteArray();
                if (activateRet != 0) {
                    this.onActivateFail(activateRet);
                } else {
                    RFDriver driver = this.getCardDriver(driverType);
                    if (driver == null) {
                        this.onActivateUnsupport();
                    } else {
                        this.onSuccess(driver, activateResp);
                    }
                }
            } else {
                this.onActivateUnsupport();
            }
        }

        public abstract void onSuccess(RFDriver var1, byte[] var2);

        @Override
        public final void onFail(int error) {
            if (this.forSearch) {
                this.onSearchFail(error);
            } else {
                this.forSearch = true;
                this.onActivateFail(error);
            }
        }

        public abstract void onSearchFail(int var1);

        public abstract void onActivateFail(int var1);

        public void onActivateUnsupport() {
        }
    }

    public static abstract class OnSearchAndActivateListener
    extends OnSearchListener {
        boolean forSearch = true;

        public OnSearchAndActivateListener(boolean runOnUi) {
            if (!runOnUi) {
                this.setRunOnIPCThread();
            }
        }

        public OnSearchAndActivateListener() {
            this(true);
        }

        @Override
        public final void onCardPass(int cardType) {
            if (this.dataListened.dataAvail() > 0) {
                this.forSearch = false;
                int activateRet = this.dataListened.readInt();
                int driverType = this.dataListened.readInt();
                byte[] activateResp = this.dataListened.createByteArray();
                if (activateRet != 0) {
                    this.onActivateFail(activateRet);
                } else {
                    RFDriver driver = this.getCardDriver(driverType);
                    if (driver == null) {
                        this.onActivateUnsupport();
                    } else {
                        this.onSuccess(driver, activateResp);
                    }
                }
            } else {
                this.onActivateUnsupport();
            }
        }

        public abstract void onSuccess(RFDriver var1, byte[] var2);

        @Override
        public final void onFail(int error) {
            if (this.forSearch) {
                this.onSearchFail(error);
            } else {
                this.forSearch = true;
                this.onActivateFail(error);
            }
        }

        public abstract void onSearchFail(int var1);

        public abstract void onActivateFail(int var1);

        public void onActivateUnsupport() {
        }
    }

    public static abstract class OnSearchListenerEx
    extends BaseSearchListener {
        public static final int ID = 773;

        public OnSearchListenerEx() {
        }

        public OnSearchListenerEx(PausableHandler handler) {
            super(handler);
        }

        @Override
        public final int getEventId() {
            return 773;
        }
    }

    public static abstract class OnActiveListener
    extends RemoteListener {
        public static final int ERROR_TRANSERR = 162;
        public static final int ERROR_PROTERR = 163;
        public static final int ERROR_CARDTIMEOUT = 167;
        private static final int ID = 770;
        private RFDriver mDriver = null;
        private RFCardReader reader = null;
        private byte[] outData;
        private boolean started;

        public OnActiveListener() {
        }

        public OnActiveListener(PausableHandler handler) {
            super(handler);
        }

        public void setStarted(boolean b) {
            this.started = b;
        }

        public boolean isStarted() {
            return this.started;
        }

        void setReader(RFCardReader rfCardReader) {
            this.reader = rfCardReader;
        }

        public RFCardReader getReader() {
            return this.reader;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected final void onListened(Parcel data) {
            String deviceName;
            int errCode = data.readInt();
            byte[] outData = null;
            if (errCode == 0) {
                outData = data.createByteArray();
            }
            RFCardReader reader = this.reader;
            if (data.dataAvail() > 0 && !TextUtils.isEmpty((CharSequence)(deviceName = data.readString())) && !reader.deviceName.equals(deviceName)) {
                this.stopActivateHere(reader);
                this.onActivateError(1);
                return;
            }
            OnActiveListener onActiveListener = this;
            synchronized (onActiveListener) {
                this.setStarted(false);
            }
            this.stopActivateHere(reader);
            this.outData = outData;
            if (errCode != 0) {
                this.onActivateError(errCode);
            } else {
                this.onCardActivate(this.mDriver);
            }
        }

        private void stopActivateHere(RFCardReader reader) {
            if (reader != null) {
                reader.stopActivateLocal();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onDetached() {
            OnActiveListener onActiveListener = this;
            synchronized (onActiveListener) {
                this.setStarted(false);
            }
        }

        public byte[] getLastCardSerialNo() {
            if (this.outData == null) {
                throw new IllegalStateException("the card has not activated");
            }
            if (this.outData.length < 8) {
                return null;
            }
            byte atqa = this.outData[0];
            byte flag = (byte)(atqa >> 6 & 3);
            int uidNum = 0;
            if (flag == 0) {
                uidNum = 1;
            } else if (flag == 1) {
                uidNum = 2;
            } else if (flag == 2) {
                uidNum = 3;
            }
            if (uidNum == 0 || this.outData.length - 4 <= 0) {
                return null;
            }
            byte[] cardSerialNo = new byte[uidNum * 4];
            int offset = 2;
            int step = 0;
            for (int i = 0; i < uidNum; ++i) {
                System.arraycopy(this.outData, offset, cardSerialNo, step, 4);
                offset += 6;
                step += 4;
            }
            return cardSerialNo;
        }

        public byte[] getLastResponseData() {
            return this.outData;
        }

        public abstract void onCardActivate(RFDriver var1);

        public abstract void onActivateError(int var1);

        public abstract void onUnsupport(String var1);

        @Override
        public final int getEventId() {
            return 770;
        }

        protected final void notifyUnsupport(final String driverName) {
            this.post(new Runnable(){

                @Override
                public void run() {
                    OnActiveListener.this.onUnsupport(driverName);
                }
            });
        }

        protected final void setDriver(RFDriver driver) {
            this.mDriver = driver;
        }
    }

    public static abstract class OnSearchListener
    extends BaseSearchListener {
        public static final int ID = 769;

        @Override
        public final int getEventId() {
            return 769;
        }
    }

    private static abstract class BaseSearchListener
    extends RemoteListener {
        public static final int ERROR_TRANSERR = 162;
        public static final int ERROR_PROTERR = 163;
        public static final int ERROR_MULTIERR = 164;
        public static final int ERROR_CARDTIMEOUT = 167;
        public static final int ERROR_CARDNOACT = 179;
        public static final int ERROR_MUTILERR = 164;
        public static final int ERROR_FORBIDDEN = 1001;
        public static final int ERROR_INTERRUPTED = 1002;
        public static final int S50_CARD = 0;
        public static final int S70_CARD = 1;
        public static final int PRO_CARD = 2;
        public static final int S50_PRO_CARD = 3;
        public static final int S70_PRO_CARD = 4;
        @Deprecated
        public static final int CPU_CARD = 5;
        public static final int TYPEB_CARD = 5;
        public static final int VAS_CARD = 6;
        public static final int FELICA_CARD = 7;
        public static final int ULTRALIGHT_CARD = 8;
        private RFCardReader reader;
        private boolean isStarted;
        private int cardType;
        Parcel dataListened;

        public BaseSearchListener() {
        }

        public BaseSearchListener(PausableHandler handler) {
            super(handler);
        }

        public void setStarted(boolean b) {
            this.isStarted = b;
        }

        public boolean isStarted() {
            return this.isStarted;
        }

        @Override
        protected final void onListened(Parcel data) {
            this.dataListened = data;
            int errorCode = data.readInt();
            if (errorCode == 0) {
                String name;
                this.cardType = data.readInt();
                if (data.dataAvail() > 0 && !(name = data.readString()).equals(this.reader.deviceName)) {
                    this.onFail(1);
                    return;
                }
                this.stopSearchLocal();
                this.onCardPass(this.cardType);
            } else {
                this.stopSearchLocal();
                this.onFail(errorCode);
            }
            this.dataListened = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void stopSearchLocal() {
            RFCardReader reader = this.reader;
            BaseSearchListener baseSearchListener = this;
            synchronized (baseSearchListener) {
                this.setStarted(false);
            }
            reader.stopSearchLocal();
        }

        public abstract void onCardPass(int var1);

        public abstract void onFail(int var1);

        public int getCardType() {
            return this.cardType;
        }

        public RFCardReader getReader() {
            return this.reader;
        }

        void setReader(RFCardReader reader) {
            this.reader = reader;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onDetached() {
            BaseSearchListener baseSearchListener = this;
            synchronized (baseSearchListener) {
                this.setStarted(false);
            }
        }

        protected final RFDriver getCardDriver(int driverType) {
            switch (driverType) {
                case 0: {
                    return this.getReader().getDriver(RFCardReader.CARD_DRIVER_S50);
                }
                case 1: {
                    return this.getReader().getDriver(RFCardReader.CARD_DRIVER_S70);
                }
                case 2: {
                    return this.getReader().getDriver(RFCardReader.CARD_DRIVER_PRO);
                }
                case 5: {
                    return this.getReader().getDriver(RFCardReader.CARD_DRIVER_TYPEB);
                }
                case 6: {
                    return this.getReader().getDriver(RFCardReader.CARD_DRIVER_VAS);
                }
                case 7: {
                    return this.getReader().getDriver(RFCardReader.CARD_DRIVER_FELICA);
                }
                case 8: {
                    return this.getReader().getDriver(RFCardReader.CARD_DRIVER_ULTRALIGHT);
                }
            }
            return null;
        }
    }
}

