/*
 * Decompiled with CFR 0.152.
 */
package com.landicorp.android.eptapi.device;

import android.app.Activity;
import android.os.Parcel;
import com.landicorp.android.eptapi.card.InsertDriver;
import com.landicorp.android.eptapi.device.factory.CardDriverFactory;
import com.landicorp.android.eptapi.exception.RequestException;
import com.landicorp.android.eptapi.listener.RemoteListener;
import com.landicorp.android.eptapi.log.Logger;
import com.landicorp.android.eptapi.service.MasterController;
import com.landicorp.android.eptapi.service.ServiceVariable;
import com.landicorp.android.eptapi.utils.BytesBuffer;
import com.landicorp.android.eptapi.utils.DeviceKeys;
import com.landicorp.android.eptapi.utils.PausableHandler;
import com.landicorp.android.eptapi.utils.Precondition;
import com.landicorp.android.eptapi.utils.StringUtil;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class InsertCardReader {
    static final Logger logger = Logger.getLogger(InsertCardReader.class);
    public static final int ERROR_NONE = 0;
    public static final int ERROR_ERROR = 1;
    public static final int ERROR_NOCARD = 251;
    public static final int ERROR_PARAM = 139;
    public static final int ERROR_FAILED = 143;
    public static final int ERROR_TIMEOUT = 138;
    public static final int ERROR_NEEDRESTART = 193;
    protected static final int IOCTL_CMD_ICCARD_WEAKUP = 1;
    public static final int IOCTL_CMD_SYNC_4428SETATRDATA = 4353;
    public static final int IOCTL_CMD_SYNC_4428ATR_DISABLE = 4354;
    public static final int IOCTL_CMD_SYNC_4428ATR_DEFAULT = 4355;
    public static final int IOCTL_CMD_SYNC_4442SETATRDATA = 4609;
    protected static final int IOCTL_CMD_SYNC_1604SETATRDATA = 4865;
    protected static final int IOCTL_CMD_SYNC_1608SETATRDATA = 5121;
    protected static final int IOCTL_CMD_SYNC_24CXXSETATRDATA = 5377;
    public static final String MASTER_CARD_READER = "MASTERCARD";
    public static final String USER_CARD = "USERCARD";
    private static Map<String, InsertCardReader> sInstances = new ConcurrentHashMap<String, InsertCardReader>();
    private String deviceName;
    private String packageName;
    private int mOnSearchListenerID = 0;
    private MasterController mMCtl = MasterController.getInstance();

    public static InsertCardReader getInstance() {
        return InsertCardReader.getInstance(MasterController.getInstance().getDefaultAppName(), USER_CARD);
    }

    public static InsertCardReader getInstance(String packageName) {
        return InsertCardReader.getInstance(packageName, USER_CARD);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InsertCardReader getInstance(String packageName, String deviceName) {
        Precondition.checkNotEmpty(packageName);
        Precondition.checkNotEmpty(deviceName);
        Map<String, InsertCardReader> map = sInstances;
        synchronized (map) {
            String key = DeviceKeys.createKey(packageName, deviceName);
            if (sInstances.containsKey(key)) {
                return sInstances.get(key);
            }
            InsertCardReader reader = new InsertCardReader(deviceName);
            reader.deviceName = deviceName;
            reader.packageName = packageName;
            sInstances.put(key, reader);
            return reader;
        }
    }

    public static InsertCardReader getOtherInstance(String deviceName) {
        return InsertCardReader.getInstance(MasterController.getInstance().getDefaultAppName(), deviceName);
    }

    public static InsertCardReader getOtherInstance(String packageName, String deviceName) {
        return InsertCardReader.getInstance(packageName, deviceName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeInstance(String packageName) {
        Map<String, InsertCardReader> map = sInstances;
        synchronized (map) {
            for (String key : sInstances.keySet()) {
                InsertCardReader reader;
                if (!DeviceKeys.matchPackageName(key, packageName) || (reader = sInstances.remove(key)) == null) continue;
                reader.stopSearchLocal();
            }
        }
    }

    private InsertCardReader() {
        this(USER_CARD);
    }

    private InsertCardReader(String deviceName) {
        this.deviceName = deviceName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void searchCard(Activity a, OnSearchListener listener) throws RequestException {
        Precondition.checkNotNull(listener);
        if (null != ServiceVariable.getListener(this.packageName, this.mOnSearchListenerID)) {
            logger.error("### searchCard has not finished! ###", new Object[0]);
            listener.onFail(143);
            return;
        }
        OnSearchListener onSearchListener = listener;
        synchronized (onSearchListener) {
            if (listener.isStarted() && listener.getReader() != this) {
                throw new IllegalArgumentException("one listener cannot be used to listen two devices!");
            }
            listener.setReader(this);
            listener.setStarted(true);
            listener.setPackageName(this.packageName);
        }
        Parcel data = Parcel.obtain();
        data.writeByteArray(StringUtil.getGBK(this.deviceName));
        try {
            this.mMCtl.setTaskID(this.packageName, a);
            this.mOnSearchListenerID = ServiceVariable.saveListener(this.packageName, listener);
            this.mMCtl.requestCallback(this.packageName, 769, data, listener);
        }
        finally {
            data.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void searchCard(OnSearchListener listener) throws RequestException {
        Precondition.checkNotNull(listener);
        if (null != ServiceVariable.getListener(this.packageName, this.mOnSearchListenerID)) {
            logger.error("### searchCard has not finished! ###", new Object[0]);
            listener.onFail(143);
            return;
        }
        OnSearchListener onSearchListener = listener;
        synchronized (onSearchListener) {
            if (listener.isStarted() && listener.getReader() != this) {
                throw new IllegalArgumentException("one listener cannot be used to listen two devices!");
            }
            listener.setReader(this);
            listener.setStarted(true);
            listener.setDeviceName(this.deviceName);
            listener.setPackageName(this.packageName);
        }
        Parcel data = Parcel.obtain();
        data.writeByteArray(StringUtil.getGBK(this.deviceName));
        try {
            this.mMCtl.setTaskID(this.packageName, -1);
            this.mOnSearchListenerID = ServiceVariable.saveListener(this.packageName, listener);
            this.mMCtl.requestCallback(this.packageName, 769, data, listener);
        }
        finally {
            data.recycle();
        }
    }

    public synchronized void stopSearch() throws RequestException {
        if (this.stopSearchLocal()) {
            Parcel data = Parcel.obtain();
            try {
                data.writeByteArray(StringUtil.getGBK(this.deviceName));
                this.mMCtl.request(this.packageName, 770, data);
            }
            finally {
                data.recycle();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCardExists() throws RequestException {
        Parcel reply = Parcel.obtain();
        Parcel data = Parcel.obtain();
        try {
            data.writeByteArray(StringUtil.getGBK(this.deviceName));
            this.mMCtl.request(this.packageName, 771, data, reply);
            boolean bl = reply.readInt() == 1;
            return bl;
        }
        finally {
            data.recycle();
            reply.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int ioctl(int ioCmd, byte[] inData, BytesBuffer outData) throws RequestException {
        Parcel data = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        try {
            data.writeByteArray(StringUtil.getGBK(this.deviceName));
            data.writeInt(ioCmd);
            data.writeByteArray(inData);
            this.mMCtl.request(this.packageName, 929, data, reply);
            int ret = reply.readInt();
            if (outData != null) {
                outData.setData(reply.createByteArray());
            }
            int n = ret;
            return n;
        }
        finally {
            data.recycle();
            reply.recycle();
        }
    }

    public InsertDriver getDriver(String driverName) {
        return CardDriverFactory.getInstance(this.packageName).createInsertCardDriver(this.deviceName, driverName);
    }

    private synchronized boolean stopSearchLocal() {
        Integer l = ServiceVariable.removeListener(this.packageName, this.mOnSearchListenerID);
        if (l == null) {
            return false;
        }
        this.mMCtl.uninstallListener(this.packageName, l);
        return true;
    }

    public static abstract class OnSearchListener
    extends RemoteListener {
        private static final int ID = 1025;
        public static final int ERROR_FAILED = 143;
        public static final int ERROR_TIMEOUT = 138;
        public static final int ERROR_FORBIDDEN = 1001;
        public static final int ERROR_INTERRUPTED = 1002;
        private InsertCardReader reader;
        private boolean started;
        private String deviceName;

        public OnSearchListener() {
        }

        public OnSearchListener(PausableHandler handler) {
            super(handler);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected final void onListened(Parcel data) {
            String respDeviceName;
            int errcode = data.readInt();
            if (data.dataAvail() > 0 && !(respDeviceName = data.readString()).equals(this.deviceName)) {
                return;
            }
            InsertCardReader reader = this.reader;
            OnSearchListener onSearchListener = this;
            synchronized (onSearchListener) {
                this.setStarted(false);
            }
            reader.stopSearchLocal();
            if (errcode == 0) {
                this.onCardInsert();
            } else {
                this.onFail(errcode);
            }
        }

        void setReader(InsertCardReader reader) {
            this.reader = reader;
        }

        public InsertCardReader getReader() {
            return this.reader;
        }

        void setStarted(boolean started) {
            this.started = started;
        }

        boolean isStarted() {
            return this.started;
        }

        public abstract void onCardInsert();

        public abstract void onFail(int var1);

        @Override
        public int getEventId() {
            return 1025;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onDetached() {
            OnSearchListener onSearchListener = this;
            synchronized (onSearchListener) {
                this.setStarted(false);
            }
        }

        public String getDeviceName() {
            return this.deviceName;
        }

        public void setDeviceName(String deviceName) {
            this.deviceName = deviceName;
        }
    }
}

