/*
 * Decompiled with CFR 0.152.
 */
package com.landicorp.android.eptapi.device;

import android.os.Parcel;
import com.landicorp.android.eptapi.exception.RequestException;
import com.landicorp.android.eptapi.listener.RemoteListener;
import com.landicorp.android.eptapi.service.MasterController;
import com.landicorp.android.eptapi.utils.Precondition;
import com.landicorp.android.eptapi.utils.StringUtil;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class InnerScanner {
    public static final int ERROR_NONE = 0;
    public static final int ERROR_FAILED = 143;
    public static final int ERROR_PARAM = 139;
    public static final int ERROR_OVERFLOW = 5;
    public static final int ERROR_EMPTY = 11;
    public static final int ERROR_DEVICE = 1;
    public static final int ERROR_NOINIT = 8;
    private static Map<String, InnerScanner> sInstances = new ConcurrentHashMap<String, InnerScanner>();
    private OnScanListener onScan;
    private OnScanInnerListener onScanInner = new OnScanInnerListener();
    private String packageName;

    private InnerScanner() {
    }

    public static InnerScanner getInstance() {
        return InnerScanner.getInstance(MasterController.getInstance().getDefaultAppName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InnerScanner getInstance(String packageName) {
        Precondition.checkNotEmpty(packageName);
        Map<String, InnerScanner> map = sInstances;
        synchronized (map) {
            if (sInstances.containsKey(packageName)) {
                return sInstances.get(packageName);
            }
            InnerScanner instance = new InnerScanner();
            instance.packageName = packageName;
            sInstances.put(packageName, instance);
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeInstance(String packageName) {
        Map<String, InnerScanner> map = sInstances;
        synchronized (map) {
            InnerScanner scanner;
            if (sInstances.containsKey(packageName) && (scanner = sInstances.remove(packageName)) != null) {
                scanner.stopListen();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setDevice(String deviceName, int mode) {
        Parcel data = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        try {
            data.writeByteArray(StringUtil.getGBK(deviceName));
            data.writeInt(mode);
            MasterController.getInstance().request(this.packageName, 1540, data, reply);
            int n = reply.readInt();
            return n;
        }
        catch (RequestException e) {
            e.printStackTrace();
            int n = 143;
            return n;
        }
        finally {
            data.recycle();
            reply.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(int timeout) {
        Parcel data = Parcel.obtain();
        data.writeInt(timeout);
        try {
            MasterController.getInstance().installListener(this.packageName, this.onScanInner);
            MasterController.getInstance().request(this.packageName, 1537, data, null, this.onScanInner);
        }
        catch (RequestException requestException) {
        }
        finally {
            data.recycle();
        }
    }

    public void stop() {
        Parcel reply = Parcel.obtain();
        try {
            MasterController.getInstance().request(this.packageName, 1538, null, reply);
        }
        catch (RequestException e) {
            this.onScanInner.onCrash();
        }
        finally {
            reply.recycle();
        }
    }

    public void setOnScanListener(OnScanListener onScanListener) {
        this.onScan = onScanListener;
    }

    public void stopListen() {
        this.setOnScanListener(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setParameter(byte[] param) {
        Parcel data = Parcel.obtain();
        data.writeByteArray(param);
        Parcel reply = Parcel.obtain();
        try {
            MasterController.getInstance().request(this.packageName, 1539, data, reply);
            int n = reply.readInt();
            return n;
        }
        catch (RequestException e) {
            this.onScanInner.onCrash();
        }
        finally {
            data.recycle();
            reply.recycle();
        }
        return -1;
    }

    private class OnScanInnerListener
    extends RemoteListener {
        @Override
        public final int getEventId() {
            return 1281;
        }

        @Override
        protected final void onListened(Parcel data) {
            MasterController.getInstance().uninstallListener(InnerScanner.this.packageName, this);
            int ret = data.readInt();
            if (ret == 0) {
                byte[] d = data.createByteArray();
                String encoding = StringUtil.guessEncoding(d);
                if (encoding == null) {
                    this.onScanUnknowEncoding(d);
                } else {
                    try {
                        this.onScanSuccess(new String(d, encoding));
                    }
                    catch (UnsupportedEncodingException e) {
                        this.onScanUnknowEncoding(d);
                    }
                }
            } else {
                this.onScanFail(ret);
            }
        }

        public void onScanSuccess(String code) {
            if (InnerScanner.this.onScan != null) {
                InnerScanner.this.onScan.onScanSuccess(code);
            }
        }

        public void onScanUnknowEncoding(byte[] data) {
            if (InnerScanner.this.onScan != null && InnerScanner.this.onScan instanceof UnknownDataSupportable) {
                ((UnknownDataSupportable)((Object)InnerScanner.this.onScan)).onScanUnknownData(data);
            }
        }

        public void onScanFail(int error) {
            if (InnerScanner.this.onScan != null) {
                InnerScanner.this.onScan.onScanFail(error);
            }
        }

        @Override
        public void onCrash() {
            if (InnerScanner.this.onScan != null) {
                InnerScanner.this.onScan.onCrash();
            }
        }
    }

    public static interface UnknownDataSupportable {
        public void onScanUnknownData(byte[] var1);
    }

    public static interface OnScanListener {
        public static final int ERROR_TIMEOUT = 3;
        public static final int ERROR_FAIL = 143;

        public void onScanSuccess(String var1);

        public void onScanFail(int var1);

        public void onCrash();
    }
}

