/*
 * Decompiled with CFR 0.152.
 */
package com.landicorp.android.eptapi.device;

import android.os.Parcel;
import com.landicorp.android.eptapi.exception.RequestException;
import com.landicorp.android.eptapi.listener.RemoteListener;
import com.landicorp.android.eptapi.log.Logger;
import com.landicorp.android.eptapi.service.MasterController;
import com.landicorp.android.eptapi.service.ServiceVariable;
import com.landicorp.android.eptapi.utils.BytesBuffer;
import com.landicorp.android.eptapi.utils.BytesUtil;
import com.landicorp.android.eptapi.utils.PausableHandler;
import com.landicorp.android.eptapi.utils.Precondition;
import com.landicorp.android.eptapi.utils.StringUtil;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class IDCardReader {
    static final Logger logger = Logger.getLogger(IDCardReader.class);
    public static final int ERROR_NONE = 0;
    public static final int ERROR_FAIL = 1;
    public static final int ERROR_TIMEOUT = 161;
    public static final int ERROR_TRANERR = 162;
    public static final int ERROR_INVALID = 139;
    public static final int PARAM_RXCONTROL2 = 2;
    public static final int PARAM_RXTHRESHOLD_A = 3;
    public static final int PARAM_RXTHRESHOLD_B = 4;
    public static final int PARAM_MODCONDUCTANCE = 5;
    public static final int PARAM_RXWAIT_A = 6;
    public static final int PARAM_RXWAIT_B = 7;
    public static final int PARAM_HIGHBAUDRATE_ENABLE = 11;
    private static Map<String, IDCardReader> sInstances = new ConcurrentHashMap<String, IDCardReader>();
    private String deviceName;
    private String packageName;
    private int mOnSearchListenerID = 0;

    public static IDCardReader getInstance() {
        return IDCardReader.getInstance(MasterController.getInstance().getDefaultAppName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IDCardReader getInstance(String packageName) {
        Precondition.checkNotEmpty(packageName);
        Map<String, IDCardReader> map = sInstances;
        synchronized (map) {
            if (sInstances.containsKey(packageName)) {
                return sInstances.get(packageName);
            }
            IDCardReader instance = new IDCardReader();
            instance.packageName = packageName;
            sInstances.put(packageName, instance);
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeInstance(String packageName) {
        Map<String, IDCardReader> map = sInstances;
        synchronized (map) {
            IDCardReader reader;
            if (sInstances.containsKey(packageName) && (reader = sInstances.remove(packageName)) != null) {
                reader.stopSearchLocal();
            }
        }
    }

    private IDCardReader() {
        this("SAMV");
    }

    private IDCardReader(String deviceName) {
        this.deviceName = deviceName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setParameter(int paramName, int value) {
        Parcel data = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        try {
            data.writeInt(paramName);
            data.writeInt(value);
            MasterController.getInstance().request(this.packageName, 527, data, reply);
            boolean bl = reply.dataAvail() > 0 && reply.readInt() == 0;
            return bl;
        }
        catch (RequestException e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            data.recycle();
            reply.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void searchCard(OnSearchListener listener) throws RequestException {
        Precondition.checkNotNull(listener);
        if (null != ServiceVariable.getListener(this.packageName, this.mOnSearchListenerID)) {
            logger.error("### searchCard has not finished! ###", new Object[0]);
            listener.onFail(1);
            return;
        }
        OnSearchListener onSearchListener = listener;
        synchronized (onSearchListener) {
            if (listener.isStarted()) {
                throw new IllegalArgumentException("one listener cannot be used to listen two devices!");
            }
            listener.setReader(this);
            listener.setStarted(true);
            listener.setPackageName(this.packageName);
        }
        Parcel data = this.obtainRequestData();
        try {
            this.mOnSearchListenerID = ServiceVariable.saveListener(this.packageName, listener);
            MasterController.getInstance().requestCallback(this.packageName, 1793, data, listener);
        }
        finally {
            data.recycle();
        }
    }

    public synchronized void stopSearch() throws RequestException {
        if (this.stopSearchLocal()) {
            Parcel data = this.obtainRequestData();
            try {
                MasterController.getInstance().request(this.packageName, 1803, data);
            }
            finally {
                data.recycle();
            }
        }
    }

    private synchronized boolean stopSearchLocal() {
        Integer l = ServiceVariable.removeListener(this.packageName, this.mOnSearchListenerID);
        if (l == null) {
            return false;
        }
        MasterController.getInstance().uninstallListener(this.packageName, l);
        return true;
    }

    private Parcel obtainRequestData() {
        Parcel data = Parcel.obtain();
        data.writeByteArray(StringUtil.getGBK(this.deviceName));
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int reset() throws RequestException {
        Parcel data = this.obtainRequestData();
        Parcel reply = Parcel.obtain();
        try {
            MasterController.getInstance().request(this.packageName, 1797, data, reply);
            int n = reply.readInt();
            return n;
        }
        finally {
            data.recycle();
            reply.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int coldReset() throws RequestException {
        Parcel data = this.obtainRequestData();
        Parcel reply = Parcel.obtain();
        try {
            reply = Parcel.obtain();
            MasterController.getInstance().request(this.packageName, 1798, data, reply);
            int n = reply.readInt();
            return n;
        }
        finally {
            data.recycle();
            reply.recycle();
        }
    }

    public IDCardInfo readCardInfo() throws RequestException {
        return this.readCardInfo(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IDCardInfo readCardInfo(boolean needConvertImage) throws RequestException {
        Parcel data = this.obtainRequestData();
        Parcel reply = Parcel.obtain();
        try {
            MasterController.getInstance().request(this.packageName, 1794, data, reply);
            int ret = reply.readInt();
            IDCardInfo info = new IDCardInfo();
            if (ret == 0) {
                info.setData(reply.createByteArray());
                if (needConvertImage) {
                    data.recycle();
                    data = this.obtainRequestData();
                    data.writeByteArray(info.getPicture());
                    reply.setDataPosition(0);
                    MasterController.getInstance().request(this.packageName, 1805, data, reply);
                    if (0 == reply.readInt()) {
                        IDCardInfo.access$102(info, reply.createByteArray());
                    }
                }
            }
            info.setErrorCode(ret);
            IDCardInfo iDCardInfo = info;
            return iDCardInfo;
        }
        finally {
            data.recycle();
            reply.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int checkStatus() throws RequestException {
        Parcel data = this.obtainRequestData();
        Parcel reply = Parcel.obtain();
        try {
            MasterController.getInstance().request(this.packageName, 1799, data, reply);
            int n = reply.readInt();
            return n;
        }
        finally {
            data.recycle();
            reply.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getControlVersion(BytesBuffer buffer) throws RequestException {
        Parcel data = this.obtainRequestData();
        Parcel reply = Parcel.obtain();
        try {
            MasterController.getInstance().request(this.packageName, 1800, data, reply);
            int ret = reply.readInt();
            if (ret == 0) {
                buffer.setData(reply.createByteArray());
            }
            int n = ret;
            return n;
        }
        finally {
            data.recycle();
            reply.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int readControlData(BytesBuffer buffer) throws RequestException {
        Parcel data = this.obtainRequestData();
        Parcel reply = Parcel.obtain();
        try {
            MasterController.getInstance().request(this.packageName, 1801, data, reply);
            int ret = reply.readInt();
            if (ret == 0) {
                buffer.setData(reply.createByteArray());
            }
            int n = ret;
            return n;
        }
        finally {
            data.recycle();
            reply.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int selectCard(BytesBuffer buffer) throws RequestException {
        Parcel data = this.obtainRequestData();
        Parcel reply = Parcel.obtain();
        try {
            MasterController.getInstance().request(this.packageName, 1802, data, reply);
            int ret = reply.readInt();
            if (ret == 0 && buffer != null) {
                buffer.setData(reply.createByteArray());
            }
            int n = ret;
            return n;
        }
        finally {
            data.recycle();
            reply.recycle();
        }
    }

    public int selectCard() throws RequestException {
        return this.selectCard(null);
    }

    public void doFinal() throws RequestException {
        Parcel data = this.obtainRequestData();
        try {
            MasterController.getInstance().request(this.packageName, 1804, data);
        }
        finally {
            data.recycle();
        }
    }

    public class IDCardInfo {
        private String name;
        private String sex;
        private String nation;
        private String birthday;
        private String address;
        private String idcode;
        private String department;
        private String sdate;
        private String tdate;
        private byte[] picData;
        private byte[] fingerPrint;
        private int error;

        private IDCardInfo() {
        }

        void setErrorCode(int error) {
            this.error = error;
        }

        public int getErrorCode() {
            return this.error;
        }

        public boolean isValid() {
            return this.idcode != null;
        }

        public String getName() {
            return this.name;
        }

        public String getSex() {
            return this.sex;
        }

        public String getNation() {
            return this.nation;
        }

        public String getBirthday() {
            return this.birthday;
        }

        public String getAddress() {
            return this.address;
        }

        public String getIdCode() {
            return this.idcode;
        }

        public String getDepartment() {
            return this.department;
        }

        public String getSignDate() {
            return this.sdate;
        }

        public String getExpiredDate() {
            return this.tdate;
        }

        public byte[] getPicture() {
            return this.picData;
        }

        public byte[] getFingerPrint() {
            return this.fingerPrint;
        }

        public boolean hasFingerPrint() {
            return this.fingerPrint != null;
        }

        void setFingerPrint(byte[] fingerPrint) {
            this.fingerPrint = fingerPrint;
        }

        void setData(byte[] data) {
            int textLen = BytesUtil.bytesToInt(new byte[]{data[0], data[1]});
            int wltLen = BytesUtil.bytesToInt(new byte[]{data[2], data[3]});
            this.setTextInfo(BytesUtil.subBytes(data, 4, textLen));
            this.setPicture(BytesUtil.subBytes(data, 4 + textLen, wltLen));
            int fingerPrintOffset = 4 + textLen + wltLen;
            if (fingerPrintOffset + 2 > data.length) {
                return;
            }
            int fingerPrintLen = BytesUtil.bytesToInt(new byte[]{data[fingerPrintOffset], data[fingerPrintOffset + 1]});
            if (fingerPrintLen <= 0) {
                return;
            }
            this.setFingerPrint(BytesUtil.subBytes(data, fingerPrintOffset + 2, fingerPrintLen));
        }

        void setTextInfo(byte[] utf16Data) {
            String n;
            char[] strData = this.utf16ArrayToCharArray(utf16Data);
            this.name = new String(strData, 0, 15).trim();
            this.sex = new String(strData, 15, 1);
            this.nation = new String(strData, 16, 2).trim();
            this.birthday = new String(strData, 18, 8).trim();
            this.address = new String(strData, 26, 35).trim();
            this.idcode = new String(strData, 61, 18).trim();
            this.department = new String(strData, 79, 15).trim();
            this.sdate = new String(strData, 94, 8);
            this.tdate = new String(strData, 102, utf16Data.length >= 220 ? 8 : 4);
            String s = this.convertSex(Integer.parseInt(this.sex));
            if (s != null) {
                this.sex = s;
            }
            if ((n = this.convertNation(Integer.parseInt(this.nation))) != null) {
                this.nation = n;
            }
        }

        void setPicture(byte[] pictureData) {
            this.picData = pictureData;
        }

        private char[] utf16ArrayToCharArray(byte[] data) {
            char[] charArray = new char[data.length / 2];
            for (int i = 0; i < charArray.length; ++i) {
                charArray[i] = (char)((0xFF & data[2 * i + 1]) << 8 | 0xFF & data[2 * i]);
            }
            return charArray;
        }

        private String convertSex(int sex) {
            if (sex == 1) {
                return "\u7537";
            }
            if (sex == 2) {
                return "\u5973";
            }
            if (sex == 9) {
                return "\u5176\u4ed6";
            }
            return null;
        }

        private String convertNation(int nation) {
            switch (nation) {
                case 1: {
                    return "\u6c49";
                }
                case 2: {
                    return "\u8499\u53e4";
                }
                case 3: {
                    return "\u56de";
                }
                case 4: {
                    return "\u85cf";
                }
                case 5: {
                    return "\u7ef4\u543e\u5c14";
                }
                case 6: {
                    return "\u82d7";
                }
                case 7: {
                    return "\u5f5d";
                }
                case 8: {
                    return "\u58ee";
                }
                case 9: {
                    return "\u5e03\u4f9d";
                }
                case 10: {
                    return "\u671d\u9c9c";
                }
                case 11: {
                    return "\u6ee1";
                }
                case 12: {
                    return "\u4f97";
                }
                case 13: {
                    return "\u7476";
                }
                case 14: {
                    return "\u767d";
                }
                case 15: {
                    return "\u571f\u5bb6";
                }
                case 16: {
                    return "\u54c8\u5c3c";
                }
                case 17: {
                    return "\u54c8\u8428\u514b";
                }
                case 18: {
                    return "\u50a3";
                }
                case 19: {
                    return "\u9ece";
                }
                case 20: {
                    return "\u5088\u50f3";
                }
                case 21: {
                    return "\u4f64";
                }
                case 22: {
                    return "\u7572";
                }
                case 23: {
                    return "\u9ad8\u5c71";
                }
                case 24: {
                    return "\u62c9\u795c";
                }
                case 25: {
                    return "\u6c34";
                }
                case 26: {
                    return "\u4e1c\u4e61";
                }
                case 27: {
                    return "\u7eb3\u897f";
                }
                case 28: {
                    return "\u666f\u9887";
                }
                case 29: {
                    return "\u67ef\u5c14\u514b\u5b5c";
                }
                case 30: {
                    return "\u571f";
                }
                case 31: {
                    return "\u8fbe\u65a1\u5c14";
                }
                case 32: {
                    return "\u4eeb\u4f6c";
                }
                case 33: {
                    return "\u7f8c";
                }
                case 34: {
                    return "\u5e03\u6717";
                }
                case 35: {
                    return "\u6492\u62c9";
                }
                case 36: {
                    return "\u6bdb\u5357";
                }
                case 37: {
                    return "\u4ee1\u4f6c";
                }
                case 38: {
                    return "\u9521\u4f2f";
                }
                case 39: {
                    return "\u963f\u660c";
                }
                case 40: {
                    return "\u666e\u7c73";
                }
                case 41: {
                    return "\u5854\u5409\u514b";
                }
                case 42: {
                    return "\u6012";
                }
                case 43: {
                    return "\u4e4c\u5b5c\u522b\u514b";
                }
                case 44: {
                    return "\u4fc4\u7f57\u65af";
                }
                case 45: {
                    return "\u9102\u6e29\u514b";
                }
                case 46: {
                    return "\u5fb7\u6602";
                }
                case 47: {
                    return "\u4fdd\u5b89";
                }
                case 48: {
                    return "\u88d5\u56fa";
                }
                case 49: {
                    return "\u4eac";
                }
                case 50: {
                    return "\u5854\u5854\u5c14";
                }
                case 51: {
                    return "\u72ec\u9f99";
                }
                case 52: {
                    return "\u9102\u4f26\u6625";
                }
                case 53: {
                    return "\u8d6b\u54f2";
                }
                case 54: {
                    return "\u95e8\u5df4";
                }
                case 55: {
                    return "\u73de\u5df4";
                }
                case 56: {
                    return "\u57fa\u8bfa";
                }
            }
            return null;
        }

        public String toString() {
            return "IDCardInfo : " + this.idcode;
        }

        static /* synthetic */ byte[] access$102(IDCardInfo x0, byte[] x1) {
            x0.picData = x1;
            return x1;
        }
    }

    public static abstract class OnSearchListener
    extends RemoteListener {
        private static final int ID = 1793;
        public static final int ERROR_FAILED = 143;
        public static final int ERROR_TIMEOUT = 138;
        public static final int ERROR_TRANERR = 162;
        private IDCardReader reader;
        private boolean started;

        public OnSearchListener() {
        }

        public OnSearchListener(PausableHandler handler) {
            super(handler);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected final void onListened(Parcel data) {
            String dev = data.readString();
            if (!dev.equals(this.reader.deviceName)) {
                return;
            }
            IDCardReader reader = this.reader;
            OnSearchListener onSearchListener = this;
            synchronized (onSearchListener) {
                this.setStarted(false);
            }
            reader.stopSearchLocal();
            int errcode = data.readInt();
            if (errcode == 0) {
                this.onCardPass(data.createByteArray());
            } else {
                this.onFail(errcode);
            }
        }

        void setReader(IDCardReader device) {
            this.reader = device;
        }

        public IDCardReader getReader() {
            return this.reader;
        }

        void setStarted(boolean started) {
            this.started = started;
        }

        boolean isStarted() {
            return this.started;
        }

        public abstract void onCardPass(byte[] var1);

        public abstract void onFail(int var1);

        @Override
        public int getEventId() {
            return 1793;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onDetached() {
            OnSearchListener onSearchListener = this;
            synchronized (onSearchListener) {
                this.setStarted(false);
            }
        }
    }
}

