/*
 * Decompiled with CFR 0.152.
 */
package com.landicorp.android.eptapi.device;

import android.os.Parcel;
import com.landicorp.android.eptapi.exception.RequestException;
import com.landicorp.android.eptapi.log.Logger;
import com.landicorp.android.eptapi.service.MasterController;
import com.landicorp.android.eptapi.utils.BytesBuffer;
import com.landicorp.android.eptapi.utils.DeviceKeys;
import com.landicorp.android.eptapi.utils.IntegerBuffer;
import com.landicorp.android.eptapi.utils.Precondition;
import com.landicorp.android.eptapi.utils.StringUtil;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class Fiscal {
    static final Logger logger = Logger.getLogger(Fiscal.class);
    public static final int ERROR_NONE = 0;
    public static final int ERROR_FAIL = 1;
    public static final int ERROR_MEMORY_OUT = 12;
    public static final int ERROR_CONNECT_FAILED = 107;
    public static final int ERROR_CONNECT_TIMEOUT = 110;
    public static final int ERROR_NOTPERMIT = 134;
    public static final int ERROR_ERRPARAM = 139;
    public static final int ERROR_ERRHANDLE = 140;
    public static final int ERROR_DEVICE_DISABLE = 141;
    public static final int ERROR_POWER_FAILED = 144;
    public static final int ERROR_NO_POWER = 145;
    private static Map<String, Fiscal> sInstances = new ConcurrentHashMap<String, Fiscal>();
    private static final String DEFAULT_DEVICE_NAME = "fiscal";
    private String packageName;
    private String deviceName = "fiscal";
    private MasterController mMCtl = MasterController.getInstance();

    private Fiscal() {
        this(DEFAULT_DEVICE_NAME);
    }

    private Fiscal(String deviceName) {
        this.deviceName = deviceName;
    }

    public static Fiscal getInstance() {
        return Fiscal.getInstance(MasterController.getInstance().getDefaultAppName());
    }

    public static Fiscal getInstance(String packageName) {
        return Fiscal.getInstance(packageName, DEFAULT_DEVICE_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Fiscal getInstance(String packageName, String deviceName) {
        Precondition.checkNotEmpty(packageName);
        Precondition.checkNotEmpty(deviceName);
        Map<String, Fiscal> map = sInstances;
        synchronized (map) {
            String key = DeviceKeys.createKey(packageName, deviceName);
            if (sInstances.containsKey(key)) {
                return sInstances.get(key);
            }
            Fiscal fiscal = new Fiscal(deviceName);
            fiscal.packageName = packageName;
            sInstances.put(key, fiscal);
            return fiscal;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeInstance(String packageName) {
        Map<String, Fiscal> map = sInstances;
        synchronized (map) {
            for (String key : sInstances.keySet()) {
                if (!DeviceKeys.matchPackageName(key, packageName)) continue;
                sInstances.remove(key);
            }
        }
    }

    public int openDevice(final int mode) {
        return new RemoteInvoker(){

            @Override
            protected void onRequest(Parcel data) {
                data.writeInt(mode);
            }
        }.invoke(4609);
    }

    public int closeDevice() {
        return new RemoteInvoker(){}.invoke(4610);
    }

    public int readData(final int readSize, final BytesBuffer readBuffer) {
        Precondition.checkNotNull(readBuffer);
        return new RemoteInvoker(){

            @Override
            protected void onRequest(Parcel data) {
                data.writeInt(readSize);
            }

            @Override
            protected void onResponse(Parcel replay) {
                readBuffer.setData(replay.createByteArray());
            }
        }.invoke(4611);
    }

    public int writeData(final byte[] writeBuffer) {
        Precondition.checkNotNull(writeBuffer);
        return new RemoteInvoker(){

            @Override
            protected void onRequest(Parcel data) {
                data.writeByteArray(writeBuffer);
            }
        }.invoke(4612);
    }

    public int writeRead(final byte[] writeBuffer, final int readSize, final BytesBuffer readBuffer) {
        Precondition.checkNotNull(writeBuffer);
        Precondition.checkNotNull(readBuffer);
        return new RemoteInvoker(){

            @Override
            protected void onRequest(Parcel data) {
                data.writeByteArray(writeBuffer);
                data.writeInt(readSize);
            }

            @Override
            protected void onResponse(Parcel replay) {
                readBuffer.setData(replay.createByteArray());
            }
        }.invoke(4613);
    }

    public int powerOn() {
        return new RemoteInvoker(){

            @Override
            protected void onRequest(Parcel data) {
                data.writeInt(1);
            }
        }.invoke(4616);
    }

    public int powerOff() {
        return new RemoteInvoker(){

            @Override
            protected void onRequest(Parcel data) {
                data.writeInt(0);
            }
        }.invoke(4616);
    }

    public int getPowerState(final IntegerBuffer powerState) {
        return new RemoteInvoker(){

            @Override
            protected void onResponse(Parcel reply) {
                if (powerState != null) {
                    powerState.setData(reply.readInt());
                }
            }
        }.invoke(4617);
    }

    private abstract class RemoteInvoker {
        private RemoteInvoker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final int invoke(int requestCode) {
            Parcel data = Parcel.obtain();
            Parcel reply = Parcel.obtain();
            try {
                data.writeByteArray(StringUtil.getGBK(Fiscal.this.deviceName));
                this.onRequest(data);
                Fiscal.this.mMCtl.request(Fiscal.this.packageName, requestCode, data, reply);
                if (reply.dataAvail() == 0) {
                    logger.error("RemoteInvoker | reply data error!", new Object[0]);
                    int n = 1;
                    return n;
                }
                int result = reply.readInt();
                this.onResponse(reply);
                int n = result;
                return n;
            }
            catch (RequestException e) {
                e.printStackTrace();
                int n = 1;
                return n;
            }
            finally {
                data.recycle();
                reply.recycle();
            }
        }

        protected void onRequest(Parcel data) {
        }

        protected void onResponse(Parcel replay) {
        }
    }
}

