/*
 * Decompiled with CFR 0.152.
 */
package com.landicorp.android.eptapi.card;

import android.os.Parcel;
import com.landicorp.android.eptapi.card.InsertDriver;
import com.landicorp.android.eptapi.exception.RequestException;
import com.landicorp.android.eptapi.service.MasterController;
import com.landicorp.android.eptapi.utils.BooleanBuffer;
import com.landicorp.android.eptapi.utils.BytesBuffer;
import com.landicorp.android.eptapi.utils.BytesUtil;
import com.landicorp.android.eptapi.utils.IntegerBuffer;
import com.landicorp.android.eptapi.utils.Precondition;
import com.landicorp.android.eptapi.utils.StringUtil;

public class Sim4442Driver
implements InsertDriver {
    public static final int ERROR_NONE = 0;
    public static final int ERROR_FAILED = 1;
    public static final int ERROR_NOCARD = 251;
    public static final int ERROR_ERRTYPE = 194;
    public static final int ERROR_ERRPARAM = 139;
    public static final int ERROR_OTHER = 143;
    public static final int ERROR_TIMEOUT = 138;
    public static final int ERROR_NOPOWER = 227;
    public static final int ERROR_CHGDISABLE = 68;
    public static final int ERROR_NOVERIFY = 231;
    public static final int VOL_3 = 1;
    public static final int VOL_5 = 0;
    public static final int VOL_DEFAULT = 0;
    private String deviceName;
    private String packageName;

    public Sim4442Driver() {
        this("USERCARD");
    }

    public Sim4442Driver(String deviceName) {
        this(MasterController.getInstance().getDefaultAppName(), deviceName);
    }

    public Sim4442Driver(String packageName, String deviceName) {
        Precondition.checkNotEmpty(packageName);
        Precondition.checkNotEmpty(deviceName);
        this.packageName = packageName;
        this.deviceName = deviceName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean exists() throws RequestException {
        Parcel data = null;
        Parcel reply = null;
        try {
            data = Parcel.obtain();
            data.writeByteArray(StringUtil.getGBK(this.deviceName));
            reply = Parcel.obtain();
            MasterController.getInstance().request(this.packageName, 771, data, reply);
            boolean bl = reply.readInt() == 1;
            return bl;
        }
        finally {
            if (data != null) {
                data.recycle();
            }
            if (reply != null) {
                reply.recycle();
            }
        }
    }

    @Override
    public void halt() throws RequestException {
        Parcel data = null;
        try {
            data = Parcel.obtain();
            data.writeByteArray(StringUtil.getGBK(this.deviceName));
            MasterController.getInstance().request(this.packageName, 772, data);
        }
        finally {
            if (data != null) {
                data.recycle();
            }
        }
    }

    @Override
    public String getDriverName() {
        return "INSERT_SIM4442";
    }

    @Override
    public String getDeviceName() {
        return this.deviceName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int powerUp(int vol, BytesBuffer atr) throws RequestException {
        Precondition.checkNotNull(atr);
        Parcel data = null;
        Parcel reply = null;
        try {
            data = Parcel.obtain();
            data.writeByteArray(StringUtil.getGBK(this.deviceName));
            data.writeInt(vol);
            reply = Parcel.obtain();
            MasterController.getInstance().request(this.packageName, 785, data, reply);
            int ret = reply.readInt();
            if (ret != 0) {
                int n = ret;
                return n;
            }
            atr.setData(reply.createByteArray());
            int n = ret;
            return n;
        }
        finally {
            if (data != null) {
                data.recycle();
            }
            if (reply != null) {
                reply.recycle();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int powerDown() throws RequestException {
        Parcel data = null;
        Parcel reply = null;
        try {
            data = Parcel.obtain();
            data.writeByteArray(StringUtil.getGBK(this.deviceName));
            reply = Parcel.obtain();
            MasterController.getInstance().request(this.packageName, 786, data, reply);
            int n = reply.readInt();
            return n;
        }
        finally {
            if (data != null) {
                data.recycle();
            }
            if (reply != null) {
                reply.recycle();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int verify(byte[] password, IntegerBuffer errorCount) throws RequestException {
        Precondition.checkNotNull(password);
        Precondition.checkNotNull(errorCount);
        Parcel data = null;
        Parcel reply = null;
        try {
            data = Parcel.obtain();
            data.writeByteArray(StringUtil.getGBK(this.deviceName));
            data.writeByteArray(password);
            reply = Parcel.obtain();
            MasterController.getInstance().request(this.packageName, 787, data, reply);
            int ret = reply.readInt();
            errorCount.setData(reply.readInt());
            int n = ret;
            return n;
        }
        finally {
            if (data != null) {
                data.recycle();
            }
            if (reply != null) {
                reply.recycle();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int changeKey(byte[] password) throws RequestException {
        Precondition.checkNotNull(password);
        Parcel data = null;
        Parcel reply = null;
        try {
            data = Parcel.obtain();
            data.writeByteArray(StringUtil.getGBK(this.deviceName));
            data.writeByteArray(password);
            reply = Parcel.obtain();
            MasterController.getInstance().request(this.packageName, 788, data, reply);
            int n = reply.readInt();
            return n;
        }
        finally {
            if (data != null) {
                data.recycle();
            }
            if (reply != null) {
                reply.recycle();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int readErrorCount(IntegerBuffer errorCount) throws RequestException {
        Precondition.checkNotNull(errorCount);
        Parcel data = null;
        Parcel reply = null;
        try {
            data = Parcel.obtain();
            data.writeByteArray(StringUtil.getGBK(this.deviceName));
            reply = Parcel.obtain();
            MasterController.getInstance().request(this.packageName, 789, data, reply);
            int ret = reply.readInt();
            errorCount.setData(reply.readInt());
            int n = ret;
            return n;
        }
        finally {
            if (data != null) {
                data.recycle();
            }
            if (reply != null) {
                reply.recycle();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int lockCard() throws RequestException {
        Parcel data = null;
        Parcel reply = null;
        try {
            data = Parcel.obtain();
            data.writeByteArray(StringUtil.getGBK(this.deviceName));
            reply = Parcel.obtain();
            MasterController.getInstance().request(this.packageName, 790, data, reply);
            int n = reply.readInt();
            return n;
        }
        finally {
            if (data != null) {
                data.recycle();
            }
            if (reply != null) {
                reply.recycle();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(int address, int len, BytesBuffer data) throws RequestException {
        Precondition.checkNotNull(data);
        Parcel d = null;
        Parcel reply = null;
        try {
            d = Parcel.obtain();
            d.writeByteArray(StringUtil.getGBK(this.deviceName));
            d.writeInt(address);
            d.writeInt(len);
            reply = Parcel.obtain();
            MasterController.getInstance().request(this.packageName, 791, d, reply);
            int ret = reply.readInt();
            if (ret != 0) {
                int n = ret;
                return n;
            }
            data.setData(reply.createByteArray());
            int n = ret;
            return n;
        }
        finally {
            if (d != null) {
                d.recycle();
            }
            if (reply != null) {
                reply.recycle();
            }
        }
    }

    public int read(int address, byte[] data, int offset, int len) throws RequestException {
        Precondition.checkNotNull(data);
        BytesBuffer d = new BytesBuffer();
        if (data.length < offset + len) {
            return 139;
        }
        int ret = this.read(address, len, d);
        if (d.getData() != null) {
            System.arraycopy(d.getData(), 0, data, offset, len);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int write(int address, byte[] data) throws RequestException {
        Precondition.checkNotNull(data);
        Parcel d = null;
        Parcel reply = null;
        try {
            d = Parcel.obtain();
            d.writeByteArray(StringUtil.getGBK(this.deviceName));
            d.writeInt(address);
            d.writeByteArray(data);
            reply = Parcel.obtain();
            MasterController.getInstance().request(this.packageName, 792, d, reply);
            int n = reply.readInt();
            return n;
        }
        finally {
            if (d != null) {
                d.recycle();
            }
            if (reply != null) {
                reply.recycle();
            }
        }
    }

    public int write(int address, byte[] data, int offset, int len) throws RequestException {
        Precondition.checkNotNull(data);
        if (data.length < offset + len) {
            return 139;
        }
        return this.write(address, BytesUtil.subBytes(data, offset, len));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int readStatus(int address, BooleanBuffer changable) throws RequestException {
        Precondition.checkNotNull(changable);
        Parcel d = null;
        Parcel reply = null;
        try {
            d = Parcel.obtain();
            d.writeByteArray(StringUtil.getGBK(this.deviceName));
            d.writeInt(address);
            reply = Parcel.obtain();
            MasterController.getInstance().request(this.packageName, 793, d, reply);
            int ret = reply.readInt();
            changable.setData(reply.readInt() != 0);
            int n = ret;
            return n;
        }
        finally {
            if (d != null) {
                d.recycle();
            }
            if (reply != null) {
                reply.recycle();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int checkData(int address, byte data) throws RequestException {
        Parcel d = null;
        Parcel reply = null;
        try {
            d = Parcel.obtain();
            d.writeByteArray(StringUtil.getGBK(this.deviceName));
            d.writeInt(address);
            d.writeInt(data & 0xFF);
            reply = Parcel.obtain();
            MasterController.getInstance().request(this.packageName, 794, d, reply);
            int n = reply.readInt();
            return n;
        }
        finally {
            if (d != null) {
                d.recycle();
            }
            if (reply != null) {
                reply.recycle();
            }
        }
    }
}

