/*
 * Decompiled with CFR 0.152.
 */
package com.landicorp.android.eptapi.card;

import android.os.Parcel;
import com.landicorp.android.eptapi.card.CpuCardDriver;
import com.landicorp.android.eptapi.card.RFDriver;
import com.landicorp.android.eptapi.exception.RequestException;
import com.landicorp.android.eptapi.service.MasterController;
import com.landicorp.android.eptapi.utils.BytesBuffer;
import com.landicorp.android.eptapi.utils.Precondition;
import com.landicorp.android.eptapi.utils.StringUtil;

public class RFCpuCardDriver
extends CpuCardDriver<OnExchangeListener>
implements RFDriver {
    private String deviceName;

    public RFCpuCardDriver(String deviceName) {
        this(MasterController.getInstance().getDefaultAppName(), deviceName);
    }

    public RFCpuCardDriver(String packageName, String deviceName) {
        super(packageName, 518, 529, deviceName);
        this.packageName = packageName;
        this.deviceName = deviceName;
    }

    @Override
    public void halt() throws RequestException {
        this.stopListenExchange();
        Parcel data = Parcel.obtain();
        try {
            data.writeByteArray(StringUtil.getGBK(this.deviceName));
            MasterController.getInstance().request(this.packageName, 516, data);
        }
        finally {
            data.recycle();
        }
    }

    @Override
    public String getDriverName() {
        return "RF_CPU";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean exists() throws RequestException {
        Parcel reply = Parcel.obtain();
        Parcel data = Parcel.obtain();
        try {
            data.writeByteArray(StringUtil.getGBK(this.deviceName));
            MasterController.getInstance().request(this.packageName, 515, data, reply);
            boolean bl = reply.readInt() == 1;
            return bl;
        }
        finally {
            data.recycle();
            reply.recycle();
        }
    }

    @Override
    public String getDeviceName() {
        return this.deviceName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int cardTransparent(byte[] data, BytesBuffer response) throws RequestException {
        Precondition.checkNotNull(response);
        Parcel request = Parcel.obtain();
        Parcel resp = Parcel.obtain();
        request.writeByteArray(StringUtil.getGBK(this.deviceName));
        request.writeByteArray(data);
        try {
            MasterController.getInstance().request(this.packageName, 530, request, resp);
            int ret = resp.readInt();
            response.setData(resp.createByteArray());
            int n = ret;
            return n;
        }
        finally {
            request.recycle();
            resp.recycle();
        }
    }

    public static abstract class OnExchangeListener
    extends CpuCardDriver.OnExchangeListener {
        public static final int ERROR_ERRPARAM = 139;
        public static final int ERROR_FAILED = 143;
        public static final int ERROR_NOTAGERR = 2;
        public static final int ERROR_CRCERR = 3;
        public static final int ERROR_AUTHERR = 4;
        public static final int ERROR_PARITYERR = 5;
        public static final int ERROR_CODEERR = 6;
        public static final int ERROR_SERNRERR = 7;
        public static final int ERROR_NOTAUTHERR = 8;
        public static final int ERROR_BITCOUNTERR = 9;
        public static final int ERROR_BYTECOUNTERR = 10;
        public static final int ERROR_OVFLERR = 17;
        public static final int ERROR_FRAMINGERR = 18;
        public static final int ERROR_UNKNOWN_COMMAND = 19;
        public static final int ERROR_COLLERR = 20;
        public static final int ERROR_RESETERR = 1;
        public static final int ERROR_INTERFACEERR = 22;
        public static final int ERROR_RECBUF_OVERFLOW = 23;
        public static final int ERROR_VALERR = 24;
        public static final int ERROR_ERRTYPE = 25;
        public static final int ERROR_SWDIFF = 231;
        public static final int ERROR_TRANSERR = 162;
        public static final int ERROR_PROTERR = 163;
        public static final int ERROR_MULTIERR = 164;
        public static final int ERROR_NOCARD = 165;
        public static final int ERROR_CARDEXIST = 166;
        public static final int ERROR_CARDTIMEOUT = 167;
        public static final int ERROR_CARDNOACT = 179;

        @Override
        public int getEventId() {
            return 771;
        }

        @Override
        public abstract void onFail(int var1);

        @Override
        public abstract void onSuccess(byte[] var1);
    }
}

