/*
 * Decompiled with CFR 0.152.
 */
package com.landicorp.android.eptapi.card;

import android.annotation.SuppressLint;
import com.landicorp.android.eptapi.card.InsertCpuCardDriver;
import com.landicorp.android.eptapi.service.MasterController;
import com.landicorp.android.eptapi.utils.DeviceKeys;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class PSamCard
extends InsertCpuCardDriver {
    private int mPort = -1;
    private static Map<String, PSamCard> sInstances = new ConcurrentHashMap<String, PSamCard>();

    private PSamCard(String packageName, int port) {
        super(packageName, "SAM" + port + "CARD");
        this.mPort = port;
    }

    private PSamCard(String packageName, String deviceName) {
        super(packageName, deviceName);
    }

    public static PSamCard getCard(int port) {
        return PSamCard.getCard(MasterController.getInstance().getDefaultAppName(), port);
    }

    public static PSamCard getCard(String deviceName) {
        return PSamCard.getCard(MasterController.getInstance().getDefaultAppName(), deviceName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"UseSparseArrays"})
    public static PSamCard getCard(String packageName, int port) {
        Map<String, PSamCard> map = sInstances;
        synchronized (map) {
            String key = DeviceKeys.createKey(packageName, Integer.toString(port));
            if (sInstances.containsKey(key)) {
                return sInstances.get(key);
            }
            PSamCard psamCard = new PSamCard(packageName, port);
            sInstances.put(key, psamCard);
            return psamCard;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PSamCard getCard(String packageName, String deviceName) {
        Map<String, PSamCard> map = sInstances;
        synchronized (map) {
            String key = DeviceKeys.createKey(packageName, deviceName);
            if (sInstances.containsKey(key)) {
                return sInstances.get(key);
            }
            PSamCard psamCard = new PSamCard(packageName, deviceName);
            sInstances.put(key, psamCard);
            return psamCard;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeInstance(String packageName) {
        Map<String, PSamCard> map = sInstances;
        synchronized (map) {
            for (String key : sInstances.keySet()) {
                if (!DeviceKeys.matchPackageName(key, packageName)) continue;
                sInstances.remove(key);
            }
        }
    }

    public int getPort() {
        return this.mPort;
    }
}

