/*
 * Decompiled with CFR 0.152.
 */
package com.landicorp.android.eptapi.card;

import android.os.Parcel;
import com.landicorp.android.eptapi.exception.RequestException;
import com.landicorp.android.eptapi.listener.RemoteListener;
import com.landicorp.android.eptapi.service.MasterController;
import com.landicorp.android.eptapi.utils.BytesBuffer;
import com.landicorp.android.eptapi.utils.IntegerBuffer;
import com.landicorp.android.eptapi.utils.LongBuffer;
import com.landicorp.android.eptapi.utils.PausableHandler;

public interface MifareInterface<T1 extends OnResultListener, T2 extends OnReadListener> {
    public static final int REQUEST_MODE_IDLE = 0;
    public static final int REQUEST_MODE_HALT = 1;

    public int request(int var1, IntegerBuffer var2) throws RequestException;

    public int antiCollision(LongBuffer var1) throws RequestException;

    public int select(long var1, IntegerBuffer var3) throws RequestException;

    public void authBlock(int var1, int var2, byte[] var3, T1 var4) throws RequestException;

    public int authBlock(int var1, int var2, byte[] var3) throws RequestException;

    public void authSector(int var1, int var2, byte[] var3, T1 var4) throws RequestException;

    public int authSector(int var1, int var2, byte[] var3) throws RequestException;

    public void readBlock(int var1, T2 var2) throws RequestException;

    public int readBlock(int var1, BytesBuffer var2) throws RequestException;

    public void writeBlock(int var1, byte[] var2, T1 var3) throws RequestException;

    public int writeBlock(int var1, byte[] var2) throws RequestException;

    public void backup(int var1, T1 var2) throws RequestException;

    public void restoreRAM(int var1, T1 var2) throws RequestException;

    public int restoreRAM(int var1) throws RequestException;

    public void restore(int var1, T1 var2) throws RequestException;

    public void transferRAM(int var1, T1 var2) throws RequestException;

    public int transferRAM(int var1) throws RequestException;

    public void increase(int var1, int var2, T1 var3) throws RequestException;

    public int increase(int var1, int var2) throws RequestException;

    public void decrease(int var1, int var2, T1 var3) throws RequestException;

    public int decrease(int var1, int var2) throws RequestException;

    public static abstract class OnResultListener
    extends RemoteListener {
        public OnResultListener() {
        }

        public OnResultListener(PausableHandler handler) {
            super(handler);
        }

        @Override
        protected void onListened(Parcel data) {
            MasterController.getInstance().uninstallListener(this);
            int errcode = data.readInt();
            if (errcode == 0) {
                this.onSuccess();
            } else {
                this.onFail(errcode);
            }
        }

        protected abstract void onSuccess();

        protected abstract void onFail(int var1);
    }

    public static abstract class OnReadListener
    extends RemoteListener {
        public OnReadListener() {
        }

        public OnReadListener(PausableHandler handler) {
            super(handler);
        }

        @Override
        protected final void onListened(Parcel data) {
            MasterController.getInstance().uninstallListener(this);
            int errcode = data.readInt();
            if (errcode == 0) {
                this.onSuccess(data.createByteArray());
            } else {
                this.onFail(errcode);
            }
        }

        protected abstract void onSuccess(byte[] var1);

        protected abstract void onFail(int var1);
    }
}

