/*
 * Decompiled with CFR 0.152.
 */
package com.landicorp.android.eptapi.algorithm;

import com.landicorp.android.eptapi.algorithm.IAlgorithm;
import com.landicorp.android.eptapi.algorithm.RSAPrivateKey;
import com.landicorp.android.eptapi.algorithm.RSAPublicKey;
import com.landicorp.android.eptapi.utils.BytesBuffer;
import com.landicorp.android.eptapi.utils.Precondition;

public class Algorithm {
    public static final int ERROR_NONE = 0;
    public static final int ERROR_FAILED = 1;
    public static final int ERROR_PARAM = 139;
    public static final int EM_RSA_EXP_3 = 3;
    public static final int EM_RSA_EXP_10001 = 65537;
    public static final int EM_MIN_RSA_MODULUS_BITS = 508;
    public static final int EM_MAX_RSA_MODULUS_BITS = 2048;
    public static final int EM_MAX_RSA_MODULUS_LEN = 256;
    public static final int EM_MAX_RSA_PRIME_BITS = 1024;
    public static final int EM_MAX_RSA_PRIME_LEN = 128;
    public static final long TDES_ENCRYPT = 0L;
    public static final long TDES_DECRYPT = 1L;
    public static final long TDES_MODE_TECB = 0L;
    public static final long TDES_MODE_TCBC = 256L;
    public static final long TDES_MODE_DEFAULT = 0L;
    public static final long MAC_ALGORITHM1 = 0L;
    public static final long MAC_ALGORITHM3 = 2L;
    public static final long MAC_ALGORITHM_DEFAULT = 2L;
    public static final long MAC_PAD_MODE1 = 0L;
    public static final long MAC_PAD_MODE2 = 256L;
    public static final long MAC_PAD_DEFAULT = 0L;
    public static final long AES_ENCRYPT = 0L;
    public static final long AES_DECRYPT = 1L;
    public static final long AES_MODE_ECB = 0L;
    public static final long AES_MODE_CBC = 256L;
    public static final long AES_MODE_MAC = 512L;
    public static final long SMS4_ENCRYPT = 0L;
    public static final long SMS4_DECRYPT = 1L;
    public static final long SMS4_MODE_TECB = 0L;
    public static final long SMS4_MODE_TCBC = 256L;
    public static final long SMS2_VERSION_2010 = 0L;
    public static final long SMS2_VERSION_2012 = 1L;
    public static final long SMS2_VERSION_DEFAULT = 1L;
    @Deprecated
    public static final long EM_alg_TDESENCRYPT = 0L;
    @Deprecated
    public static final long EM_alg_TDESDECRYPT = 1L;
    @Deprecated
    public static final long EM_alg_TDESTECBMODE = 0L;
    @Deprecated
    public static final long EM_alg_TDESTCBCMODE = 256L;
    @Deprecated
    public static final long EM_alg_TDESDEFAULTMODE = 0L;
    @Deprecated
    public static final long EM_alg_MACALGORITHM1 = 0L;
    @Deprecated
    public static final long EM_alg_MACALGORITHM2 = 1L;
    public static final long EM_alg_MACALGORITHM3 = 2L;
    @Deprecated
    public static final long EM_alg_MACALGORITHM4 = 3L;
    @Deprecated
    public static final long EM_alg_MACALGORITHM5 = 4L;
    @Deprecated
    public static final long EM_alg_MACALGORITHM6 = 5L;
    @Deprecated
    public static final long EM_alg_MACALGORITHMDEFAULT = 2L;
    @Deprecated
    public static final long EM_alg_MACPADMODE1 = 0L;
    @Deprecated
    public static final long EM_alg_MACPADMODE2 = 256L;
    @Deprecated
    public static final long EM_alg_MACPADMODE3 = 512L;
    @Deprecated
    public static final long EM_alg_MACPADMODEDEFAULT = 0L;
    @Deprecated
    public static final long EM_alg_AES_ENCRYPT = 0L;
    @Deprecated
    public static final long EM_alg_AES_DECRYPT = 1L;
    @Deprecated
    public static final long EM_alg_AES_ECBMODE = 0L;
    @Deprecated
    public static final long EM_alg_AES_CBCMODE = 256L;
    @Deprecated
    public static final long EM_alg_AES_MACMODE = 512L;
    @Deprecated
    public static final long EM_alg_SMS4ENCRYPT = 0L;
    @Deprecated
    public static final long EM_alg_SMS4DECRYPT = 1L;
    @Deprecated
    public static final long EM_alg_SMS4TECBMODE = 0L;
    @Deprecated
    public static final long EM_alg_SMS4TCBCMODE = 256L;
    @Deprecated
    public static final long EM_alg_DESENCRYPTMODE = 0L;
    @Deprecated
    public static final long EM_alg_SMS4ENCRYPTMODE = 65536L;
    @Deprecated
    public static final long EM_alg_SMS2VER2010 = 0L;
    @Deprecated
    public static final long EM_alg_SMS2VER2012 = 1L;
    @Deprecated
    public static final long EM_alg_SMS2VERDEFAULT = 1L;
    public static final byte[] EM_DEFAULT_SM2_IDA = new byte[]{49, 50, 51, 52, 53, 54, 55, 56, 49, 50, 51, 52, 53, 54, 55, 56};

    private Algorithm() {
    }

    public static int getRandom(int length, BytesBuffer random) {
        Precondition.checkNotNull(random);
        return IAlgorithm.getRandom(length, random);
    }

    public static int TDES(long mode, byte[] key, byte[] in, BytesBuffer out) {
        Precondition.checkNotNull(key);
        Precondition.checkNotNull(in);
        Precondition.checkNotNull(out);
        return IAlgorithm.TDES(mode, key, in, out);
    }

    public static int calcMAC(long mode, byte[] key, byte[] in, BytesBuffer out) {
        Precondition.checkNotNull(key);
        Precondition.checkNotNull(in);
        Precondition.checkNotNull(out);
        return IAlgorithm.calcMAC(mode, key, in, out);
    }

    public static int AES(long mode, byte[] key, byte[] in, BytesBuffer out) {
        Precondition.checkNotNull(key);
        Precondition.checkNotNull(in);
        Precondition.checkNotNull(out);
        return IAlgorithm.AES(mode, key, in, out);
    }

    public static int RSAPublicCalc(RSAPublicKey pubKey, byte[] in, BytesBuffer out) {
        Precondition.checkNotNull(pubKey);
        Precondition.checkNotNull(in);
        Precondition.checkNotNull(out);
        return IAlgorithm.RSAPublicCalc(pubKey, in, out);
    }

    public static int RSAPrivateCalc(RSAPrivateKey priKey, byte[] in, BytesBuffer out) {
        Precondition.checkNotNull(priKey);
        Precondition.checkNotNull(in);
        Precondition.checkNotNull(out);
        return IAlgorithm.RSAPrivateCalc(priKey, in, out);
    }

    public static int generateRSAKey(int modeLen, int exponent, RSAPrivateKey priKey) {
        Precondition.checkNotNull(priKey);
        return IAlgorithm.generateRSAKey(modeLen, exponent, priKey);
    }

    public static int SHA1(byte[] in, BytesBuffer out) {
        Precondition.checkNotNull(in);
        Precondition.checkNotNull(out);
        return IAlgorithm.SHA1(in, out);
    }

    public static int SHA256(byte[] in, BytesBuffer out) {
        Precondition.checkNotNull(in);
        Precondition.checkNotNull(out);
        return IAlgorithm.SHA256(in, out);
    }

    public static int SHA512(byte[] in, BytesBuffer out) {
        Precondition.checkNotNull(in);
        Precondition.checkNotNull(out);
        return IAlgorithm.SHA512(in, out);
    }

    public static int SMS4(long mode, byte[] key, byte[] in, BytesBuffer out) {
        Precondition.checkNotNull(key);
        Precondition.checkNotNull(in);
        Precondition.checkNotNull(out);
        return IAlgorithm.SMS4(mode, key, in, out);
    }

    public static int SMS4CalculateMac(long mode, byte[] key, byte[] in, BytesBuffer out) {
        Precondition.checkNotNull(key);
        Precondition.checkNotNull(in);
        Precondition.checkNotNull(out);
        return IAlgorithm.SMS4CalculateMac(mode, key, in, out);
    }

    public static int SM3(byte[] in, BytesBuffer out) {
        Precondition.checkNotNull(in);
        Precondition.checkNotNull(out);
        return IAlgorithm.SM3(in, out);
    }

    public static int genSm2Keys(int priKeyLen, BytesBuffer pubKey, BytesBuffer priKey) {
        Precondition.checkArgument(priKeyLen > 0);
        Precondition.checkNotNull(pubKey);
        Precondition.checkNotNull(priKey);
        return IAlgorithm.genSm2Keys(priKeyLen, pubKey, priKey);
    }

    public static int sm2SetVersion(long version) {
        return IAlgorithm.sm2SetVersion(version);
    }

    public static int sm2Encrypt(byte[] in, byte[] pubKey, BytesBuffer out) {
        Precondition.checkNotNull(in);
        Precondition.checkNotNull(pubKey);
        Precondition.checkNotNull(out);
        return IAlgorithm.sm2Encrypt(in, pubKey, out);
    }

    public static int sm2Decrypt(byte[] in, byte[] priKey, BytesBuffer out) {
        Precondition.checkNotNull(in);
        Precondition.checkNotNull(priKey);
        Precondition.checkNotNull(out);
        return IAlgorithm.sm2Decrypt(in, priKey, out);
    }

    public static int sm2SignHash(byte[] ida, byte[] in, byte[] pubKey, BytesBuffer out) {
        Precondition.checkNotNull(ida);
        Precondition.checkNotNull(in);
        Precondition.checkNotNull(pubKey);
        Precondition.checkNotNull(out);
        return IAlgorithm.sm2SignHash(ida, in, pubKey, out);
    }

    public static int sm2SignEnd(byte[] hash, byte[] priKey, BytesBuffer out) {
        Precondition.checkNotNull(hash);
        Precondition.checkNotNull(priKey);
        Precondition.checkNotNull(out);
        return IAlgorithm.sm2SignEnd(hash, priKey, out);
    }

    public static int sm2VerifyEnd(byte[] hash, byte[] in, byte[] pubKey) {
        Precondition.checkNotNull(hash);
        Precondition.checkNotNull(in);
        Precondition.checkNotNull(pubKey);
        return IAlgorithm.sm2VerifyEnd(hash, in, pubKey);
    }
}

