/*
 * Decompiled with CFR 0.152.
 */
package com.aofeng.hybrid.util;

import android.annotation.SuppressLint;
import android.content.Context;
import android.location.Criteria;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.os.Bundle;
import java.util.List;

public class LocationUtils {
    @SuppressLint(value={"MissingPermission"})
    private Location location;
    private LocationManager locationManager;
    private static LocationUtils locationUtils;

    public static LocationUtils getInstance() {
        if (locationUtils == null) {
            locationUtils = new LocationUtils();
        }
        return locationUtils;
    }

    public Location getLocations(Context context) {
        if (!this.checkPermission(context, permission.ACCESS_COARSE_LOCATION)) {
            return null;
        }
        try {
            List providers;
            this.locationManager = (LocationManager)context.getSystemService("location");
            Criteria criteria = new Criteria();
            criteria.setAccuracy(2);
            criteria.setAltitudeRequired(false);
            criteria.setBearingRequired(false);
            criteria.setCostAllowed(true);
            criteria.setPowerRequirement(1);
            String provider = this.locationManager.getBestProvider(criteria, true);
            if (provider == null && (providers = this.locationManager.getProviders(true)) != null && providers.size() > 0) {
                provider = (String)providers.get(0);
            }
            this.location = this.locationManager.getLastKnownLocation(provider);
            if (this.location == null) {
                this.locationManager.requestLocationUpdates(provider, 3600000L, 1000.0f, new LocationListener(){

                    public void onLocationChanged(Location loc) {
                        LocationUtils.this.location = loc;
                    }

                    public void onStatusChanged(String provider, int status, Bundle extras) {
                    }

                    public void onProviderEnabled(String provider) {
                    }

                    public void onProviderDisabled(String provider) {
                    }
                });
            }
            return this.location;
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private boolean checkPermission(Context context, permission permName) {
        int perm = context.checkCallingOrSelfPermission("android.permission." + permName.toString());
        return perm == 0;
    }

    private static enum permission {
        ACCESS_COARSE_LOCATION,
        ACCESS_FINE_LOCATION;

    }
}

