/*
 * Decompiled with CFR 0.152.
 */
package com.aofeng.hybrid.util;

import android.app.Activity;
import android.content.Context;
import android.media.MediaRecorder;
import android.os.Build;
import android.os.Handler;
import android.os.Message;
import android.support.v4.app.ActivityCompat;
import android.support.v4.content.ContextCompat;
import android.util.Log;
import com.aofeng.hybrid.application.AFApplication;
import com.aofeng.hybrid.util.CommUtil;
import com.aofeng.hybrid.util.LogUtil;
import java.io.File;
import org.json.JSONException;
import org.json.JSONObject;

public class AudioClipUtil {
    private static boolean shouldStop;
    private MediaRecorder mRecorder = new MediaRecorder();
    public Handler mHandler = new Handler(){

        public void handleMessage(Message msg) {
            if (msg.what > 0) {
                LogUtil.i("\u5f55\u97f3", "\u5f00\u59cb");
            } else {
                AudioClipUtil.this.mRecorder.stop();
                AudioClipUtil.this.mRecorder.reset();
                LogUtil.i("\u5f55\u97f3", "\u7ed3\u675f");
            }
        }
    };
    private final String[] permissions = new String[]{"android.permission.RECORD_AUDIO"};

    public void delAudioClipFile(String filePath) {
        int n;
        if (filePath.startsWith("file://")) {
            filePath = filePath.substring("file://".length());
        }
        if ((n = filePath.indexOf("?")) > 0) {
            filePath = filePath.substring(0, n);
        }
        File file = new File(filePath);
        file.delete();
    }

    public void startAudioClip(final Activity activity, String fileName) throws Exception {
        if (Build.VERSION.SDK_INT >= 23) {
            this.checkPermission(activity);
        }
        if (fileName.isEmpty()) {
            throw new Exception("fileName\u4e3anull");
        }
        fileName = AFApplication.APP_DATA + fileName;
        shouldStop = false;
        CommUtil.setSharedPreference((Context)activity, new JSONObject().put("audioClipThisFile", (Object)fileName));
        CommUtil.setSharedPreference((Context)activity, new JSONObject().put("audioClipShouldStop", false));
        new Thread(new Runnable(){

            @Override
            public void run() {
                for (int n = 3600; !shouldStop && n > 0; --n) {
                    try {
                        shouldStop = Boolean.parseBoolean(CommUtil.getSharedPreference((Context)activity, "audioClipShouldStop"));
                        String audioClipThisFile = CommUtil.getSharedPreference((Context)activity, "audioClipThisFile");
                        String isDelThisFileAudioClip = CommUtil.getSharedPreference((Context)activity, "isDelThisFileAudioClip");
                        if (!audioClipThisFile.isEmpty() && shouldStop && isDelThisFileAudioClip.equals("\u5220\u9664\u5f53\u524d\u5f55\u97f3\u6587\u4ef6")) {
                            CommUtil.setSharedPreference((Context)activity, new JSONObject().put("isDelThisFileAudioClip", (Object)"\u5df2\u5220\u9664\u5f53\u524d\u5f55\u97f3\u6587\u4ef6"));
                            AudioClipUtil.this.delAudioClipFile(audioClipThisFile);
                            LogUtil.i("\u5220\u9664\u5f55\u97f3\u6587\u4ef6", "\u5220\u9664\u5f55\u97f3\u6587\u4ef6" + audioClipThisFile);
                        }
                        Thread.sleep(1000L);
                        Message msg = new Message();
                        msg.what = n;
                        AudioClipUtil.this.mHandler.sendMessage(msg);
                        continue;
                    }
                    catch (InterruptedException | JSONException e) {
                        e.printStackTrace();
                        AudioClipUtil.this.mRecorder.stop();
                        AudioClipUtil.this.mRecorder.reset();
                    }
                }
                Message msg = new Message();
                msg.what = -1;
                AudioClipUtil.this.mHandler.sendMessage(msg);
            }
        }).start();
        this.mRecorder.setAudioSource(1);
        this.mRecorder.setOutputFormat(1);
        this.mRecorder.setAudioEncoder(1);
        this.mRecorder.setOutputFile(fileName);
        this.mRecorder.prepare();
        this.mRecorder.start();
    }

    public void checkPermission(Activity activity) {
        if (ContextCompat.checkSelfPermission((Context)activity, (String)"android.permission.RECORD_AUDIO") != 0) {
            ActivityCompat.requestPermissions((Activity)activity, (String[])this.permissions, (int)1);
        } else {
            Log.i((String)"tag", (String)"\u5df2\u7533\u8bf7\u6743\u9650");
        }
    }
}

