/*
 * Decompiled with CFR 0.152.
 */
package com.aofeng.hybrid.sync;

import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.util.Log;
import com.af.util.Pair;
import com.aofeng.hybrid.R;
import com.aofeng.hybrid.android.db.QueryExecutor;
import com.aofeng.hybrid.orm.Column;
import com.aofeng.hybrid.orm.DatabaseManager;
import com.aofeng.hybrid.service.EntityService;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONObject;

public class SyncDBHelper {
    public static boolean hasTable(Context context, final String tableName) throws Exception {
        Object obj = DatabaseManager.getInstance().executeQuery(new QueryExecutor(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object run(SQLiteDatabase db) throws Exception {
                try (Cursor cursor = null;){
                    cursor = db.rawQuery("SELECT name FROM sqlite_master WHERE type='table' AND name='" + tableName + "'", null);
                    boolean result = cursor.moveToNext();
                    Boolean bl = new Boolean(result);
                    return bl;
                }
            }
        });
        return (Boolean)obj;
    }

    public static void createTable(Context context, String tableName, HashMap<String, Object> map) throws Exception {
        String dialect = context.getResources().getString(R.string.dialect);
        Map cols = (Map)map.get("columns");
        String idName = (String)map.get("idName");
        String idColName = (String)map.get("idColName");
        String idType = (String)map.get("idType");
        String idGenerator = (String)map.get("idGenerator");
        String sql = "CREATE TABLE " + tableName + " (";
        for (String entry : cols.keySet()) {
            Pair pair = (Pair)cols.get(entry);
            sql = sql + pair.col + " " + EntityService.normalizeColType(dialect, pair.type) + " , ";
        }
        String modifiedIdType = EntityService.normalizeColType(dialect, idType);
        sql = sql + idColName + " " + modifiedIdType + " PRIMARY KEY ";
        sql = sql + (idGenerator.equals("ID_AUTO") || idGenerator.equals("ID_SEQ") ? "AUTOINCREMENT" : "");
        final String sql1 = sql = sql + ")";
        Object obj = DatabaseManager.getInstance().executeQuery(new QueryExecutor(){

            @Override
            public Object run(SQLiteDatabase db) throws Exception {
                db.execSQL(sql1);
                return null;
            }
        });
    }

    private static Map<String, String> getColumnsFromJson(JSONObject jo) throws Exception {
        HashMap<String, String> colMap = new HashMap<String, String>();
        Iterator itr = jo.keys();
        while (itr.hasNext()) {
            String name = (String)itr.next();
            String type = jo.getString(name);
            if (name.startsWith("__") || name.endsWith("__") || jo.has(type)) continue;
            colMap.put(name, Column.normalizeType(jo.getString(name)));
        }
        return colMap;
    }

    private static Map<String, String> getColumnsFromJson(String dialect, HashMap<String, Object> map) throws Exception {
        HashMap<String, String> colMap = new HashMap<String, String>();
        Map cols = (Map)map.get("columns");
        for (String entry : cols.keySet()) {
            Pair pair = (Pair)cols.get(entry);
            colMap.put(pair.col, EntityService.normalizeColType(dialect, pair.type));
        }
        return colMap;
    }

    private static Map<String, String> getTableColumns(Context context, final String tableName) throws Exception {
        final HashMap colMap = new HashMap();
        Object obj = DatabaseManager.getInstance().executeQuery(new QueryExecutor(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object run(SQLiteDatabase db) throws Exception {
                try (Cursor cursor = null;){
                    cursor = db.rawQuery("pragma table_info(" + tableName + ")", null);
                    while (cursor.moveToNext()) {
                        colMap.put(cursor.getString(cursor.getColumnIndex("name")), cursor.getString(cursor.getColumnIndex("type")).toUpperCase());
                    }
                    Map map = colMap;
                    return map;
                }
            }
        });
        return (Map)obj;
    }

    public static void updateTable(Context context, final String tableName, HashMap<String, Object> map) throws Exception {
        final Map<String, String> colAndroid = SyncDBHelper.getTableColumns(context, tableName);
        String dialect = context.getResources().getString(R.string.dialect);
        final Map<String, String> colRest = SyncDBHelper.getColumnsFromJson(dialect, map);
        Object obj = DatabaseManager.getInstance().executeQuery(new QueryExecutor(){

            @Override
            public Object run(SQLiteDatabase db) throws Exception {
                for (String rCol : colRest.keySet()) {
                    if (colAndroid.containsKey(rCol.trim())) continue;
                    String sql = "ALTER TABLE " + tableName + " ADD " + rCol + " " + (String)colRest.get(rCol);
                    db.execSQL(sql);
                }
                return null;
            }
        });
    }

    public static void createTable(Context context, String tableName, JSONObject jo) throws Exception {
        Map<String, String> colMap = SyncDBHelper.getColumnsFromJson(jo);
        JSONObject pko = jo.getJSONObject("__primary__key__");
        String pk = pko.getString("id");
        String sql = "CREATE TABLE " + tableName + " (";
        for (String colName : colMap.keySet()) {
            sql = sql + colName + " " + colMap.get(colName);
            if (colName.toLowerCase().equals(pk.toLowerCase())) {
                sql = sql + " PRIMARY KEY " + (pko.getString("type").toLowerCase().equals("integer") ? "AUTOINCREMENT" : "") + " , ";
                continue;
            }
            sql = sql + ", ";
        }
        sql = sql.substring(0, sql.length() - 2);
        final String sql1 = sql = sql + ")";
        Object obj = DatabaseManager.getInstance().executeQuery(new QueryExecutor(){

            @Override
            public Object run(SQLiteDatabase db) throws Exception {
                db.execSQL(sql1);
                return null;
            }
        });
    }

    public static void updateTable(Context context, final String tableName, JSONObject jo) throws Exception {
        final Map<String, String> colAndroid = SyncDBHelper.getTableColumns(context, tableName);
        final Map<String, String> colRest = SyncDBHelper.getColumnsFromJson(jo);
        Object obj = DatabaseManager.getInstance().executeQuery(new QueryExecutor(){

            @Override
            public Object run(SQLiteDatabase db) throws Exception {
                for (String rCol : colRest.keySet()) {
                    if (colAndroid.containsKey(rCol.trim())) continue;
                    String sql = "ALTER TABLE " + tableName + " ADD " + rCol + " " + (String)colRest.get(rCol);
                    db.execSQL(sql);
                }
                return null;
            }
        });
    }

    public static void createOrUpdateLinkColumn(Context context, final String tableName, final String colName, final String type) throws Exception {
        final Map<String, String> colAndroid = SyncDBHelper.getTableColumns(context, tableName);
        Object obj = DatabaseManager.getInstance().executeQuery(new QueryExecutor(){

            @Override
            public Object run(SQLiteDatabase db) throws Exception {
                if (!colAndroid.containsKey(colName)) {
                    String sql = "ALTER TABLE " + tableName + " ADD " + colName + " " + Column.normalizeType(type);
                    db.execSQL(sql);
                }
                return null;
            }
        });
    }

    public static void createOrUpdateLinkColumn(Context context, HashMap<String, Object> map) throws Exception {
        final String tableName = (String)map.get("tableName");
        String dialect = context.getResources().getString(R.string.dialect);
        Map<String, String> colAndroid = SyncDBHelper.getTableColumns(context, tableName);
        HashMap associations = (HashMap)map.get("associations");
        if (associations == null) {
            return;
        }
        for (String key : associations.keySet()) {
            final Pair pair = (Pair)associations.get(key);
            if (colAndroid.containsKey(pair.col.trim())) continue;
            try {
                Object object = DatabaseManager.getInstance().executeQuery(new QueryExecutor(){

                    @Override
                    public Object run(SQLiteDatabase db) throws Exception {
                        String sql = "ALTER TABLE " + tableName + " ADD " + pair.col.trim() + " " + Column.normalizeType(pair.type);
                        db.execSQL(sql);
                        return null;
                    }
                });
            }
            catch (Exception e) {
                Log.d((String)"duplicate foreign key", (String)e.getMessage());
            }
        }
    }
}

