/*
 * Decompiled with CFR 0.152.
 */
package com.aofeng.hybrid.pos.device;

import android.content.Context;
import android.widget.Toast;
import com.aofeng.hybrid.activity.PreludeActivity;
import com.aofeng.hybrid.pos.device.Device;
import com.aofeng.hybrid.util.CommUtil;
import com.landicorp.android.eptapi.DeviceService;
import com.landicorp.android.eptapi.card.At1604Driver;
import com.landicorp.android.eptapi.card.At24CxxDriver;
import com.landicorp.android.eptapi.card.RFCpuCardDriver;
import com.landicorp.android.eptapi.card.Sim4442Driver;
import com.landicorp.android.eptapi.device.RFCardReader;
import com.landicorp.android.eptapi.exception.ReloginException;
import com.landicorp.android.eptapi.exception.RequestException;
import com.landicorp.android.eptapi.exception.ServiceOccupiedException;
import com.landicorp.android.eptapi.exception.UnsupportMultiProcess;
import com.landicorp.android.eptapi.utils.SystemInfomation;

public class LDDevice
implements Device {
    public static Sim4442Driver driverFor4442;
    public static At1604Driver driverFor1604;
    public static At24CxxDriver driverFor24C01;
    public static RFCpuCardDriver rfCpuCardDriver;
    public static RFCardReader rfCardReader;
    private static String CARD_MAIN;
    private static String CARD_SECOND;
    private SystemInfomation.DeviceInfo deviceInfo;
    public static Context mContext;
    private static boolean isDeviceServiceLogined;
    public String SN;

    @Override
    public void initDevice(Context context) {
        try {
            String Slot = CommUtil.getSharedPreference(PreludeActivity.context, "SLOT");
            if ("0".equals(Slot)) {
                driverFor4442 = new Sim4442Driver(CARD_MAIN);
                driverFor1604 = new At1604Driver(4, CARD_MAIN);
                driverFor24C01 = new At24CxxDriver(1, CARD_MAIN);
                rfCpuCardDriver = new RFCpuCardDriver("com.aofeng.hybridwork", CARD_MAIN);
            } else {
                driverFor4442 = new Sim4442Driver(CARD_SECOND);
                driverFor1604 = new At1604Driver(4, CARD_SECOND);
                driverFor24C01 = new At24CxxDriver(1, CARD_SECOND);
                rfCpuCardDriver = new RFCpuCardDriver("com.aofeng.hybridwork", CARD_SECOND);
            }
            rfCardReader = RFCardReader.getInstance();
            this.deviceInfo = SystemInfomation.getDeviceInfo();
            this.SN = this.deviceInfo.getSerialNo();
            Toast.makeText((Context)context, (CharSequence)"\u83b7\u53d6\u8bbe\u5907\u4fe1\u606f\u6210\u529f", (int)0).show();
        }
        catch (Exception e) {
            Toast.makeText((Context)context, (CharSequence)e.getMessage(), (int)1).show();
            e.printStackTrace();
        }
        mContext = context;
    }

    public static boolean login() {
        try {
            if (!isDeviceServiceLogined) {
                DeviceService.login((Context)mContext);
                isDeviceServiceLogined = true;
            }
        }
        catch (RequestException e) {
            e.printStackTrace();
            return false;
        }
        catch (ServiceOccupiedException e) {
            e.printStackTrace();
            return false;
        }
        catch (ReloginException e) {
            e.printStackTrace();
            return false;
        }
        catch (UnsupportMultiProcess e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static void logout() {
        if (isDeviceServiceLogined) {
            DeviceService.logout();
        }
        isDeviceServiceLogined = false;
    }

    @Override
    public String getSN() {
        return this.SN;
    }

    @Override
    public String getIP() {
        return null;
    }

    @Override
    public String getAddress() {
        return null;
    }

    static {
        CARD_MAIN = "USERCARD";
        CARD_SECOND = "MASTERCARD";
        isDeviceServiceLogined = false;
    }
}

