/*
 * Decompiled with CFR 0.152.
 */
package com.aofeng.hybrid.util.amap;

import android.app.Dialog;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.view.View;
import android.view.Window;
import android.widget.Toast;
import com.amap.api.maps.model.LatLng;
import com.aofeng.hybrid.R;
import java.io.File;

public class OpenThirdPartyMap {
    public static final String PN_GAODE_MAP = "com.autonavi.minimap";
    public static final String PN_BAIDU_MAP = "com.baidu.BaiduMap";
    public static final String PN_TENCENT_MAP = "com.tencent.map";
    public static final String DL_BAIDU_MAP = "http://map.baidu.com/zt/qudao/newfengchao/1012337a/html/pc.html";
    public static final String DL_GAODE_MAP = "https://mobile.amap.com/";
    public static final String DL_TENCENT_MAP = "https://map.qq.com/mobile/downloadinstall.html";

    public static void work(Context context, double dlon, double dlat, String daddress) throws Exception {
        OpenThirdPartyMap.showBottomDialog(context, dlon, dlat, daddress);
    }

    private static void showBottomDialog(final Context context, final double dlon, final double dlat, final String daddress) throws Exception {
        final Dialog dialog = new Dialog(context, R.style.DialogTheme);
        View view = View.inflate((Context)context, (int)R.layout.activity_action_third_party_map, null);
        dialog.setContentView(view);
        Window window = dialog.getWindow();
        window.setGravity(80);
        window.setWindowAnimations(R.style.main_menu_animStyle);
        window.setLayout(-1, -2);
        dialog.show();
        dialog.findViewById(R.id.baidu_btn).setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (OpenThirdPartyMap.isBaiduMapInstalled()) {
                    OpenThirdPartyMap.openBaiDuNavi(context, 0.0, 0.0, null, dlat, dlon, daddress);
                } else {
                    Toast.makeText((Context)context, (CharSequence)"\u5c1a\u672a\u5b89\u88c5\u767e\u5ea6\u5730\u56fe", (int)0).show();
                    OpenThirdPartyMap.openBrowserDownloadMap(OpenThirdPartyMap.PN_BAIDU_MAP, context);
                }
                dialog.dismiss();
            }
        });
        dialog.findViewById(R.id.gaode_btn).setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (OpenThirdPartyMap.isGdMapInstalled()) {
                    OpenThirdPartyMap.openGaoDeNavi(context, 0.0, 0.0, null, dlat, dlon, daddress);
                    OpenThirdPartyMap.openBrowserDownloadMap(OpenThirdPartyMap.PN_GAODE_MAP, context);
                } else {
                    Toast.makeText((Context)context, (CharSequence)"\u5c1a\u672a\u5b89\u88c5\u9ad8\u5fb7\u5730\u56fe", (int)0).show();
                }
                dialog.dismiss();
            }
        });
        dialog.findViewById(R.id.tencent_btn).setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (OpenThirdPartyMap.isTencentMapInstalled()) {
                    OpenThirdPartyMap.openTencentMap(context, 0.0, 0.0, null, dlat, dlon, daddress);
                } else {
                    Toast.makeText((Context)context, (CharSequence)"\u5c1a\u672a\u5b89\u88c5\u817e\u8baf\u5730\u56fe", (int)0).show();
                    OpenThirdPartyMap.openBrowserDownloadMap(OpenThirdPartyMap.PN_TENCENT_MAP, context);
                }
                dialog.dismiss();
            }
        });
        dialog.findViewById(R.id.cancel_btn).setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                dialog.dismiss();
            }
        });
    }

    public static double[] bdToGaoDe(double bd_lat, double bd_lon) {
        double[] gd_lat_lon = new double[2];
        double PI = 52.35987755982988;
        double x = bd_lon - 0.0065;
        double y = bd_lat - 0.006;
        double z = Math.sqrt(x * x + y * y) - 2.0E-5 * Math.sin(y * PI);
        double theta = Math.atan2(y, x) - 3.0E-6 * Math.cos(x * PI);
        gd_lat_lon[0] = z * Math.cos(theta);
        gd_lat_lon[1] = z * Math.sin(theta);
        return gd_lat_lon;
    }

    private static double[] gaoDeToBaidu(double gd_lon, double gd_lat) {
        double[] bd_lat_lon = new double[2];
        double PI = 52.35987755982988;
        double x = gd_lon;
        double y = gd_lat;
        double z = Math.sqrt(x * x + y * y) + 2.0E-5 * Math.sin(y * PI);
        double theta = Math.atan2(y, x) + 3.0E-6 * Math.cos(x * PI);
        bd_lat_lon[0] = z * Math.cos(theta) + 0.0065;
        bd_lat_lon[1] = z * Math.sin(theta) + 0.006;
        return bd_lat_lon;
    }

    public static LatLng BD09ToGCJ02(LatLng latLng) {
        double x_pi = 52.35987755982988;
        double x = latLng.longitude - 0.0065;
        double y = latLng.latitude - 0.006;
        double z = Math.sqrt(x * x + y * y) - 2.0E-5 * Math.sin(y * x_pi);
        double theta = Math.atan2(y, x) - 3.0E-6 * Math.cos(x * x_pi);
        double gg_lat = z * Math.sin(theta);
        double gg_lng = z * Math.cos(theta);
        return new LatLng(gg_lat, gg_lng);
    }

    public static LatLng GCJ02ToBD09(LatLng latLng) {
        double x_pi = 52.35987755982988;
        double z = Math.sqrt(latLng.longitude * latLng.longitude + latLng.latitude * latLng.latitude) + 2.0E-5 * Math.sin(latLng.latitude * x_pi);
        double theta = Math.atan2(latLng.latitude, latLng.longitude) + 3.0E-6 * Math.cos(latLng.longitude * x_pi);
        double bd_lat = z * Math.sin(theta) + 0.006;
        double bd_lng = z * Math.cos(theta) + 0.0065;
        return new LatLng(bd_lat, bd_lng);
    }

    public static void openGaoDeNavi(Context context, double slat, double slon, String sname, double dlat, double dlon, String dname) {
        String uriString = null;
        StringBuilder builder = new StringBuilder("amapuri://route/plan?sourceApplication=maxuslife");
        if (slat != 0.0) {
            builder.append("&sname=").append(sname).append("&slat=").append(slat).append("&slon=").append(slon);
        }
        builder.append("&dlat=").append(dlat).append("&dlon=").append(dlon).append("&dname=").append(dname).append("&dev=0").append("&t=0");
        uriString = builder.toString();
        Intent intent = new Intent("android.intent.action.VIEW");
        intent.setPackage(PN_GAODE_MAP);
        intent.setData(Uri.parse((String)uriString));
        context.startActivity(intent);
    }

    public static void openTencentMap(Context context, double slat, double slon, String sname, double dlat, double dlon, String dname) {
        String uriString = null;
        StringBuilder builder = new StringBuilder("qqmap://map/routeplan?type=drive&policy=0&referer=zhongshuo");
        if (slat != 0.0) {
            builder.append("&from=").append(sname).append("&fromcoord=").append(slat).append(",").append(slon);
        }
        builder.append("&to=").append(dname).append("&tocoord=").append(dlat).append(",").append(dlon);
        uriString = builder.toString();
        Intent intent = new Intent("android.intent.action.VIEW");
        intent.setPackage(PN_TENCENT_MAP);
        intent.setData(Uri.parse((String)uriString));
        context.startActivity(intent);
    }

    public static void openBaiDuNavi(Context context, double slat, double slon, String sname, double dlat, double dlon, String dname) {
        String uriString = null;
        double[] destination = OpenThirdPartyMap.gaoDeToBaidu(dlat, dlon);
        dlat = destination[0];
        dlon = destination[1];
        StringBuilder builder = new StringBuilder("baidumap://map/direction?mode=driving&");
        if (slat != 0.0) {
            double[] origin = OpenThirdPartyMap.gaoDeToBaidu(slat, slon);
            slat = origin[0];
            slon = origin[1];
            builder.append("origin=latlng:").append(slat).append(",").append(slon).append("|name:").append(sname);
        }
        builder.append("&destination=latlng:").append(dlat).append(",").append(dlon).append("|name:").append(dname);
        uriString = builder.toString();
        Intent intent = new Intent("android.intent.action.VIEW");
        intent.setPackage(PN_BAIDU_MAP);
        intent.setData(Uri.parse((String)uriString));
        context.startActivity(intent);
    }

    public static boolean isInstallByread(String packageName) {
        return new File("/data/data/" + packageName).exists();
    }

    public static boolean isGdMapInstalled() {
        return OpenThirdPartyMap.isInstallByread(PN_GAODE_MAP);
    }

    public static boolean isBaiduMapInstalled() {
        return OpenThirdPartyMap.isInstallByread(PN_BAIDU_MAP);
    }

    public static boolean isTencentMapInstalled() {
        return OpenThirdPartyMap.isInstallByread(PN_TENCENT_MAP);
    }

    public static void openBrowserDownloadMap(String mapType, Context context) {
        Uri downloadUri = null;
        if (PN_GAODE_MAP.equals(mapType)) {
            downloadUri = Uri.parse((String)DL_GAODE_MAP);
        } else if (PN_BAIDU_MAP.equals(mapType)) {
            downloadUri = Uri.parse((String)DL_BAIDU_MAP);
        }
        if (PN_TENCENT_MAP.equals(mapType)) {
            downloadUri = Uri.parse((String)DL_TENCENT_MAP);
        }
        Intent intent = new Intent("android.intent.action.VIEW", downloadUri);
        context.startActivity(intent);
    }
}

