/*
 * Decompiled with CFR 0.152.
 */
package com.aofeng.hybrid.sync;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Environment;
import android.support.annotation.RequiresApi;
import android.support.v4.content.FileProvider;
import com.aofeng.hybrid.activity.PreludeActivity;
import com.aofeng.hybrid.orm.DBMeta;
import com.aofeng.hybrid.service.LogicMapper;
import com.aofeng.hybrid.service.PathMapper;
import com.aofeng.hybrid.service.SqlMapper;
import com.aofeng.hybrid.sync.IProgressNotifier;
import com.aofeng.hybrid.sync.MD5Manager;
import com.aofeng.hybrid.sync.SyncAPKHelper;
import com.aofeng.hybrid.sync.SyncDBHelper;
import com.aofeng.hybrid.sync.SyncFileHelper;
import com.aofeng.hybrid.sync.SyncParam;
import com.aofeng.hybrid.util.CommUtil;
import com.aofeng.hybrid.util.LogUtil;
import com.aofeng.hybrid.util.UnzipUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;
import org.json.JSONArray;
import org.json.JSONObject;

public class SyncDBAndPagesTask
extends AsyncTask<SyncParam, Integer, Boolean> {
    private IProgressNotifier progressNotifier;
    private Date newModifiedDate;
    private Context context;
    public static String UPDATE_MOST_RECENT_TIME = "UPDATE_MOST_RECENT_TIME";
    public static final int MAX_REQUEST_TIMES = 5;
    private int appVerTimes;
    private JSONObject appVer;
    private String fileName = "";

    public SyncDBAndPagesTask(Context context, IProgressNotifier pn) {
        this.context = context;
        this.progressNotifier = pn;
        this.appVerTimes = 0;
        this.appVer = null;
    }

    protected Boolean doInBackground(SyncParam ... params) {
        try {
            SyncParam sp = params[0];
            if (sp.getAppVerCheckUrl() == null) {
                sp.setAppVerCheckUrl(sp.getAppUpdateUrl() + "/rs/dir/version");
            }
            if (sp.getAppVerCheckUrl().length() != 0 && this.appNeedsUpdate(sp.getAppVerCheckUrl())) {
                this.updateApp(sp.getAppUpdateUrl());
                return false;
            }
            String signPackageName = CommUtil.getSharedPreference(this.context, "signPackageName");
            if (CommUtil.getSharedPreference(this.context, "hasSign") != null && "true".equals(CommUtil.getSharedPreference(this.context, "hasSign")) && !SyncAPKHelper.CheckInstall(this.context, signPackageName)) {
                String signAPKName = CommUtil.getSharedPreference(this.context, "signAPKName");
                SyncAPKHelper.downloadSignAPKBackground(this.context, signAPKName);
                return false;
            }
            if (!this.needsSync(sp.getLastUpdateTime())) {
                return false;
            }
            if (sp.getEntities() != null && !"".equals(sp.getEntities().trim()) && sp.getDbMetaUrl() != null && !"".equals(sp.getDbMetaUrl().trim())) {
                this.alignDB(sp.getDbMetaUrl(), sp.getEntities());
            }
            LogUtil.d("doInBackground", "\u5f53\u524d\u7cfb\u7edf\u7248\u672c:" + Build.VERSION.SDK_INT);
            boolean updateFile = false;
            if (Build.VERSION.SDK_INT >= 24 && sp.getZipWWWRoot() != null) {
                updateFile = this.alignH5PagesZIP(sp.getDirUrl() + URLEncoder.encode(sp.getZipWWWRoot()).replace("+", "%20"), sp.getZipWWWRoot(), sp.getLocalPathRoot() + "www/", sp.getFileDownloadUrl());
            }
            if (!updateFile) {
                this.alignH5Pages(sp.getDirUrl() + URLEncoder.encode(sp.getRemoteWWWRoot()).replace("+", "%20"), sp.getRemoteWWWRoot(), sp.getLocalPathRoot() + "www/", sp.getFileDownloadUrl());
            }
            if (sp.getRemoteBzRoot() != null && !"".equals(sp.getRemoteBzRoot().trim())) {
                this.alignSqlAndBz(sp.getDirUrl() + URLEncoder.encode(sp.getRemoteBzRoot()).replace("+", "%20"), sp.getRemoteBzRoot(), sp.getLocalPathRoot(), sp.getFileDownloadUrl());
                SqlMapper.loadMap(this.context);
                LogicMapper.loadMap(this.context);
                PathMapper.loadMap(this.context);
            }
            if (this.newModifiedDate == null) {
                this.newModifiedDate = new Date(70, 1, 1);
            }
            CommUtil.savePreference(this.context, sp.getAppId(), UPDATE_MOST_RECENT_TIME, this.newModifiedDate.getTime() + "");
            return Boolean.TRUE;
        }
        catch (Exception e) {
            e.printStackTrace();
            return Boolean.FALSE;
        }
    }

    private void updateApp(String appUpdateUrl) throws Exception {
        String apkName = "".equals(CommUtil.getSharedPreference(this.context, "apkName")) ? "update.apk" : CommUtil.getSharedPreference(this.context, "apkName");
        HttpGet getMethod = new HttpGet(appUpdateUrl + "/" + apkName);
        HttpClient httpClient = CommUtil.getTimeoutHttpClient();
        HttpResponse res = httpClient.execute((HttpUriRequest)getMethod);
        int code = res.getStatusLine().getStatusCode();
        String PATH = Environment.getExternalStorageDirectory() + "/safecheck";
        File file = new File(PATH);
        file.mkdirs();
        File outputFile = new File(file, apkName);
        String fileName = outputFile.getAbsolutePath();
        if (outputFile.exists()) {
            outputFile.delete();
        }
        FileOutputStream fos = new FileOutputStream(outputFile);
        InputStream is = res.getEntity().getContent();
        byte[] buffer = new byte[1024];
        int len1 = 0;
        boolean n = false;
        while ((len1 = is.read(buffer)) != -1) {
            fos.write(buffer, 0, len1);
        }
        fos.flush();
        fos.close();
        is.close();
        this.fileName = fileName;
        Intent intent = new Intent("android.intent.action.VIEW");
        if (Build.VERSION.SDK_INT >= 24) {
            intent.setFlags(0x10000000);
            intent.addFlags(1);
            Uri uri = FileProvider.getUriForFile((Context)this.context, (String)"com.aofeng.hybridwork.provider", (File)new File(fileName));
            intent.setDataAndType(uri, "application/vnd.android.package-archive");
        } else {
            intent.setDataAndType(Uri.fromFile((File)new File(fileName)), "application/vnd.android.package-archive");
        }
        this.context.startActivity(intent);
        System.exit(-1);
    }

    @RequiresApi(api=26)
    private boolean isHasInstallPermissionWithO(Context context) {
        if (context == null) {
            return false;
        }
        return context.getPackageManager().canRequestPackageInstalls();
    }

    @RequiresApi(api=26)
    private void startInstallPermissionSettingActivity(Context context) {
        if (context == null) {
            return;
        }
        Intent intent = new Intent("android.settings.MANAGE_UNKNOWN_APP_SOURCES");
        ((Activity)context).startActivityForResult(intent, 1);
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (resultCode == -1) {
            Intent intent = new Intent("android.intent.action.VIEW");
            intent.setFlags(0x10000000);
            intent.addFlags(1);
            Uri uri = FileProvider.getUriForFile((Context)this.context, (String)"com.aofeng.hybridwork.provider", (File)new File(this.fileName));
            intent.setDataAndType(uri, "application/vnd.android.package-archive");
        }
    }

    private boolean appNeedsUpdate(String appVerCheckUrl) {
        if (this.appVerTimes > 5) {
            PreludeActivity.getVersionErr = true;
            return false;
        }
        try {
            HttpGet getMethod = new HttpGet(appVerCheckUrl);
            HttpClient httpClient = CommUtil.getTimeoutHttpClient();
            HttpResponse response = httpClient.execute((HttpUriRequest)getMethod);
            int code = response.getStatusLine().getStatusCode();
            if (code == 200) {
                String results = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF8");
                this.appVer = new JSONObject(results);
                String appVerName = "".equals(CommUtil.getSharedPreference(this.context, "appVer")) ? "appVer" : CommUtil.getSharedPreference(this.context, "appVer");
                int serverVersion = this.appVer.getInt(appVerName);
                int appVer = CommUtil.getVersionCode(this.context);
                PreludeActivity.getVersionErr = false;
                PreludeActivity.needUpdate = appVer < serverVersion;
                CommUtil.setSharedPreference(this.context, "f_appVer", String.valueOf(appVer));
                return appVer < serverVersion;
            }
            ++this.appVerTimes;
            Thread.sleep(3000L);
            return this.appNeedsUpdate(appVerCheckUrl);
        }
        catch (Exception e) {
            ++this.appVerTimes;
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return this.appNeedsUpdate(appVerCheckUrl);
        }
    }

    protected void alignSqlAndBz(String dirUrl, String remoteBzRoot, String localPathRoot, String fileDownloadUrl) throws Exception {
        String result;
        dirUrl = dirUrl.replaceFirst("dir\\?.*$", "dir2");
        fileDownloadUrl = fileDownloadUrl.replaceFirst("dir.*$", "dir2");
        HttpGet getMethod = new HttpGet(dirUrl);
        HttpClient httpClient = CommUtil.getTimeoutHttpClient();
        HttpResponse res = httpClient.execute((HttpUriRequest)getMethod);
        int code = res.getStatusLine().getStatusCode();
        if (code == 200) {
            SyncFileHelper.makeRootDir(localPathRoot + "sqls/");
            SyncFileHelper.makeRootDir(localPathRoot + "logics/");
            result = EntityUtils.toString((HttpEntity)res.getEntity(), (String)"UTF-8");
            String[] files = result.split("\\|", -1);
            int i = 0;
            int n = files.length;
            for (String file : files) {
                LogUtil.d("\u540c\u6b65\u4e1a\u52a1\u6587\u4ef6", "\u540c\u6b65\u6587\u4ef6:" + file);
                this.publishProgress(new Integer[]{60 + i * 40 / n});
                ++i;
                if (!file.contains("sqls/") && !file.contains("paths/") && !file.contains("logics/") && !file.contains("sql.xml,") && !file.contains("logic.xml,") && !file.contains("path.xml,") && !file.contains("\\sqls\\") && !file.contains("\\logics\\") && !file.contains("\\path\\") && !file.contains("\\paths\\") && !file.contains("/sqls/") && !file.contains("/logics/") && !file.contains("/path/") && !file.contains("/paths/")) continue;
                this.updateFile2(file, remoteBzRoot, localPathRoot, fileDownloadUrl);
            }
        } else {
            throw new Exception("\u540c\u6b65\u6587\u4ef6\u51fa\u9519\u3002");
        }
        LogUtil.d("\u540c\u6b65MD5\u6587\u4ef6", "\u540c\u6b65\u6587\u4ef6:MD5");
        MD5Manager.getInstance().saveMd5(result);
        this.publishProgress(new Integer[]{100});
    }

    @SuppressLint(value={"SimpleDateFormat"})
    private boolean needsSync(String lastModifiedTime) throws Exception {
        boolean needSync;
        if (this.appVer == null) {
            return false;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String version = "".equals(CommUtil.getSharedPreference(this.context, "hybrid_version")) ? "hybrid_version" : CommUtil.getSharedPreference(this.context, "hybrid_version");
        String hybrid = "".equals(CommUtil.getSharedPreference(this.context, "f_hybrid_version")) ? sdf.format(new Date()) : CommUtil.getSharedPreference(this.context, "f_hybrid_version");
        this.newModifiedDate = this.appVer.has(version) ? sdf.parse(this.appVer.getString(version)) : sdf.parse(hybrid);
        CommUtil.setSharedPreference(this.context, "f_hybrid_version", sdf.format(this.newModifiedDate));
        if (lastModifiedTime == null) {
            PreludeActivity.needUpdate = true;
            return true;
        }
        LogUtil.d("Async server timestamp", this.appVer.getString(version));
        LogUtil.d("Async client timestamp", sdf.format(new Date(Long.parseLong(lastModifiedTime))));
        PreludeActivity.needUpdate = needSync = new Date(Long.parseLong(lastModifiedTime)).before(this.newModifiedDate);
        return needSync;
    }

    private void alignH5Pages(String fetchUrl, String remoteDir, String localDirPrefix, String fileDownloadUrl) throws Exception {
        HttpGet getMethod = new HttpGet(fetchUrl);
        HttpClient httpClient = CommUtil.getTimeoutHttpClient();
        HttpResponse res = httpClient.execute((HttpUriRequest)getMethod);
        int code = res.getStatusLine().getStatusCode();
        if (code == 200) {
            SyncFileHelper.makeRootDir(localDirPrefix);
            String result = EntityUtils.toString((HttpEntity)res.getEntity(), (String)"UTF-8");
            String[] files = result.split("\\|", -1);
            int i = 0;
            int n = files.length;
            for (String file : files) {
                LogUtil.d("\u540c\u6b65\u6587\u4ef6", "\u540c\u6b65\u6587\u4ef6:" + file);
                this.updateFile(file, remoteDir, localDirPrefix, fileDownloadUrl);
                this.publishProgress(new Integer[]{30 + i * 30 / n});
                ++i;
            }
        } else {
            throw new Exception("\u540c\u6b65\u6587\u4ef6\u51fa\u9519\u3002");
        }
        this.publishProgress(new Integer[]{60});
    }

    @RequiresApi(api=24)
    private Boolean alignH5PagesZIP(String fetchUrl, String remoteDir, String localDirPrefix, String fileDownloadUrl) throws Exception {
        Boolean hasZip = false;
        HttpGet getMethod = new HttpGet(fetchUrl);
        HttpClient httpClient = CommUtil.getTimeoutHttpClient();
        HttpResponse res = httpClient.execute((HttpUriRequest)getMethod);
        int code = res.getStatusLine().getStatusCode();
        if (code == 200) {
            SyncFileHelper.makeRootDir(localDirPrefix);
            String result = EntityUtils.toString((HttpEntity)res.getEntity(), (String)"UTF-8");
            if ("".equals(result)) {
                LogUtil.d("\u68c0\u67e5zip\u6587\u4ef6", "\u672a\u53d1\u73b0zip\u6587\u4ef6");
            } else {
                String[] files;
                for (String file : files = result.split("\\|", -1)) {
                    if (file.indexOf(".zip") == -1) continue;
                    LogUtil.d("\u5220\u9664\u6307\u5b9a\u6587\u4ef6\u5939\u4e0b\u7684\u6587\u4ef6", "\u5220\u9664\u6307\u5b9a\u6587\u4ef6\u5939\u4e0b\u7684\u6587\u4ef6:" + localDirPrefix);
                    this.delZipToPath(localDirPrefix);
                    int i = 0;
                    int n = files.length;
                    LogUtil.d("\u540c\u6b65\u6587\u4ef6", "\u540c\u6b65\u6587\u4ef6:" + file);
                    this.updateFile(file, remoteDir, localDirPrefix, fileDownloadUrl);
                    this.publishProgress(new Integer[]{30 + i * 30 / n});
                    ++i;
                    this.unzipToPath(localDirPrefix, null);
                    hasZip = true;
                    this.publishProgress(new Integer[]{60});
                    break;
                }
            }
        }
        return hasZip;
    }

    private void updateFile(String fileNameAndDate, String remoteDir, String localDirPrefix, String fileDownloadUrl) throws Exception {
        String[] pair = fileNameAndDate.split(",");
        String path = pair[0].replace(remoteDir, "");
        long timestamp = Long.parseLong(pair[1]);
        SyncFileHelper.processFile(localDirPrefix, path, timestamp, remoteDir, fileDownloadUrl);
    }

    private void updateFile2(String fileNameAndDate, String remoteDir, String localDirPrefix, String fileDownloadUrl) throws Exception {
        String[] pair = fileNameAndDate.split(",");
        String path = pair[0].replace(remoteDir, "");
        String md5 = pair[1];
        SyncFileHelper.processFile2(localDirPrefix, path, md5, remoteDir, fileDownloadUrl);
    }

    private void delZipToPath(String sourcePath) throws Exception {
        File f = new File(sourcePath);
        if (f.exists()) {
            File[] files;
            for (File file : files = f.listFiles()) {
                if (file.isDirectory()) {
                    this.delZipToPath(sourcePath + file.getName() + '/');
                    file.delete();
                    continue;
                }
                file.delete();
            }
        }
    }

    @RequiresApi(api=24)
    private void unzipToPath(String sourcePath, String targetPath) throws Exception {
        File f = new File(sourcePath);
        if (f.exists()) {
            File[] files;
            for (File file : files = f.listFiles()) {
                String filename = file.getName();
                if (filename.indexOf(".zip") == -1) continue;
                try {
                    System.out.println("\u6211\u770b\u770b\u8c01\u8fdb\u6765\u4e86\uff1f\uff1f\uff1f" + filename);
                    if (targetPath == null) {
                        targetPath = sourcePath;
                    } else if (!new File(targetPath).exists()) {
                        new File(targetPath).mkdirs();
                    }
                    UnzipUtil.UnzipToFolder(sourcePath + filename, targetPath);
                    return;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return;
                }
            }
        }
    }

    private void createOrUpdateTable(HashMap<String, Object> map) throws Exception {
        String tableName = (String)map.get("tableName");
        if (!SyncDBHelper.hasTable(this.context, tableName)) {
            SyncDBHelper.createTable(this.context, tableName, map);
        } else {
            SyncDBHelper.updateTable(this.context, tableName, map);
        }
    }

    private void createOrUpdateLinkColumn(JSONObject jsonTable) throws Exception {
        JSONArray associations = jsonTable.getJSONArray("__associations__");
        for (int i = 0; i < associations.length(); ++i) {
            JSONObject pair = associations.getJSONObject(i);
            SyncDBHelper.createOrUpdateLinkColumn(this.context, pair.getString("table2"), pair.getString("key2"), pair.getString("type"));
        }
    }

    private void alignDB(String metaUrl, String tables) throws Exception {
        HttpPost postMethod = new HttpPost(metaUrl);
        HttpClient httpClient = CommUtil.getTimeoutHttpClient();
        HttpResponse res = httpClient.execute((HttpUriRequest)postMethod);
        int code = res.getStatusLine().getStatusCode();
        if (code == 200) {
            DBMeta.str2Map(EntityUtils.toString((HttpEntity)res.getEntity(), (String)"UTF-8"));
            DBMeta.saveMeta(this.context);
            HashMap<String, HashMap<String, Object>> meta = DBMeta.getMeta(this.context);
            String[] entities = tables.split(",");
            int n = entities.length;
            int i = 0;
            for (String entity : entities) {
                entity = entity.trim();
                LogUtil.d("\u540c\u6b65\u8868\uff1a", "\u5904\u7406\u8868:" + entity);
                if (!meta.containsKey(entity)) {
                    throw new Exception("\u5b9e\u4f53" + entity + "\u4e0d\u5b58\u5728");
                }
                this.createOrUpdateTable(meta.get(entity));
                this.publishProgress(new Integer[]{i * 20 / n});
                ++i;
            }
            this.publishProgress(new Integer[]{20});
            i = 0;
            for (String entity : entities) {
                entity = entity.trim();
                LogUtil.d("\u540c\u6b65\u8868\uff1a", "\u5904\u7406\u8868:" + entity);
                if (!meta.containsKey(entity)) {
                    throw new Exception("\u5b9e\u4f53" + entity + "\u4e0d\u5b58\u5728");
                }
                SyncDBHelper.createOrUpdateLinkColumn(this.context, meta.get(entity));
                this.publishProgress(new Integer[]{20 + i * 10 / n});
                ++i;
            }
        } else {
            throw new Exception("\u540c\u6b65\u6570\u636e\u5e93\u51fa\u9519\u3002");
        }
        this.publishProgress(new Integer[]{30});
    }

    protected void onPreExecute() {
        super.onPreExecute();
        this.progressNotifier.prelude();
    }

    protected void onPostExecute(Boolean result) {
        super.onPostExecute((Object)result);
        this.progressNotifier.notifyDone(result);
    }

    protected void onProgressUpdate(Integer ... progress) {
        if (this.progressNotifier != null) {
            this.progressNotifier.notifyProgress(progress[0]);
        }
    }
}

