/*
 * Decompiled with CFR 0.152.
 */
package com.aofeng.hybrid.pos.reader;

import android.os.RemoteException;
import com.aofeng.hybrid.activity.MainActivity;
import com.aofeng.hybrid.pos.device.CTDevice;
import com.aofeng.hybrid.pos.reader.CardAgent;
import com.aofeng.hybrid.pos.reader.Chip;
import com.aofeng.hybrid.pos.reader.ICardReader;
import com.aofeng.hybrid.util.CommUtil;
import com.aofeng.hybrid.util.HexDump;

public class CTNativeReader
implements ICardReader {
    private static int SLOT = 0;

    @Override
    public boolean openDevice(Chip chip) {
        return CTNativeReader.openReader(chip);
    }

    @Override
    public boolean closeDevice(Chip chip) {
        return CTNativeReader.closeReader(chip);
    }

    @Override
    public boolean read(Chip chip) {
        try {
            CardAgent.log("StartReadCard-chipName:" + chip.chipName);
            if (chip.chipName == 1) {
                return CTNativeReader.read4442(0, 256, chip.buf);
            }
            if (chip.chipName == 0) {
                if (chip.secret != null) {
                    for (int i = 0; i < chip.secret.length(); i += 4) {
                        String pwd = chip.secret.substring(i, i + 4);
                        if (!CTNativeReader.verify102Pwd(HexDump.hexStringToByteArray(pwd))) continue;
                        chip.secret = pwd;
                        return CTNativeReader.read102(0, 178, chip.buf, HexDump.hexStringToByteArray(pwd));
                    }
                    return false;
                }
                return CTNativeReader.read102(0, 178, chip.buf, null);
            }
            if (chip.chipName == 3) {
                return CTNativeReader.read24C02(0, 256, chip.buf);
            }
            if (chip.chipName == 6) {
                if (chip.secret != null) {
                    String[] kmms = chip.secret.split("\\|");
                    String area2WritePwd = CTNativeReader.get1608AreaPwd(2, 0, kmms);
                    if (area2WritePwd != null) {
                        for (int i = 0; i < area2WritePwd.length(); i += 6) {
                            String pwd = area2WritePwd.substring(i, i + 6);
                            if (!CTNativeReader.verify1608Pwd((byte)2, (byte)1, HexDump.hexStringToByteArray(pwd))) continue;
                            return CTNativeReader.read1608(2, 0, 256, chip.buf);
                        }
                    }
                    return false;
                }
                if (chip.secret_1608 != null) {
                    String[] kmms = chip.secret_1608.split("\\|");
                    String area2WritePwd = CTNativeReader.get1608AreaPwd(7, 0, kmms);
                    if (area2WritePwd != null) {
                        for (int i = 0; i < area2WritePwd.length(); i += 6) {
                            String pwd = area2WritePwd.substring(i, i + 6);
                            if (!CTNativeReader.verify1608Pwd((byte)7, (byte)1, HexDump.hexStringToByteArray(pwd))) continue;
                            return CTNativeReader.read1608(7, 0, 256, chip.buf);
                        }
                    }
                    return false;
                }
                return CTNativeReader.read1608Config(8, 0, 128, chip.buf);
            }
            if (chip.chipName == 8) {
                if (chip.secret == null) {
                    byte[] key = new byte[]{-1, -1, -1, -1, -1, -1};
                    return CTNativeReader.readM1card(chip.addid, key, chip);
                }
                String[] kmms = chip.secret.split("\\|");
                String pwd = kmms[5];
                byte[] key = HexDump.hexStringToByteArray(pwd);
                return CTNativeReader.readM1card(chip.addid, key, chip);
            }
            if (chip.chipName == 7) {
                return this.resetCPUCard() != null;
            }
            if (chip.chipName == 11) {
                if (chip.secret == null) {
                    return CTNativeReader.read153Config(3, 0, 64, chip.buf);
                }
                String[] kmms = chip.secret.split("\\|");
                String area2WritePwd = CTNativeReader.get1608AreaPwd(0, 0, kmms);
                if (area2WritePwd != null) {
                    for (int i = 0; i < area2WritePwd.length(); i += 6) {
                        String pwd = area2WritePwd.substring(i, i + 6);
                        if (!CTNativeReader.verify1608Pwd((byte)0, (byte)1, HexDump.hexStringToByteArray(pwd))) continue;
                        for (int j = 0; j < 3; ++j) {
                            boolean result = CTNativeReader.read153(j, 0, 64, chip.buf);
                            if (result) continue;
                            return false;
                        }
                    }
                }
                return true;
            }
            return false;
        }
        catch (Exception e) {
            CardAgent.log("ReadCardExcep:" + e.getMessage());
            return false;
        }
    }

    @Override
    public boolean write(Chip chip, int block, int offset, int len, byte[] buf, byte[] secret) {
        if (chip.chipName == 0) {
            return CTNativeReader.write102(offset, len, buf, null);
        }
        if (chip.chipName == 1) {
            return CTNativeReader.write4442(offset, len, buf, secret);
        }
        if (chip.chipName == 3) {
            return CTNativeReader.write24c02(offset, len, buf);
        }
        if (chip.chipName == 6) {
            if (CTNativeReader.verify1608Pwd((byte)block, (byte)0, secret)) {
                return CTNativeReader.write1608(block, offset, buf);
            }
            return false;
        }
        if (chip.chipName == 11) {
            return CTNativeReader.write153(block, offset, buf);
        }
        if (chip.chipName == 8) {
            String pwd;
            byte[] key = new byte[]{-1, -1, -1, -1, -1, -1};
            if (chip.secret == null) {
                chip.secret = HexDump.toHexString(key) + "|";
                String[] kmms = chip.secret.split("\\|");
                pwd = kmms[0];
            } else {
                String[] kmms = chip.secret.split("\\|");
                pwd = kmms[offset];
            }
            if (block == 3) {
                return true;
            }
            if (block == 4) {
                key = HexDump.hexStringToByteArray(pwd);
                return CTNativeReader.writeM1card(chip.addid, key, buf, block);
            }
            return false;
        }
        if (chip.chipName == 7) {
            return this.CPUsendAPDU(buf) != null;
        }
        return false;
    }

    @Override
    public boolean verifyPwd(Chip chip, int block, byte[] secret) {
        if (chip.chipName == 0) {
            for (int i = 0; i < secret.length; i += 2) {
                if (!CTNativeReader.verify102Pwd(new byte[]{secret[i], secret[i + 1]})) continue;
                return true;
            }
            return false;
        }
        if (chip.chipName == 11) {
            for (int i = 0; i < secret.length; i += 3) {
                if (!CTNativeReader.verify1608Pwd((byte)0, (byte)0, new byte[]{secret[i], secret[i + 1], secret[i + 2]})) continue;
                return true;
            }
            return false;
        }
        if (chip.chipName == 1) {
            for (int i = 0; i < secret.length; i += 3) {
                if (!CTNativeReader.verify4442Pwd(new byte[]{secret[i], secret[i + 1], secret[i + 2]})) continue;
                return true;
            }
            return false;
        }
        return chip.chipName != 6;
    }

    @Override
    public boolean changePwd(Chip chip, int block, byte[] oldSecret, byte[] newSecret) {
        if (chip.chipName == 0) {
            return CTNativeReader.change102Pwd(HexDump.hexStringToByteArray(chip.secret), newSecret);
        }
        if (chip.chipName == 1) {
            return CTNativeReader.change4442Pwd(oldSecret, newSecret);
        }
        return chip.chipName != 6;
    }

    @Override
    public Chip getNvlChip() {
        int ct = CTNativeReader.getCardType();
        if (ct == 1) {
            return new Chip(1);
        }
        if (ct == 0) {
            return new Chip(0);
        }
        if (ct == 3) {
            return new Chip(3);
        }
        if (ct == 6) {
            return new Chip(6);
        }
        if (ct == 11) {
            return new Chip(11);
        }
        if (ct == 7) {
            return new Chip(7);
        }
        if (CTNativeReader.isRadioFrequency() == 8) {
            return new Chip(8);
        }
        if (CTNativeReader.isICCard()) {
            return new Chip(7);
        }
        return null;
    }

    @Override
    public boolean hasCard() {
        boolean hascard;
        try {
            String Slot = CommUtil.getSharedPreference(MainActivity.context, "SLOT");
            if ("1".equals(Slot)) {
                SLOT = 1;
            }
            CTDevice.m1card.open();
            CTDevice.iccard.open();
            if (SLOT == 1) {
                CTDevice.vMem102.open();
                CTDevice.vMem1608.open();
                CTDevice.vMem4442.open();
                CTDevice.vMemAT24C02.open();
                hascard = CTDevice.vMem102.status() == 1 || CTDevice.vMem1608.status() == 1 || CTDevice.vMem4442.status() == 1 || CTDevice.vMemAT24C02.status() == 1 || CTDevice.m1card.status() == 1 || CTDevice.iccard.status() == 1;
                CTDevice.vMem102.close();
                CTDevice.vMem1608.close();
                CTDevice.vMem4442.close();
                CTDevice.vMemAT24C02.close();
            } else {
                CTDevice.mem102.open();
                CTDevice.mem1608.open();
                CTDevice.mem4442.open();
                CTDevice.memAT24C02.open();
                hascard = CTDevice.mem102.status() == 1 || CTDevice.mem1608.status() == 1 || CTDevice.mem4442.status() == 1 || CTDevice.memAT24C02.status() == 1 || CTDevice.m1card.status() == 1 || CTDevice.iccard.status() == 1;
                CTDevice.mem102.close();
                CTDevice.mem1608.close();
                CTDevice.mem4442.close();
                CTDevice.memAT24C02.close();
            }
            CTDevice.m1card.close();
            CTDevice.iccard.close();
        }
        catch (RemoteException e) {
            return false;
        }
        return hascard;
    }

    private static String get1608AreaPwd(int area, int type, String[] pwd) {
        if (type == 0) {
            return pwd[(area + 1) * 2 - 1];
        }
        if (type == 1) {
            return pwd[(area + 1) * 2 - 2];
        }
        return null;
    }

    public static boolean verify1608Pwd(byte area, byte type, byte[] key) {
        try {
            if (SLOT == 1) {
                if (CTDevice.vMem1608.reset()) {
                    return CTDevice.vMem1608.verifyPsw(area, type, key);
                }
                return false;
            }
            if (CTDevice.mem1608.reset()) {
                return CTDevice.mem1608.verifyPsw(area, type, key);
            }
            return false;
        }
        catch (RemoteException e) {
            return false;
        }
    }

    public static boolean read153(int area, int offset, int len, byte[] buf) {
        byte[] data = null;
        try {
            data = SLOT == 1 ? CTDevice.vMem1608.read((byte)area, (byte)offset, len) : CTDevice.mem1608.read((byte)area, (byte)offset, len);
            if (null != data) {
                System.arraycopy(data, 0, buf, 64 * area, len);
            }
        }
        catch (RemoteException e) {
            return false;
        }
        return null != data;
    }

    public static boolean read153Config(int area, int offset, int len, byte[] buf) {
        byte[] data = null;
        try {
            data = SLOT == 1 ? CTDevice.vMem1608.read((byte)area, (byte)offset, len) : CTDevice.mem1608.read((byte)area, (byte)offset, len);
            if (null != data) {
                System.arraycopy(data, 0, buf, 192, 64);
            }
        }
        catch (RemoteException e) {
            return false;
        }
        return null != data;
    }

    public static boolean write153(int area, int offset, byte[] data) {
        boolean result;
        try {
            result = SLOT == 1 ? CTDevice.vMem1608.write((byte)area, (byte)offset, data) : CTDevice.mem1608.write((byte)area, (byte)offset, data);
        }
        catch (RemoteException e) {
            return false;
        }
        return result;
    }

    public static boolean read1608(int area, int offset, int len, byte[] buf) {
        byte[] data = null;
        try {
            data = SLOT == 1 ? CTDevice.vMem1608.read((byte)area, (byte)offset, len) : CTDevice.mem1608.read((byte)area, (byte)offset, len);
            if (null != data) {
                if (area == 2) {
                    System.arraycopy(data, 0, buf, 384, 256);
                } else {
                    System.arraycopy(data, 0, buf, 128, 256);
                }
            }
        }
        catch (RemoteException e) {
            return false;
        }
        return null != data;
    }

    public static boolean read1608Config(int area, int offset, int len, byte[] buf) {
        byte[] data = null;
        try {
            data = SLOT == 1 ? CTDevice.vMem1608.read((byte)area, (byte)offset, len) : CTDevice.mem1608.read((byte)area, (byte)offset, len);
            if (null != data) {
                System.arraycopy(data, 0, buf, 0, 128);
            }
        }
        catch (RemoteException e) {
            return false;
        }
        return null != data;
    }

    public static boolean write1608(int area, int offset, byte[] data) {
        boolean result;
        try {
            result = SLOT == 1 ? CTDevice.vMem1608.write((byte)area, (byte)offset, data) : CTDevice.mem1608.write((byte)area, (byte)offset, data);
        }
        catch (RemoteException e) {
            return false;
        }
        return result;
    }

    public static boolean openReader(Chip chip) {
        block18: {
            String Slot = CommUtil.getSharedPreference(MainActivity.context, "SLOT");
            if ("1".equals(Slot)) {
                SLOT = 1;
            }
            try {
                if (SLOT == 1) {
                    if (chip.chipName == 0) {
                        CTDevice.vMem102.open();
                        break block18;
                    }
                    if (chip.chipName == 1) {
                        CTDevice.vMem4442.open();
                        break block18;
                    }
                    if (chip.chipName == 3) {
                        CTDevice.vMemAT24C02.open();
                        break block18;
                    }
                    if (chip.chipName == 6) {
                        return CTDevice.vMem1608.open();
                    }
                    if (chip.chipName == 8) {
                        CTDevice.m1card.open();
                        return true;
                    }
                    if (chip.chipName == 7) {
                        CTDevice.iccard.open();
                        CTDevice.psam1.open();
                        return true;
                    }
                    if (chip.chipName == 11) {
                        return CTDevice.vMem1608.open();
                    }
                    return false;
                }
                if (chip.chipName == 0) {
                    CTDevice.mem102.open();
                    break block18;
                }
                if (chip.chipName == 1) {
                    CTDevice.mem4442.open();
                    break block18;
                }
                if (chip.chipName == 3) {
                    CTDevice.memAT24C02.open();
                    break block18;
                }
                if (chip.chipName == 6) {
                    return CTDevice.mem1608.open();
                }
                if (chip.chipName == 11) {
                    return CTDevice.mem1608.open();
                }
                if (chip.chipName == 8) {
                    CTDevice.m1card.open();
                    return true;
                }
                if (chip.chipName == 7) {
                    CTDevice.iccard.open();
                    CTDevice.psam1.open();
                    return true;
                }
                return false;
            }
            catch (RemoteException e) {
                return false;
            }
        }
        return true;
    }

    public static boolean closeReader(Chip chip) {
        block17: {
            try {
                if (SLOT == 1) {
                    if (chip.chipName == 0) {
                        CTDevice.vMem102.close();
                        break block17;
                    }
                    if (chip.chipName == 1) {
                        CTDevice.vMem4442.close();
                        break block17;
                    }
                    if (chip.chipName == 3) {
                        CTDevice.vMemAT24C02.close();
                        break block17;
                    }
                    if (chip.chipName == 6) {
                        return CTDevice.vMem1608.close();
                    }
                    if (chip.chipName == 8) {
                        CTDevice.m1card.close();
                        return true;
                    }
                    if (chip.chipName == 7) {
                        CTDevice.iccard.close();
                        return true;
                    }
                    if (chip.chipName == 11) {
                        return CTDevice.vMem1608.close();
                    }
                    return false;
                }
                if (chip.chipName == 0) {
                    CTDevice.mem102.close();
                    break block17;
                }
                if (chip.chipName == 1) {
                    CTDevice.mem4442.close();
                    break block17;
                }
                if (chip.chipName == 3) {
                    CTDevice.memAT24C02.close();
                    break block17;
                }
                if (chip.chipName == 6) {
                    return CTDevice.mem1608.close();
                }
                if (chip.chipName == 8) {
                    CTDevice.m1card.close();
                    return true;
                }
                if (chip.chipName == 7) {
                    CTDevice.iccard.close();
                    return true;
                }
                if (chip.chipName == 11) {
                    return CTDevice.mem1608.close();
                }
                return false;
            }
            catch (RemoteException e) {
                return false;
            }
        }
        return true;
    }

    public static int getCardType() {
        byte[] buf = null;
        try {
            String Slot = CommUtil.getSharedPreference(MainActivity.context, "SLOT");
            if ("1".equals(Slot)) {
                SLOT = 1;
            }
            if (SLOT == 1) {
                CTDevice.vMem102.open();
                CTDevice.vMem102.reset();
                buf = CTDevice.vMem102.read(0, 16);
                CTDevice.vMem102.close();
                if (buf[0] == 15 && buf[1] == 15 || buf[0] == 113 && buf[1] == 85 || buf[0] == 23 && buf[1] == -86 || buf[0] == 113 && buf[1] == 86 || buf[0] == -1 && buf[1] == 15 || buf[0] == -104 && buf[1] == 123) {
                    return 0;
                }
                buf = null;
                CTDevice.vMem4442.open();
                CTDevice.vMem4442.reset();
                buf = CTDevice.vMem4442.read((byte)0, (byte)8);
                CTDevice.vMem4442.close();
                if (buf[6] == -127 && buf[7] == 21) {
                    return 1;
                }
                if (CTNativeReader.isICCard()) {
                    return 7;
                }
                buf = null;
                CTDevice.vMem1608.open();
                boolean reset = CTDevice.vMem1608.reset();
                if (reset) {
                    buf = CTDevice.vMem1608.read((byte)8, (byte)0, 4);
                    CTDevice.vMem1608.close();
                    if (buf == null) {
                        return 11;
                    }
                    return 6;
                }
                buf = null;
                CTDevice.vMemAT24C02.open();
                buf = CTDevice.vMemAT24C02.read((byte)-95, (byte)8);
                CTDevice.vMemAT24C02.close();
                if (buf != null && buf.length == 8) {
                    return 3;
                }
            } else {
                CTDevice.mem102.open();
                CTDevice.mem102.reset();
                buf = CTDevice.mem102.read(0, 16);
                CTDevice.mem102.close();
                if (buf[0] == 15 && buf[1] == 15 || buf[0] == 113 && buf[1] == 85 || buf[0] == 23 && buf[1] == 170) {
                    return 0;
                }
                buf = null;
                CTDevice.mem4442.open();
                CTDevice.mem4442.reset();
                buf = CTDevice.mem4442.read((byte)0, (byte)8);
                CTDevice.mem4442.close();
                if (buf[6] == -127 && buf[7] == 21 || "A2131091".equals(HexDump.toHexString(buf, 0, 4))) {
                    return 1;
                }
                CTDevice.mem1608.open();
                boolean reset = CTDevice.mem1608.reset();
                if (reset) {
                    byte[] data = CTDevice.mem1608.read((byte)8, (byte)0, 4);
                    CTDevice.mem1608.close();
                    if (data != null) {
                        return 6;
                    }
                    return 11;
                }
                if (CTNativeReader.isICCard()) {
                    return 7;
                }
                buf = null;
                CTDevice.memAT24C02.open();
                buf = CTDevice.memAT24C02.read((byte)-95, (byte)8);
                CTDevice.memAT24C02.close();
                if (buf != null && buf.length == 8) {
                    return 3;
                }
            }
        }
        catch (Exception e) {
            return -1;
        }
        return -1;
    }

    public static boolean read4442(int offset, int len, byte[] buf) {
        byte[] data = null;
        byte[] data2 = null;
        if (CTNativeReader.get4442PwdAttemptCnt() <= 0) {
            return false;
        }
        try {
            if (SLOT == 1) {
                data = CTDevice.vMem4442.read((byte)offset, (byte)(len - 2));
                data2 = CTDevice.vMem4442.read((byte)(len - 2), (byte)2);
            } else {
                data = CTDevice.mem4442.read((byte)offset, (byte)(len - 2));
                data2 = CTDevice.mem4442.read((byte)(len - 2), (byte)2);
            }
            if (null != data) {
                System.arraycopy(data, 0, buf, 0, data.length);
                System.arraycopy(data2, 0, buf, 254, data2.length);
                return true;
            }
        }
        catch (RemoteException e) {
            return false;
        }
        return null != data;
    }

    public static int get4442PwdAttemptCnt() {
        byte[] buf = null;
        try {
            buf = SLOT == 1 ? CTDevice.vMem4442.readSecurityData() : CTDevice.mem4442.readSecurityData();
            if (null == buf) {
                return -1;
            }
            if (buf[0] == 7) {
                return 3;
            }
            if (buf[0] == 6 || buf[0] == 5 || buf[0] == 3) {
                return 2;
            }
            if (buf[0] == 4) {
                return 1;
            }
            return 0;
        }
        catch (RemoteException e) {
            return -1;
        }
    }

    public static int get102PwdAttemptCnt() {
        byte[] buf = null;
        try {
            buf = SLOT == 1 ? CTDevice.vMem102.read(96, 8) : CTDevice.mem102.read(96, 8);
            if (null == buf) {
                return -1;
            }
            if (buf[0] == -1) {
                return 4;
            }
            if (buf[0] == 127) {
                return 3;
            }
            if (buf[0] == 63) {
                return 2;
            }
            if (buf[0] == 31) {
                return 1;
            }
            return 0;
        }
        catch (RemoteException e) {
            return -1;
        }
    }

    public static boolean verify102Pwd(byte[] key) {
        try {
            if (SLOT == 1) {
                CTDevice.vMem102.open();
                CTDevice.vMem102.reset();
                return CTDevice.vMem102.verifyPassword(key);
            }
            CTDevice.mem102.open();
            CTDevice.mem102.reset();
            return CTDevice.mem102.verifyPassword(key);
        }
        catch (RemoteException e) {
            return false;
        }
    }

    public static boolean read102(int offset, int len, byte[] buf, byte[] key) {
        byte[] data = null;
        int ret = CTNativeReader.get102PwdAttemptCnt();
        if (ret <= 0) {
            return false;
        }
        if (key != null && !CTNativeReader.verify102Pwd(key)) {
            return false;
        }
        try {
            data = SLOT == 1 ? CTDevice.vMem102.read(offset * 8, len * 8) : CTDevice.mem102.read(offset * 8, len * 8);
            if (null != data) {
                System.arraycopy(data, 0, buf, 0, data.length);
                return true;
            }
        }
        catch (RemoteException e) {
            return false;
        }
        return null != data;
    }

    public static boolean read24C02(int offset, int len, byte[] buf) {
        byte[] data = null;
        try {
            for (int i = 0; i < len / 8; ++i) {
                int off = i * 8;
                data = SLOT == 1 ? CTDevice.vMemAT24C02.read((byte)-95, (byte)off) : CTDevice.memAT24C02.read((byte)-95, (byte)off);
                if (data == null) {
                    return false;
                }
                System.arraycopy(data, 0, buf, off, data.length);
            }
        }
        catch (RemoteException e) {
            return false;
        }
        return buf.length == len;
    }

    public static boolean write102(int offset, int len, byte[] buf, byte[] key) {
        if (CTNativeReader.get102PwdAttemptCnt() <= 0) {
            return false;
        }
        if (key != null && !CTNativeReader.verify102Pwd(key)) {
            return false;
        }
        try {
            if (SLOT == 1) {
                if (CTDevice.vMem102.eraseData(offset * 8, len * 8)) {
                    return CTDevice.vMem102.write(offset * 8, buf);
                }
                return false;
            }
            if (CTDevice.mem102.eraseData(offset * 8, len * 8)) {
                return CTDevice.mem102.write(offset * 8, buf);
            }
            return false;
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean change102Pwd(byte[] oldKey, byte[] newKey) {
        boolean b = false;
        if (CTNativeReader.get102PwdAttemptCnt() <= 0) {
            return false;
        }
        if (oldKey != null && !CTNativeReader.verify102Pwd(oldKey)) {
            return false;
        }
        try {
            if (SLOT == 1) {
                if (CTDevice.vMem102.eraseData(80, 16)) {
                    return CTDevice.vMem102.write(80, newKey);
                }
            } else if (CTDevice.mem102.eraseData(80, 16)) {
                return CTDevice.mem102.write(80, newKey);
            }
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return b;
    }

    public static boolean write4442(int offset, int len, byte[] buf, byte[] key) {
        if (CTNativeReader.get4442PwdAttemptCnt() <= 0) {
            return false;
        }
        if (key != null && !CTNativeReader.verify4442Pwd(key)) {
            return false;
        }
        try {
            if (SLOT == 1) {
                return CTDevice.vMem4442.writeData((byte)offset, buf);
            }
            return CTDevice.mem4442.writeData((byte)offset, buf);
        }
        catch (RemoteException e) {
            return false;
        }
    }

    public static boolean verify4442Pwd(byte[] key) {
        try {
            byte errCount = 1;
            if (SLOT == 1) {
                boolean reset = CTDevice.vMem4442.reset();
                if (reset) {
                    return CTDevice.vMem4442.verify(errCount, key);
                }
                return false;
            }
            boolean reset = CTDevice.mem4442.reset();
            if (reset) {
                return CTDevice.mem4442.verify(errCount, key);
            }
            return false;
        }
        catch (RemoteException e) {
            return false;
        }
    }

    public static boolean change4442Pwd(byte[] oldKey, byte[] newKey) {
        boolean b = false;
        if (CTNativeReader.get4442PwdAttemptCnt() <= 0) {
            return false;
        }
        if (oldKey != null && !CTNativeReader.verify4442Pwd(oldKey)) {
            return false;
        }
        try {
            b = SLOT == 1 ? CTDevice.vMem4442.changePassword(newKey) : CTDevice.mem4442.changePassword(newKey);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return b;
    }

    public static boolean write24c02(int offset, int len, byte[] buf) {
        try {
            if (SLOT == 1) {
                for (int i = 0; i < len / 8; ++i) {
                    int off = i * 8;
                    byte[] writeData = new byte[8];
                    System.arraycopy(buf, off, writeData, 0, 8);
                    boolean b = CTDevice.vMemAT24C02.write((byte)-96, (byte)off, writeData);
                    if (b) continue;
                    return false;
                }
            } else {
                for (int i = 0; i < len / 8; ++i) {
                    int off = i * 8;
                    byte[] writeData = new byte[8];
                    System.arraycopy(buf, off, writeData, 0, 8);
                    boolean b = CTDevice.memAT24C02.write((byte)-96, (byte)off, writeData);
                    if (b) continue;
                    return false;
                }
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static int isRadioFrequency() {
        try {
            CTDevice.rfcard.open();
            CTDevice.rfcard.reset();
            int ret = CTDevice.rfcard.readCardType();
            CTDevice.rfcard.close();
            if (ret == 16) {
                return 8;
            }
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return -1;
    }

    public static boolean m1cardattest(int key_type, byte addid, byte[] key, byte[] resetData) throws RemoteException {
        resetData = CTDevice.m1card.reset();
        if (resetData == null) {
            return false;
        }
        int ret = CTDevice.m1card.auth(key_type, addid, key, resetData);
        return ret == 0;
    }

    public static boolean readM1card(int addid, byte[] key, Chip chip) {
        byte[] resetData = null;
        byte[] buf = new byte[16];
        try {
            if (!CTNativeReader.m1cardattest(0, (byte)addid, key, resetData)) {
                return false;
            }
            for (int i = 0; i < 4; ++i) {
                int ret = CTDevice.m1card.readBlock((byte)(addid + i), buf);
                if (ret == 0) {
                    for (int j = 0; j < buf.length; ++j) {
                        if (addid == 16) {
                            chip.buf[i * buf.length + j] = buf[j];
                        }
                        if (addid != 20) continue;
                        chip.buf[i * buf.length + j + 64] = buf[j];
                    }
                    continue;
                }
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static boolean writeM1card(int addid, byte[] key, byte[] buf, int block) {
        byte[] resetData = null;
        try {
            if (!CTNativeReader.m1cardattest(0, (byte)addid, key, resetData)) {
                return false;
            }
            if (block == 3) {
                return true;
            }
            if (CTDevice.m1card.writeBlock((byte)addid, buf) != 0) {
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static boolean isICCard() {
        try {
            CTDevice.iccard.open();
            boolean ret = CTDevice.iccard.reset() != null;
            CTDevice.iccard.close();
            return ret;
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static void ICCardCheck() throws Exception {
        byte n = CTDevice.iccard.status();
        if (n == 0) {
            throw new Exception("\u5361\u72b6\u6001\u4e0d\u6b63\u786e\uff0c\u8bf7\u786e\u8ba4\u5361\u662f\u5426\u63d2\u5165\u6b63\u786e\uff01");
        }
    }

    @Override
    public byte[] CPUsendAPDU(byte[] APDU) {
        byte[] result = null;
        byte[] apdu = new byte[APDU[2]];
        System.arraycopy(APDU, 3, apdu, 0, APDU[2]);
        try {
            result = CTDevice.iccard.send(apdu);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return result;
    }

    @Override
    public byte[] RFsendAPDU(byte[] apdu) {
        return new byte[0];
    }

    public static byte[] asyncSendIccard(byte[] APDU) {
        byte[] result = null;
        byte[] apdu = new byte[APDU[2]];
        System.arraycopy(APDU, 3, apdu, 0, APDU[2]);
        try {
            result = CTDevice.iccard.send(apdu);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return result;
    }

    @Override
    public byte[] resetCPUCard() {
        byte[] result = null;
        try {
            result = CTDevice.iccard.reset();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    @Override
    public byte[] resetRFCard() {
        return new byte[0];
    }

    @Override
    public byte[] PSAMsendAPDU(byte[] APDU) {
        byte[] result = null;
        byte[] apdu = new byte[APDU[2]];
        System.arraycopy(APDU, 3, apdu, 0, APDU[2]);
        try {
            result = CTDevice.psam1.sendApdu(apdu);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return result;
    }

    @Override
    public byte[] resetPSAMCard() {
        byte[] result = null;
        try {
            result = CTDevice.psam1.reset();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return result;
    }
}

