/*
 * Decompiled with CFR 0.152.
 */
package com.aofeng.hybrid.plugin;

import android.webkit.ConsoleMessage;
import android.webkit.JsPromptResult;
import android.webkit.JsResult;
import android.webkit.WebChromeClient;
import android.webkit.WebView;
import android.widget.ProgressBar;
import android.widget.TextView;
import com.aofeng.hybrid.plugin.AFWebView;
import com.aofeng.hybrid.plugin.JsCallNative;
import com.aofeng.hybrid.util.LogUtil;

public class AFChromeClient
extends WebChromeClient {
    private final String TAG = "AFChromeClient";
    private JsCallNative mStub;
    private boolean mIsInjectedJS;
    private TextView mTvLog;
    private StringBuilder sb = new StringBuilder(512);

    public AFChromeClient(TextView logView, String injectedName, Class<?> injectedCls) {
        this.mTvLog = logView;
        this.mStub = new JsCallNative(injectedName, injectedCls);
    }

    public AFChromeClient(String injectedName, Class<?> injectedCls) {
        this(null, injectedName, injectedCls);
    }

    public boolean onJsAlert(WebView view, String url, String message, JsResult result) {
        result.confirm();
        return true;
    }

    public void onProgressChanged(WebView view, int newProgress) {
        if (newProgress <= 25) {
            this.mIsInjectedJS = false;
        } else if (!this.mIsInjectedJS) {
            view.loadUrl(this.mStub.getPreloadInterfaceJS());
            this.mIsInjectedJS = true;
            LogUtil.d("AFChromeClient", "\u6ce8\u5165js\u8c03\u7528\u5230\u9875\u9762\u5728\u52a0\u8f7d\u5230\uff1a" + newProgress);
        }
        if (view instanceof AFWebView) {
            AFWebView pwv = (AFWebView)view;
            ProgressBar pb = pwv.getmProgressBar();
            pb.setProgress(newProgress);
            if (newProgress > 90) {
                pb.setVisibility(8);
            } else {
                pb.setVisibility(0);
            }
        }
        super.onProgressChanged(view, newProgress);
    }

    public boolean onJsPrompt(WebView view, String url, String json, String defaultValue, JsPromptResult result) {
        String s = this.mStub.call(view, json);
        LogUtil.d("back to the webview:", s);
        result.confirm(s);
        return true;
    }

    public boolean onConsoleMessage(ConsoleMessage consoleMessage) {
        if (this.mTvLog != null) {
            if (this.sb.length() > 512) {
                String tmp = this.sb.substring(256);
                this.sb.setLength(0);
                this.sb.append(tmp);
            }
            this.sb.append(consoleMessage.message());
            this.sb.append("\n");
            this.mTvLog.setText((CharSequence)this.sb);
        }
        LogUtil.d("onConsoleMessage", consoleMessage.message());
        return super.onConsoleMessage(consoleMessage);
    }
}

