/*
 * Decompiled with CFR 0.152.
 */
package com.aofeng.hybrid.android.receiver;

import android.content.Context;
import android.os.Build;
import android.os.Handler;
import android.support.v4.content.ContextCompat;
import android.telephony.PhoneStateListener;
import android.telephony.SignalStrength;
import android.telephony.TelephonyManager;
import android.widget.Toast;
import com.amap.api.location.AMapLocation;
import com.amap.api.location.AMapLocationClient;
import com.amap.api.location.AMapLocationClientOption;
import com.amap.api.location.AMapLocationListener;
import com.amap.api.location.AMapLocationQualityReport;
import com.aofeng.hybrid.R;
import com.aofeng.hybrid.util.CommUtil;
import com.aofeng.hybrid.util.LogUtil;

public class PhoneStatusReceiver {
    private Context context;
    private Handler mainHandler;
    private static volatile PhoneStatusReceiver instance;
    private String[] permissions;
    private long sendMsgCount = 0L;
    private AMapLocationClientOption mLocationOption;
    private AMapLocationClient mLocationClient;
    private long locationCount;
    AMapLocationListener locationListener = new AMapLocationListener(){

        public void onLocationChanged(AMapLocation aMapLocation) {
            this.sendLocationBroadcast(aMapLocation);
        }

        private void sendLocationBroadcast(AMapLocation aMapLocation) {
            PhoneStatusReceiver.this.locationCount++;
            long callBackTime = System.currentTimeMillis();
            LogUtil.i("\u5b9a\u4f4d\u5b8c\u6210\uff1a", "\u7b2c" + PhoneStatusReceiver.this.locationCount + "\u6b21");
            if (null == aMapLocation || aMapLocation.getErrorCode() != 0) {
                LogUtil.e("\u5b9a\u4f4d\u5931\u8d25\uff1a", "location is null!!!!!!!");
                this.errorLocation(aMapLocation);
            } else {
                this.successLocation(aMapLocation);
            }
        }

        private synchronized void successLocation(AMapLocation aMapLocation) {
            boolean gpsQualityReport = this.getGpsQualityReport(aMapLocation);
            if (gpsQualityReport) {
                LogUtil.i("\u4f4d\u7f6e\u5b58\u50a8", "\u4f4d\u7f6e\u76d1\u542c\u5f00\u59cb");
                LogUtil.e("\u5b58\u5165\u4f4d\u7f6e\u4fe1\u606f", "\u4f4d\u7f6e\u76d1\u542c\u5f00\u59cb\uff1a\n" + aMapLocation.getLongitude() + "\n" + aMapLocation.getLatitude() + "\n" + aMapLocation.getSpeed() + "\n" + aMapLocation.getBearing());
                CommUtil.setSharedPreference(PhoneStatusReceiver.this.context, "longitude", aMapLocation.getLongitude() + "");
                CommUtil.setSharedPreference(PhoneStatusReceiver.this.context, "latitude", aMapLocation.getLatitude() + "");
                CommUtil.setSharedPreference(PhoneStatusReceiver.this.context, "altitude", aMapLocation.getAltitude() + "");
                CommUtil.setSharedPreference(PhoneStatusReceiver.this.context, "speed", aMapLocation.getSpeed() + "");
                CommUtil.setSharedPreference(PhoneStatusReceiver.this.context, "bearing", aMapLocation.getBearing() + "");
                CommUtil.setSharedPreference(PhoneStatusReceiver.this.context, "provider", aMapLocation.getProvider());
                CommUtil.setSharedPreference(PhoneStatusReceiver.this.context, "address", aMapLocation.getAddress());
            }
        }

        private synchronized void errorLocation(AMapLocation aMapLocation) {
            LogUtil.e("\u4f4d\u7f6e\u76d1\u542c\u5931\u8d25", "\u5b9a\u4f4d\u5931\u8d25\uff0clocation is null!!!!!!!");
            CommUtil.setSharedPreference(PhoneStatusReceiver.this.context, "longitude", "0");
            CommUtil.setSharedPreference(PhoneStatusReceiver.this.context, "latitude", "0");
            CommUtil.setSharedPreference(PhoneStatusReceiver.this.context, "altitude", "0");
            CommUtil.setSharedPreference(PhoneStatusReceiver.this.context, "speed", "0");
            CommUtil.setSharedPreference(PhoneStatusReceiver.this.context, "bearing", "0");
            CommUtil.setSharedPreference(PhoneStatusReceiver.this.context, "provider", "0");
            PhoneStatusReceiver.this.mainHandler.post(new Runnable(){

                @Override
                public void run() {
                    PhoneStatusReceiver.this.stopLocation();
                    PhoneStatusReceiver.this.mLocationClient.onDestroy();
                    PhoneStatusReceiver.this.mLocationClient = null;
                }
            });
            LogUtil.e("\u9ad8\u5fb7\u5b9a\u4f4d\u5931\u8d25\u6216\u4f4d\u7f6e\u4fe1\u606f\u4e0d\u53ef\u7528!", "\u9519\u8bef\u7801\uff1a" + aMapLocation.getErrorCode() + ";\u9519\u8bef\u4fe1\u606f:" + aMapLocation.getErrorInfo() + ";\u9519\u8bef\u63cf\u8ff0:" + aMapLocation.getLocationDetail());
        }

        private synchronized boolean getGpsQualityReport(AMapLocation aMapLocation) {
            String adviseMessage;
            AMapLocationQualityReport aMapLocationQualityReport = aMapLocation.getLocationQualityReport();
            if (null == aMapLocationQualityReport) {
                LogUtil.e("\u6ca1\u6709\u83b7\u53d6\u5230GPS\u72b6\u6001\u4fe1\u606f\uff0c\u9519\u8bef", "aMapLocationQualityReport\u5bf9\u8c61\u4e3anull");
                return false;
            }
            if (!aMapLocationQualityReport.isWifiAble()) {
                LogUtil.d("GPS\u4fe1\u606f\u83b7\u53d6", "\u5f53\u524dWIFI\u5df2\u5173\u95ed--\u5efa\u8bae\u6253\u5f00wifi\u5f00\u5173,\u4ee5\u63d0\u9ad8\u5b9a\u4f4d\u8d28\u91cf");
            }
            if (!"".equals(adviseMessage = aMapLocationQualityReport.getAdviseMessage()) && null != adviseMessage) {
                LogUtil.d("\u9ad8\u5fb7GPS\u7ed9\u51fa\u5efa\u8bae\uff1a", adviseMessage);
                if (PhoneStatusReceiver.this.sendMsgCount <= 3L) {
                    LogUtil.d("\u9ad8\u5fb7\u5efa\u8bae\u63d0\u793a", "sendMsgCount\u8ba1\u6570\u5668\u4e3a<=3\u63d0\u793a");
                    Toast.makeText((Context)PhoneStatusReceiver.this.context, (CharSequence)adviseMessage, (int)0).show();
                } else if (PhoneStatusReceiver.this.sendMsgCount % 60L == 0L) {
                    LogUtil.d("\u9ad8\u5fb7\u5efa\u8bae\u63d0\u793a", "sendMsgCount\u8ba1\u6570\u5668%60==0\u65f6\u63d0\u793a");
                    Toast.makeText((Context)PhoneStatusReceiver.this.context, (CharSequence)adviseMessage, (int)0).show();
                }
                PhoneStatusReceiver.this.sendMsgCount = PhoneStatusReceiver.this.sendMsgCount + 1L;
            }
            if (PhoneStatusReceiver.this.mLocationOption.getLocationMode() == AMapLocationClientOption.AMapLocationMode.Hight_Accuracy || PhoneStatusReceiver.this.mLocationOption.getLocationMode() == AMapLocationClientOption.AMapLocationMode.Device_Sensors) {
                int gpsStatus = aMapLocationQualityReport.getGPSStatus();
                switch (gpsStatus) {
                    case 0: {
                        float aMapLocationAccuracy = aMapLocation.getAccuracy();
                        int locationType = aMapLocation.getLocationType();
                        LogUtil.d("\u9ad8\u7cbe\u5ea6\u6a21\u5f0f\u6216\u4ec5\u8bbe\u5907\u6a21\u5f0f", "\u536b\u661f\u5b9a\u4f4d\u72b6\u6001--\u6b63\u5e38:");
                        int satellitesNumber = aMapLocationQualityReport.getGPSSatellites();
                        LogUtil.e("GpsListener:", "\u641c\u7d22\u5230=>" + satellitesNumber + "\u9897\u536b\u661f");
                        CommUtil.setSharedPreference(PhoneStatusReceiver.this.context, "satellite", satellitesNumber + "");
                        if (locationType == 0 || locationType > 6) {
                            LogUtil.e("\u9ad8\u7cbe\u5ea6\u6a21\u5f0f\u6216\u4ec5\u8bbe\u5907\u6a21\u5f0f:", "\u5f53\u524dGPS\u83b7\u53d68\u79bb\u7ebf\u5b9a\u4f4d\u7ed3\u679c\u62169\u6700\u540e\u4f4d\u7f6e\u7f13\u5b58\uff0c\u6392\u9664:" + locationType);
                            return false;
                        }
                        if (locationType == 1 && satellitesNumber < 4) {
                            LogUtil.e("\u9ad8\u7cbe\u5ea6\u6a21\u5f0f\u6216\u4ec5\u8bbe\u5907\u6a21\u5f0f:", "\u5f53\u524d\u641c\u7d22\u5230\u536b\u661f\u4fe1\u53f7\u8f83\u5c11\uff0c\u7b5b\u9009\u6389\u6b64\u6761,\u536b\u661f\u6570:" + satellitesNumber);
                            return false;
                        }
                        LogUtil.d("GPS\u7cbe\u5ea6", "\u6b64\u65f6\u7cbe\u5ea6" + aMapLocationAccuracy);
                        if (aMapLocationAccuracy > 150.0f) {
                            LogUtil.d("GPS\u7cbe\u5ea6", "\u5f53\u524d\u7cbe\u5ea6\u5927\u4e8e150\u7c73\u4e0d\u542f\u7528");
                            return false;
                        }
                        return true;
                    }
                    case 1: {
                        LogUtil.e("gpsStatus", "\u536b\u661f\u5b9a\u4f4d\u72b6\u6001--\u624b\u673a\u4e2d\u6ca1\u6709GPS Provider\uff0c\u65e0\u6cd5\u8fdb\u884c\u536b\u661f\u5b9a\u4f4d");
                        return false;
                    }
                    case 2: {
                        LogUtil.e("gpsStatus", "\u536b\u661f\u5b9a\u4f4d\u72b6\u6001--GPS\u5f00\u5173\u5173\u95ed");
                        return false;
                    }
                    case 4: {
                        LogUtil.d("gpsStatus", "\u536b\u661f\u5b9a\u4f4d\u72b6\u6001--\u6ca1\u6709GPS\u5b9a\u4f4d\u6743\u9650");
                        return false;
                    }
                }
            } else {
                float aMapLocationAccuracy = aMapLocation.getAccuracy();
                LogUtil.i("\u4f4e\u529f\u8017\u6a21\u5f0f", "\u4f4e\u529f\u8017\u6a21\u5f0f\uff0c\u5b9a\u4f4d\u7cbe\u5ea6\uff1a" + aMapLocationAccuracy);
                LogUtil.d("GPS\u7cbe\u5ea6", "\u6b64\u65f6\u7cbe\u5ea6" + aMapLocationAccuracy);
                if (aMapLocationAccuracy > 300.0f) {
                    LogUtil.d("GPS\u7cbe\u5ea6\uff0c\u4f4e\u529f\u8017\u6a21\u5f0f", "\u5f53\u524d\u7cbe\u5ea6\u5927\u4e8e300\u7c73\u4e0d\u542f\u7528");
                    return false;
                }
                return true;
            }
            return false;
        }
    };

    private PhoneStatusReceiver(Context context) {
        this.context = context;
        this.mainHandler = new Handler(context.getMainLooper());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PhoneStatusReceiver getInstance(Context context) {
        if (instance != null) return instance;
        Class<PhoneStatusReceiver> clazz = PhoneStatusReceiver.class;
        synchronized (PhoneStatusReceiver.class) {
            if (instance != null) return instance;
            instance = new PhoneStatusReceiver(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    public void setupReceivers() {
        this.setupPhoneStateReceiver();
        this.setupGPSReceiver();
    }

    public void setupGPSReceiver() {
        if (Build.VERSION.SDK_INT >= 23) {
            this.permissions = new String[]{"android.permission.ACCESS_FINE_LOCATION"};
            if (ContextCompat.checkSelfPermission((Context)this.context, (String)"android.permission.ACCESS_FINE_LOCATION") == 0) {
                this.startLocation();
            } else {
                this.mainHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        Toast.makeText((Context)PhoneStatusReceiver.this.context, (CharSequence)"\u8bf7\u524d\u5f80\u8bbe\u7f6e\u4e2d\u5f00\u542f\u672c\u5e94\u7528\u7684\u5b9a\u4f4d\u6743\u9650,\u5426\u5219\u90e8\u5206\u529f\u80fd\u5c06\u4e0d\u80fd\u6b63\u5e38\u4f7f\u7528", (int)0).show();
                    }
                });
            }
        } else {
            this.startLocation();
        }
    }

    void stopLocation() {
        if (null != this.mLocationClient) {
            this.mLocationClient.stopLocation();
        }
    }

    void startLocation() {
        if (null != this.mLocationClient) {
            return;
        }
        this.mLocationClient = new AMapLocationClient(this.context);
        this.mLocationOption = new AMapLocationClientOption();
        this.mLocationOption.setLocationMode(AMapLocationClientOption.AMapLocationMode.Hight_Accuracy);
        this.mLocationOption.setNeedAddress(true);
        this.mLocationOption.setOnceLocation(false);
        this.mLocationOption.setOnceLocationLatest(false);
        this.mLocationOption.setLocationCacheEnable(false);
        this.mLocationOption.setWifiScan(true);
        this.mLocationOption.setMockEnable(false);
        this.mLocationOption.setInterval(Long.parseLong(this.context.getResources().getString(R.string.gpsUpdatecycle)));
        this.mLocationOption.setSensorEnable(true);
        this.mLocationOption.setGpsFirst(false);
        this.mLocationClient.setLocationOption(this.mLocationOption);
        this.mLocationClient.setLocationListener(this.locationListener);
        this.mLocationClient.startLocation();
        this.mLocationClient.startAssistantLocation();
    }

    private void setupPhoneStateReceiver() {
        TelephonyManager tm = (TelephonyManager)this.context.getSystemService("phone");
        tm.listen((PhoneStateListener)new AFPhoneStateListener(), 256);
        CommUtil.setSharedPreference(this.context, "signalStrength", "0");
    }

    private int get4DegreeSignalStrength(int dbm) {
        if (dbm > -65) {
            return 4;
        }
        if (dbm > -79) {
            return 3;
        }
        if (dbm > -89) {
            return 2;
        }
        if (dbm > -99) {
            return 1;
        }
        return 0;
    }

    private class AFPhoneStateListener
    extends PhoneStateListener {
        private AFPhoneStateListener() {
        }

        public void onSignalStrengthsChanged(SignalStrength signalStrength) {
            super.onSignalStrengthsChanged(signalStrength);
            TelephonyManager tm = (TelephonyManager)PhoneStatusReceiver.this.context.getSystemService("phone");
            int pt = tm.getPhoneType();
            int dbm = pt == 1 ? signalStrength.getGsmSignalStrength() : (pt == 2 ? signalStrength.getCdmaDbm() : 0);
            CommUtil.setSharedPreference(PhoneStatusReceiver.this.context, "signalStrength", PhoneStatusReceiver.this.get4DegreeSignalStrength(dbm) + "");
        }
    }
}

