/*
 * Decompiled with CFR 0.152.
 */
package com.aofeng.hybrid.activity;

import android.app.Activity;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.Intent;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import android.view.View;
import android.widget.TextView;
import com.aofeng.hybrid.R;
import com.aofeng.hybrid.activity.MainActivity;
import com.aofeng.hybrid.activity.SetActivity;
import com.aofeng.hybrid.android.service.TickService;
import com.aofeng.hybrid.application.AFApplication;
import com.aofeng.hybrid.plugin.H5Param;
import com.aofeng.hybrid.pos.device.Device;
import com.aofeng.hybrid.pos.printer.AfPrinter;
import com.aofeng.hybrid.pos.printer.PrintAgent;
import com.aofeng.hybrid.pos.reader.CardAgent;
import com.aofeng.hybrid.pos.reader.ICardReader;
import com.aofeng.hybrid.pos.reader.ZTNativeReader;
import com.aofeng.hybrid.sync.IProgressNotifier;
import com.aofeng.hybrid.sync.MD5Manager;
import com.aofeng.hybrid.sync.SyncDBAndPagesTask;
import com.aofeng.hybrid.sync.SyncParam;
import com.aofeng.hybrid.util.CommUtil;
import com.aofeng.hybrid.util.LogUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class PreludeActivity
extends Activity
implements IProgressNotifier {
    private static final String TAG = PreludeActivity.class.getCanonicalName();
    private static final String NETWORK_MOBILE = "MOBILE";
    private static final String NETWORK_WIFI = "WIFI";
    ProgressDialog pd;
    TextView hint;
    public static Context context;
    public static boolean getVersionErr;
    public static boolean needUpdate;
    private Handler mhandler = new Handler(){

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    PreludeActivity.this.checkISConnect();
                    break;
                }
                case 2: {
                    PreludeActivity.this.hint.setText((CharSequence)"");
                }
            }
        }
    };

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        context = this;
        this.setContentView(R.layout.guide);
        this.setRequestedOrientation(-1);
        this.pd = new ProgressDialog((Context)this);
        this.pd.setProgressStyle(1);
        this.pd.setCancelable(false);
        this.hint = (TextView)this.findViewById(R.id.tvHint);
        this.findViewById(R.id.tvHint).setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (getVersionErr) {
                    PreludeActivity.this.updateSystem();
                }
            }
        });
        this.findViewById(R.id.tvHint).setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View v) {
                PreludeActivity.this.clicked();
                return false;
            }
        });
        AFApplication.addActivity(this);
    }

    protected void onResume() {
        super.onResume();
        this.hint.setText((CharSequence)"");
        Message message = new Message();
        message.what = 1;
        this.mhandler.sendMessage(message);
    }

    private void toSet() {
        Intent intent = new Intent((Context)this, SetActivity.class);
        Bundle bundle = new Bundle();
        bundle.putString("SCREEN_ORIENTATION", "-1");
        intent.putExtras(bundle);
        this.startActivity(intent);
    }

    private void clicked() {
        if (getVersionErr) {
            this.updateSystem();
        } else {
            this.toSet();
        }
    }

    private void initPos(JSONObject config) throws Exception {
        AFApplication.card = new CardAgent();
        AFApplication.printer = new PrintAgent();
        String[] drp = this.getDRPStr(config);
        if (config.has("pos") && "true".equals(config.getString("pos").toLowerCase()) || config.has("bluetooth") && "true".equals(config.getString("bluetooth").toLowerCase())) {
            AFApplication.card.setCloudUrl(config.getString("cloud_url"));
            ICardReader cr = (ICardReader)Class.forName(drp[1]).getConstructor(new Class[0]).newInstance(new Object[0]);
            AfPrinter ap = (AfPrinter)Class.forName(drp[2]).getConstructor(new Class[0]).newInstance(new Object[0]);
            String socket_url = config.has("socket_url") ? config.getString("socket_url") : "";
            AFApplication.card.setSocketUrl(socket_url);
            AFApplication.card.setReader(cr);
            AFApplication.printer.setPrinter(ap);
        }
        if (config.has("pos") && "true".equals(config.getString("pos").toLowerCase())) {
            AFApplication.device = (Device)Class.forName(drp[0]).getConstructor(new Class[0]).newInstance(new Object[0]);
            AFApplication.device.initDevice((Context)this);
            AFApplication.SN = AFApplication.device.getSN();
        }
        if (config.has("cardMod")) {
            ZTNativeReader.setCardMod(Integer.parseInt(config.getString("cardMod")));
        }
    }

    private String[] getDRPStr(JSONObject config) throws Exception {
        String printer;
        String reader;
        String factory = Build.MANUFACTURER;
        String[] drp = new String[]{"", "", ""};
        if ("Centerm".equals(factory)) {
            drp[0] = "com.aofeng.hybrid.pos.device.CTDevice";
            drp[1] = "com.aofeng.hybrid.pos.reader.CTChangAnReader";
            drp[2] = "com.aofeng.hybrid.pos.printer.CTPrinter";
        } else if ("LANDI".equals(factory)) {
            drp[0] = "com.aofeng.hybrid.pos.device.LDDevice";
            drp[1] = "com.aofeng.hybrid.pos.reader.LDChangAnReader";
            drp[2] = "com.aofeng.hybrid.pos.printer.LDPrinter";
        }
        String device = config.getString("device");
        if (!"".equals(device)) {
            drp[0] = device;
        }
        if (!"".equals(reader = config.getString("reader"))) {
            drp[1] = reader;
        }
        if (!"".equals(printer = config.getString("printer"))) {
            drp[2] = printer;
        }
        return drp;
    }

    private void updateSystem() {
        String APP_ID = this.getApplicationContext().getPackageName();
        String strDt = CommUtil.getPreference((Context)this, APP_ID, SyncDBAndPagesTask.UPDATE_MOST_RECENT_TIME);
        SyncDBAndPagesTask task = new SyncDBAndPagesTask((Context)this, this);
        try {
            JSONObject config = CommUtil.getHybridContext((Context)this);
            this.initPos(config);
            this.initMd5(config);
            if ("true".equals(config.getString("startService").toLowerCase())) {
                this.startService();
            }
            String WWW_BASE = config.has("sync_url") ? config.getString("sync_url") : config.getString("cc_base_url");
            String BASE_URL = WWW_BASE + "/rs";
            String REMOTE_WWW_PREFIX = config.getString("REMOTE_WWW_PREFIX");
            String LOCAL_PATH_PREFIX = this.getFilesDir().getAbsolutePath() + File.separator;
            String REMOTE_BZ_PREFIX = config.getString("REMOTE_BZ_PREFIX");
            String UPDATE_SERVICE_URL = BASE_URL + "/dir/version";
            String ZIP_WWW_PREFIX = null;
            try {
                ZIP_WWW_PREFIX = config.getString("ZIP_WWW_PREFIX");
            }
            catch (Exception exception) {
                // empty catch block
            }
            String entities = config.has("entities") ? config.getString("entities") : "";
            SyncParam sp = new SyncParam(APP_ID, BASE_URL + "/db/meta2/", entities, BASE_URL + "/dir?path=", REMOTE_WWW_PREFIX, LOCAL_PATH_PREFIX, REMOTE_BZ_PREFIX, BASE_URL + "/dir/", UPDATE_SERVICE_URL, strDt, WWW_BASE, ZIP_WWW_PREFIX);
            Object[] params = new SyncParam[]{sp};
            task.execute(params);
        }
        catch (Exception var14) {
            throw new RuntimeException(var14);
        }
    }

    private void initMd5(JSONObject config) {
        MD5Manager md5 = MD5Manager.getInstance();
        md5.config = config;
        md5.loadMd5();
    }

    @Override
    public void notifyProgress(int progress) {
        this.pd.setProgress(progress);
    }

    @Override
    public void notifyDone(boolean done) {
        Log.d((String)TAG, (String)("\u7cfb\u7edf\u66f4\u65b0" + (done ? "\u6210\u529f" : "\u5931\u8d25")));
        String APP_ID = this.getApplicationContext().getPackageName();
        String strDt = CommUtil.getPreference((Context)this, APP_ID, SyncDBAndPagesTask.UPDATE_MOST_RECENT_TIME);
        if (getVersionErr) {
            this.hint.setText((CharSequence)"\u83b7\u53d6\u540e\u53f0\u7248\u672c\u4fe1\u606f\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u7f51\u7edc\u6b63\u5e38\u540e\u70b9\u51fb\u6587\u5b57\u91cd\u65b0\u83b7\u53d6\u3002");
            return;
        }
        if (!done) {
            if (needUpdate) {
                this.hint.setText((CharSequence)"\u7cfb\u7edf\u66f4\u65b0\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u7f51\u7edc\u662f\u5426\u6b63\u5e38\u3002");
            } else {
                this.hint.setText((CharSequence)"\u7cfb\u7edf\u7248\u672c\u5df2\u662f\u6700\u65b0\uff0c\u65e0\u9700\u66f4\u65b0\u3002");
            }
        }
        if (strDt != null) {
            Intent intent = new Intent((Context)this, MainActivity.class);
            Bundle bundle = new Bundle();
            try {
                JSONObject config = CommUtil.getHybridContext((Context)this);
                String ProjectNativeMethod = config.getString("ProjectNativeMethod");
                bundle.putSerializable("param", (Serializable)new H5Param("file://" + this.getFilesDir().getAbsolutePath() + "/www/index.html", ProjectNativeMethod));
                bundle.putString("SCREEN_ORIENTATION", config.getString("SCREEN_ORIENTATION"));
                bundle.putString("full_screen", config.has("full_screen") ? config.getString("full_screen") : "false");
                intent.putExtras(bundle);
                this.startActivity(intent);
            }
            catch (JSONException var8) {
                throw new RuntimeException(var8);
            }
        }
    }

    public void startService() {
        LogUtil.e("\u5e94\u7528", "\u542f\u52a8\u80cc\u666f\u670d\u52a1");
        Intent intent = new Intent((Context)this, TickService.class);
        if (Build.VERSION.SDK_INT >= 26) {
            this.startForegroundService(intent);
        } else {
            this.startService(intent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean loadContextByAssets(Context context) {
        BufferedReader reader = null;
        try {
            String mLine;
            JSONObject jo = CommUtil.getHybridContext(context);
            reader = new BufferedReader(new InputStreamReader(context.getAssets().open("globals.txt")));
            StringBuilder str = new StringBuilder();
            while ((mLine = reader.readLine()) != null) {
                str.append(mLine);
            }
            if ("".equals(str.toString())) {
                boolean bl = false;
                return bl;
            }
            JSONObject json = new JSONObject(str.toString());
            Iterator keys = json.keys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                Object value = json.get(key);
                if (jo.has(key)) continue;
                if (value instanceof String) {
                    CommUtil.setSharedPreference(context, key, (String)value);
                    continue;
                }
                if (!(value instanceof JSONArray)) continue;
                str = new StringBuilder(PreludeActivity.toString((JSONArray)value));
                CommUtil.setSharedPreference(context, key, str.toString());
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            Log.i((String)"loadContextByAssets", (String)"Assets not global");
            boolean bl = false;
            return bl;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean loadContext(Context context) {
        BufferedReader reader = null;
        String globalPath = context.getFilesDir().toString() + "/globals.txt";
        File global = new File(globalPath);
        try {
            String mLine;
            JSONObject jo = CommUtil.getHybridContext(context);
            reader = new BufferedReader(new InputStreamReader(new FileInputStream(global)));
            StringBuilder str = new StringBuilder();
            while ((mLine = reader.readLine()) != null) {
                str.append(mLine);
            }
            if ("".equals(str.toString())) {
                global.delete();
                boolean bl = false;
                return bl;
            }
            JSONObject json = new JSONObject(str.toString());
            Iterator keys = json.keys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                Object value = json.get(key);
                if (value instanceof String) {
                    CommUtil.setSharedPreference(context, key, (String)value);
                    continue;
                }
                if (!(value instanceof JSONArray)) continue;
                str = new StringBuilder(PreludeActivity.toString((JSONArray)value));
                CommUtil.setSharedPreference(context, key, str.toString());
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static String toString(JSONArray array) {
        String result = "";
        for (int i = 0; i < array.length(); ++i) {
            if (!result.equals("")) {
                result = result + ",";
            }
            try {
                String s = array.getString(i);
                result = result + s.toString();
                continue;
            }
            catch (JSONException e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    @Override
    public void prelude() {
        this.pd.setMessage((CharSequence)"\u68c0\u67e5\u7cfb\u7edf\u66f4\u65b0......");
        this.pd.setProgress(0);
        this.pd.show();
    }

    public static NetworkInfo getActiveNetwork(Context context) {
        if (context == null) {
            return null;
        }
        ConnectivityManager mConnMgr = (ConnectivityManager)context.getSystemService("connectivity");
        if (mConnMgr == null) {
            return null;
        }
        return mConnMgr.getActiveNetworkInfo();
    }

    public static boolean isConnectNet() {
        NetworkInfo networkInfo = PreludeActivity.getActiveNetwork(context);
        if (networkInfo == null) {
            Log.d((String)TAG, (String)"isConnectNet: \u65e0\u53ef\u7528\u7f51\u7edc\u8fde\u63a5\uff0c\u8bf7\u68c0\u67e5\u7f51\u7edc\u8bbe\u7f6e");
            return false;
        }
        if (!networkInfo.isAvailable()) {
            Log.d((String)TAG, (String)"isConnectNet: \u65e0\u53ef\u7528\u7f51\u7edc\u8fde\u63a5\uff0c\u8bf7\u68c0\u67e5\u7f51\u7edc\u8bbe\u7f6e");
            return false;
        }
        String networkType = networkInfo.getTypeName();
        if (NETWORK_WIFI.equalsIgnoreCase(networkType)) {
            Log.d((String)TAG, (String)"isConnectNet: \u5df2\u8fde\u63a5\u5230wifi\u7f51\u7edc+ networkInfo.getExtraInfo(");
        } else if (NETWORK_MOBILE.equalsIgnoreCase(networkType)) {
            Log.d((String)TAG, (String)"isConnectNet: \u60a8\u5f53\u524d\u4f7f\u7528\u7684\u662f\u79fb\u52a8\u7f51\u7edc");
        }
        return true;
    }

    private void checkISConnect() {
        this.hint.setText((CharSequence)"\u6b63\u5728\u7b49\u5f85\u7f51\u7edc\u8fde\u63a5\u5b8c\u6210\uff0c\u5982\u679c\u957f\u65f6\u95f4\u672a\u8fde\u63a5\uff0c\u8bf7\u68c0\u67e5\u7f51\u7edc\u662f\u5426\u6b63\u5e38");
        Thread th = new Thread(){

            @Override
            public void run() {
                while (!PreludeActivity.isConnectNet()) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        Log.e((String)"SetActivity", (String)"run: \u51fa\u73b0\u9519\u8bef", (Throwable)e);
                    }
                }
                Message message = new Message();
                message.what = 2;
                PreludeActivity.this.mhandler.sendMessage(message);
                PreludeActivity.this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        if (CommUtil.hasConfig(context) && PreludeActivity.this.loadContext(context) && !"".equals(CommUtil.getSharedPreference(context, "sync_url"))) {
                            PreludeActivity.this.updateSystem();
                        } else {
                            PreludeActivity.this.toSet();
                        }
                    }
                });
            }
        };
        th.start();
    }

    private boolean hasAssertConfig(Context context) {
        String path = context.getAssets().toString() + "/globals.txt";
        File config = new File(path);
        return config.exists();
    }

    protected void onDestroy() {
        super.onDestroy();
        AFApplication.removeActivity(this);
        System.out.println("PreludeActivity:\u8868\u793a Activity \u5373\u5c06\u88ab\u9500\u6bc1");
    }

    static {
        getVersionErr = false;
        needUpdate = false;
    }
}

