/*
 * Decompiled with CFR 0.152.
 */
package com.aofeng.hybrid.util.amap;

import android.app.Notification;
import android.app.Service;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.os.Environment;
import android.text.TextUtils;
import com.amap.api.location.AMapLocation;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Locale;

public class AmapCurrencyUtil {
    private static SimpleDateFormat sdf = null;
    private static String CLOSE_BRODECAST_INTENT_ACTION_NAME = "com.amap.locationservicedemo.CloseService";

    public static synchronized String getLocationStr(AMapLocation location) {
        if (null == location) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        if (location.getErrorCode() == 0) {
            sb.append("\u5b9a\u4f4d\u6210\u529f\n");
            sb.append("\u5b9a\u4f4d\u7c7b\u578b: " + location.getLocationType() + "\n");
            sb.append("\u7ecf    \u5ea6    : " + location.getLongitude() + "\n");
            sb.append("\u7eac    \u5ea6    : " + location.getLatitude() + "\n");
            sb.append("\u7cbe    \u5ea6    : " + location.getAccuracy() + "\u7c73\n");
            sb.append("\u63d0\u4f9b\u8005    : " + location.getProvider() + "\n");
            sb.append("\u6d77    \u62d4    : " + location.getAltitude() + "\u7c73\n");
            sb.append("\u901f    \u5ea6    : " + location.getSpeed() + "\u7c73/\u79d2\n");
            sb.append("\u89d2    \u5ea6    : " + location.getBearing() + "\n");
            if (location.getProvider().equalsIgnoreCase("gps")) {
                sb.append("\u661f    \u6570    : " + location.getSatellites() + "\n");
            }
            sb.append("\u56fd    \u5bb6    : " + location.getCountry() + "\n");
            sb.append("\u7701            : " + location.getProvince() + "\n");
            sb.append("\u5e02            : " + location.getCity() + "\n");
            sb.append("\u57ce\u5e02\u7f16\u7801 : " + location.getCityCode() + "\n");
            sb.append("\u533a            : " + location.getDistrict() + "\n");
            sb.append("\u533a\u57df \u7801   : " + location.getAdCode() + "\n");
            sb.append("\u5730    \u5740    : " + location.getAddress() + "\n");
            sb.append("\u5174\u8da3\u70b9    : " + location.getPoiName() + "\n");
            sb.append("\u5b9a\u4f4d\u65f6\u95f4: " + AmapCurrencyUtil.formatUTC(location.getTime(), "yyyy-MM-dd HH:mm:ss") + "\n");
        } else {
            sb.append("\u5b9a\u4f4d\u5931\u8d25\n");
            sb.append("\u9519\u8bef\u7801:" + location.getErrorCode() + "\n");
            sb.append("\u9519\u8bef\u4fe1\u606f:" + location.getErrorInfo() + "\n");
            sb.append("\u9519\u8bef\u63cf\u8ff0:" + location.getLocationDetail() + "\n");
        }
        sb.append("\u56de\u8c03\u65f6\u95f4: " + AmapCurrencyUtil.formatUTC(System.currentTimeMillis(), "yyyy-MM-dd HH:mm:ss") + "\n");
        return sb.toString();
    }

    public static synchronized String formatUTC(long l, String strPattern) {
        if (TextUtils.isEmpty((CharSequence)strPattern)) {
            strPattern = "yyyy-MM-dd HH:mm:ss";
        }
        if (sdf == null) {
            try {
                sdf = new SimpleDateFormat(strPattern, Locale.CHINA);
            }
            catch (Throwable throwable) {}
        } else {
            sdf.applyPattern(strPattern);
        }
        return sdf == null ? "NULL" : sdf.format(l);
    }

    public static Intent getExplicitIntent(Context context, Intent implicitIntent) {
        if (context.getApplicationInfo().targetSdkVersion < 21) {
            return implicitIntent;
        }
        PackageManager pm = context.getPackageManager();
        List resolveInfo = pm.queryIntentServices(implicitIntent, 0);
        if (resolveInfo == null || resolveInfo.size() != 1) {
            return null;
        }
        ResolveInfo serviceInfo = (ResolveInfo)resolveInfo.get(0);
        String packageName = serviceInfo.serviceInfo.packageName;
        String className = serviceInfo.serviceInfo.name;
        ComponentName component = new ComponentName(packageName, className);
        Intent explicitIntent = new Intent(implicitIntent);
        explicitIntent.setComponent(component);
        return explicitIntent;
    }

    public static void saveFile(String toSaveString, String fileName, boolean append) {
        try {
            String sdCardRoot = Environment.getExternalStorageDirectory().getAbsolutePath();
            File saveFile = new File(sdCardRoot + "/" + fileName);
            if (!saveFile.exists()) {
                File dir = new File(saveFile.getParent());
                dir.mkdirs();
                saveFile.createNewFile();
            }
            FileOutputStream outStream = new FileOutputStream(saveFile, append);
            outStream.write(toSaveString.getBytes());
            outStream.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static Notification buildNotification(Context context) {
        Notification.Builder builder = new Notification.Builder(context);
        builder.setContentText((CharSequence)"service");
        return builder.getNotification();
    }

    public static void startWifi(Context context) {
        WifiManager wm = (WifiManager)context.getSystemService("wifi");
        wm.setWifiEnabled(true);
        wm.reconnect();
    }

    public static boolean isWifiEnabled(Context context) {
        WifiManager wm = (WifiManager)context.getSystemService("wifi");
        return wm.isWifiEnabled();
    }

    public static String getManufacture(Context context) {
        return Build.MANUFACTURER;
    }

    public static Intent getCloseBrodecastIntent() {
        return new Intent(CLOSE_BRODECAST_INTENT_ACTION_NAME);
    }

    public static IntentFilter getCloseServiceFilter() {
        return new IntentFilter(CLOSE_BRODECAST_INTENT_ACTION_NAME);
    }

    public static String sHA1(Context context) {
        try {
            PackageInfo info = context.getPackageManager().getPackageInfo(context.getPackageName(), 64);
            byte[] cert = info.signatures[0].toByteArray();
            MessageDigest md = MessageDigest.getInstance("SHA1");
            byte[] publicKey = md.digest(cert);
            StringBuffer hexString = new StringBuffer();
            for (int i = 0; i < publicKey.length; ++i) {
                String appendString = Integer.toHexString(0xFF & publicKey[i]).toUpperCase(Locale.US);
                if (appendString.length() == 1) {
                    hexString.append("0");
                }
                hexString.append(appendString);
                hexString.append(":");
            }
            String result = hexString.toString();
            return result.substring(0, result.length() - 1);
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static class CloseServiceReceiver
    extends BroadcastReceiver {
        Service mService;

        public CloseServiceReceiver(Service service) {
            this.mService = service;
        }

        public void onReceive(Context context, Intent intent) {
            if (this.mService == null) {
                return;
            }
            this.mService.onDestroy();
        }
    }
}

