/*
 * Decompiled with CFR 0.152.
 */
package com.aofeng.hybrid.util;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothServerSocket;
import android.bluetooth.BluetoothSocket;
import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.UUID;

public class BluetoothService {
    private static final String TAG = "BluetoothService";
    private static final boolean DEBUG = true;
    private static final String NAME = "ZJPrinter";
    private static final UUID MY_UUID = UUID.fromString("00001101-0000-1000-8000-00805F9B34FB");
    private BluetoothAdapter mAdapter = BluetoothAdapter.getDefaultAdapter();
    private Handler mHandler;
    private AcceptThread mAcceptThread;
    private ConnectThread mConnectThread;
    private ConnectedThread mConnectedThread;
    private int mState = 0;
    private Context context;
    public static final int STATE_NONE = 0;
    public static final int STATE_LISTEN = 1;
    public static final int STATE_CONNECTING = 2;
    public static final int STATE_CONNECTED = 3;
    public static String ErrorMessage = "No_Error_Message";

    public BluetoothService(Context context, Handler handler) {
        this.mHandler = handler;
        this.context = context;
    }

    private synchronized void setState(int state) {
        Log.d((String)TAG, (String)("setState() " + this.mState + " -> " + state));
        this.mState = state;
        this.mHandler.obtainMessage(1, state, -1).sendToTarget();
    }

    public synchronized int getState() {
        return this.mState;
    }

    public synchronized BluetoothAdapter getAdapter() {
        return this.mAdapter;
    }

    public synchronized void start() {
        Log.d((String)TAG, (String)"start");
        if (this.mConnectThread != null) {
            this.mConnectThread.cancel();
            this.mConnectThread = null;
        }
        if (this.mConnectedThread != null) {
            this.mConnectedThread.cancel();
            this.mConnectedThread = null;
        }
        if (this.mAcceptThread == null) {
            this.mAcceptThread = new AcceptThread();
            this.mAcceptThread.start();
        }
        this.setState(1);
    }

    public synchronized void connect(BluetoothDevice device) {
        Log.d((String)TAG, (String)("connect to: " + device));
        if (this.mState == 2 && this.mConnectThread != null) {
            this.mConnectThread.cancel();
            this.mConnectThread = null;
        }
        if (this.mConnectedThread != null) {
            this.mConnectedThread.cancel();
            this.mConnectedThread = null;
        }
        this.mConnectThread = new ConnectThread(device);
        this.mConnectThread.start();
        this.setState(2);
    }

    public synchronized void connected(BluetoothSocket socket, BluetoothDevice device) {
        Log.d((String)TAG, (String)"connected");
        if (this.mConnectThread != null) {
            this.mConnectThread.cancel();
            this.mConnectThread = null;
        }
        if (this.mConnectedThread != null) {
            this.mConnectedThread.cancel();
            this.mConnectedThread = null;
        }
        if (this.mAcceptThread != null) {
            this.mAcceptThread.cancel();
            this.mAcceptThread = null;
        }
        this.mConnectedThread = new ConnectedThread(socket);
        this.mConnectedThread.start();
        Message msg = this.mHandler.obtainMessage(4);
        Bundle bundle = new Bundle();
        bundle.putString("device_name", device.getName());
        msg.setData(bundle);
        this.mHandler.sendMessage(msg);
        this.setState(3);
    }

    public synchronized void stop() {
        Log.d((String)TAG, (String)"stop");
        this.setState(0);
        if (this.mConnectThread != null) {
            this.mConnectThread.cancel();
            this.mConnectThread = null;
        }
        if (this.mConnectedThread != null) {
            this.mConnectedThread.cancel();
            this.mConnectedThread = null;
        }
        if (this.mAcceptThread != null) {
            this.mAcceptThread.cancel();
            this.mAcceptThread = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(byte[] out) {
        ConnectedThread r;
        BluetoothService bluetoothService = this;
        synchronized (bluetoothService) {
            if (this.mState != 3) {
                return;
            }
            r = this.mConnectedThread;
        }
        r.write(out);
    }

    private void connectionFailed() {
        this.setState(1);
        Message msg = this.mHandler.obtainMessage(5);
        Bundle bundle = new Bundle();
        bundle.putString("toast", "Unable to connect device");
        msg.setData(bundle);
        this.mHandler.sendMessage(msg);
    }

    private void connectionLost() {
        Message msg = this.mHandler.obtainMessage(5);
        Bundle bundle = new Bundle();
        bundle.putString("toast", "Device connection was lost");
        msg.setData(bundle);
        this.mHandler.sendMessage(msg);
    }

    private class ConnectedThread
    extends Thread {
        private final BluetoothSocket mmSocket;
        private final InputStream mmInStream;
        private final OutputStream mmOutStream;

        public ConnectedThread(BluetoothSocket socket) {
            Log.d((String)BluetoothService.TAG, (String)"create ConnectedThread");
            this.mmSocket = socket;
            InputStream tmpIn = null;
            OutputStream tmpOut = null;
            try {
                tmpIn = socket.getInputStream();
                tmpOut = socket.getOutputStream();
            }
            catch (IOException e) {
                Log.e((String)BluetoothService.TAG, (String)"temp sockets not created", (Throwable)e);
            }
            this.mmInStream = tmpIn;
            this.mmOutStream = tmpOut;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            Log.i((String)BluetoothService.TAG, (String)"BEGIN mConnectedThread");
            try {
                byte[] buffer;
                int bytes;
                while ((bytes = this.mmInStream.read(buffer = new byte[256])) > 0) {
                    BluetoothService.this.mHandler.obtainMessage(2, bytes, -1, (Object)buffer).sendToTarget();
                }
                Log.e((String)BluetoothService.TAG, (String)"disconnected");
                BluetoothService.this.connectionLost();
                if (BluetoothService.this.mState == 0) return;
                Log.e((String)BluetoothService.TAG, (String)"disconnected");
                return;
            }
            catch (IOException e) {
                Log.e((String)BluetoothService.TAG, (String)"disconnected", (Throwable)e);
                BluetoothService.this.connectionLost();
                if (BluetoothService.this.mState == 0) return;
            }
        }

        public void write(byte[] buffer) {
            try {
                this.mmOutStream.write(buffer);
                this.mmOutStream.flush();
                Log.i((String)"BTPWRITE", (String)new String(buffer, "GBK"));
                BluetoothService.this.mHandler.obtainMessage(3, -1, -1, (Object)buffer).sendToTarget();
            }
            catch (IOException e) {
                Log.e((String)BluetoothService.TAG, (String)"Exception during write", (Throwable)e);
                BluetoothService.this.setState(0);
            }
        }

        public void cancel() {
            try {
                this.mmSocket.close();
            }
            catch (IOException e) {
                Log.e((String)BluetoothService.TAG, (String)"close() of connect socket failed", (Throwable)e);
            }
        }
    }

    private class ConnectThread
    extends Thread {
        private final BluetoothSocket mmSocket;
        private final BluetoothDevice mmDevice;

        public ConnectThread(BluetoothDevice device) {
            this.mmDevice = device;
            BluetoothSocket tmp = null;
            try {
                tmp = device.createRfcommSocketToServiceRecord(MY_UUID);
            }
            catch (IOException e) {
                Log.e((String)BluetoothService.TAG, (String)"create() failed", (Throwable)e);
            }
            this.mmSocket = tmp;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Log.i((String)BluetoothService.TAG, (String)"BEGIN mConnectThread");
            this.setName("ConnectThread");
            BluetoothService.this.mAdapter.cancelDiscovery();
            try {
                this.mmSocket.connect();
            }
            catch (IOException e) {
                BluetoothService.this.connectionFailed();
                try {
                    this.mmSocket.close();
                }
                catch (IOException e2) {
                    Log.e((String)BluetoothService.TAG, (String)"unable to close() socket during connection failure", (Throwable)e2);
                }
                return;
            }
            BluetoothService bluetoothService = BluetoothService.this;
            synchronized (bluetoothService) {
                BluetoothService.this.mConnectThread = null;
            }
            BluetoothService.this.connected(this.mmSocket, this.mmDevice);
        }

        public void cancel() {
            try {
                this.mmSocket.close();
            }
            catch (IOException e) {
                Log.e((String)BluetoothService.TAG, (String)"close() of connect socket failed", (Throwable)e);
            }
        }
    }

    private class AcceptThread
    extends Thread {
        private final BluetoothServerSocket mmServerSocket;

        public AcceptThread() {
            BluetoothServerSocket tmp = null;
            try {
                tmp = BluetoothService.this.mAdapter.listenUsingRfcommWithServiceRecord(BluetoothService.NAME, MY_UUID);
            }
            catch (IOException e) {
                Log.e((String)BluetoothService.TAG, (String)"listen() failed", (Throwable)e);
            }
            this.mmServerSocket = tmp;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Log.d((String)BluetoothService.TAG, (String)("BEGIN mAcceptThread" + this));
            this.setName("AcceptThread");
            BluetoothSocket socket = null;
            while (BluetoothService.this.mState != 3) {
                try {
                    socket = this.mmServerSocket.accept();
                }
                catch (IOException e) {
                    Log.e((String)BluetoothService.TAG, (String)"accept() failed", (Throwable)e);
                    break;
                }
                if (socket == null) continue;
                BluetoothService bluetoothService = BluetoothService.this;
                synchronized (bluetoothService) {
                    switch (BluetoothService.this.mState) {
                        case 1: 
                        case 2: {
                            BluetoothService.this.connected(socket, socket.getRemoteDevice());
                            break;
                        }
                        case 0: 
                        case 3: {
                            try {
                                socket.close();
                                break;
                            }
                            catch (IOException e) {
                                Log.e((String)BluetoothService.TAG, (String)"Could not close unwanted socket", (Throwable)e);
                            }
                        }
                    }
                }
            }
            Log.i((String)BluetoothService.TAG, (String)"END mAcceptThread");
        }

        public void cancel() {
            Log.d((String)BluetoothService.TAG, (String)("cancel " + this));
            try {
                this.mmServerSocket.close();
            }
            catch (IOException e) {
                Log.e((String)BluetoothService.TAG, (String)"close() of server failed", (Throwable)e);
            }
        }
    }
}

