/*
 * Decompiled with CFR 0.152.
 */
package com.aofeng.hybrid.service;

import android.content.Context;
import android.util.Log;
import com.aofeng.hybrid.android.task.HintPlugin;
import com.aofeng.hybrid.ext.Logic;
import com.aofeng.hybrid.service.EntityService;
import com.aofeng.hybrid.service.GenericService;
import com.aofeng.hybrid.service.LogicMapper;
import com.aofeng.hybrid.service.PathService;
import com.aofeng.hybrid.service.RestService;
import com.aofeng.hybrid.service.SqlService;
import com.aofeng.hybrid.util.CommUtil;
import com.aofeng.hybrid.util.ExpLog;
import com.aofeng.hybrid.util.ExpressionHelper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogicService
extends GenericService {
    private static final Logger log = LoggerFactory.getLogger(LogicService.class);

    public LogicService(Context context) {
        super(context);
        try {
            this.services.put("log", new ExpLog());
            EntityService entityService = new EntityService(context);
            SqlService sqlService = new SqlService(context);
            this.services.put("entity", entityService);
            this.services.put("sql", sqlService);
            this.services.put("logic", this);
            if (!this.services.containsKey("hint")) {
                this.services.put("hint", new HintPlugin(null));
            }
            RestService restService = new RestService(context);
            this.services.put("rest", restService);
            PathService pathService = new PathService(context);
            this.services.put("path", pathService);
            this.services.put("context", CommUtil.getHybridContext(context));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.injectOthers(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void injectOthers(Context context) {
        BufferedReader reader = null;
        try {
            String mLine;
            reader = new BufferedReader(new InputStreamReader(context.getAssets().open("plugin.txt")));
            while ((mLine = reader.readLine()) != null) {
                String[] parts = mLine.split(",");
                Logic lgc = (Logic)Class.forName(parts[1].trim()).newInstance();
                lgc.setContext(context);
                this.services.put(parts[0].trim(), lgc);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public JSONObject action(JSONObject json) {
        JSONObject result = new JSONObject();
        try {
            result.put("code", 500);
            result.put("data", (Object)"\u4e0d\u53ef\u5904\u7406\u5f02\u5e38\u3002");
            Object obj = this.run(json.getString("alias"), json.getJSONObject("data"));
            result.put("code", 200);
            result.put("data", obj);
            return result;
        }
        catch (Exception e) {
            try {
                result.put("code", 500);
                result.put("data", (Object)e.getMessage());
                return result;
            }
            catch (Exception ex) {
                return result;
            }
        }
    }

    public Object run(String alias, JSONObject json) throws Exception {
        String path = LogicMapper.getSql(this.context, alias);
        String text = CommUtil.readFile(CommUtil.getFilePath(this.context) + "logics/" + path);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("data", json);
        for (String key : this.services.keySet()) {
            params.put(key, this.services.get(key));
        }
        Object result = ExpressionHelper.run(text, params);
        if (result == null) {
            Log.d((String)"\u6267\u884c\u8868\u8fbe\u5f0f\u540e\u8fd4\u56de", (String)"null");
        } else {
            Log.d((String)"\u6267\u884c\u8868\u8fbe\u5f0f\u540e\u8fd4\u56de", (String)(result + ""));
        }
        return result;
    }
}

