/*
 * Decompiled with CFR 0.152.
 */
package com.aofeng.hybrid.pos.reader;

import android.annotation.SuppressLint;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.content.Context;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import com.aofeng.hybrid.application.AFApplication;
import com.aofeng.hybrid.pos.device.BlueDevice;
import com.aofeng.hybrid.pos.reader.CardAgent;
import com.aofeng.hybrid.pos.reader.Chip;
import com.aofeng.hybrid.pos.reader.ICardReader;
import com.aofeng.hybrid.util.HexDump;
import com.example.reader.BluetoothUtils;
import com.example.reader.ReadCard;
import java.util.List;

public class PrmtReader
implements ICardReader {
    private static final String TAG = PrmtReader.class.getName();
    @SuppressLint(value={"StaticFieldLeak"})
    private static BluetoothUtils mBluetoothUtils;
    public static BluetoothDevice device;
    public static BlueDevice blueDevice;
    private static boolean isScan;
    @SuppressLint(value={"HandlerLeak"})
    private final Handler mHandler = new Handler(){

        public void handleMessage(Message msg) {
            if (3 == msg.what) {
                List bluetoothDeviceArrayList = mBluetoothUtils.mLeDevices;
                if (mBluetoothUtils.mBluetoothGatt == null) {
                    for (BluetoothDevice devices : bluetoothDeviceArrayList) {
                        Log.d((String)"PrmtReader", (String)("name = " + devices.getName()));
                        if (devices.getName() == null || device != null || !devices.getName().startsWith("SPP_") && !devices.getName().startsWith("NEW_") && !devices.getName().startsWith("RMT_")) continue;
                        int ret = mBluetoothUtils.Connect(devices);
                        Log.d((String)"PrmtReader", (String)("ret = " + ret));
                        if (ret == 1) {
                            device = devices;
                            blueDevice = new BlueDevice(device.getName(), device.getAddress(), device);
                            Log.d((String)"PrmtReader", (String)"\u8fde\u63a5\u84dd\u7259\u6210\u529f");
                            Log.d((String)"PrmtReader", (String)("name = " + devices.getName()));
                            AFApplication.device = blueDevice;
                            break;
                        }
                        device = null;
                    }
                    mBluetoothUtils.scanBleDevice(false);
                    isScan = false;
                }
            }
        }
    };

    public void ScanBluetooth(Context mContext) {
        if (isScan) {
            return;
        }
        isScan = true;
        BluetoothAdapter bluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
        if (!bluetoothAdapter.isEnabled()) {
            bluetoothAdapter.enable();
        }
        while (!bluetoothAdapter.isEnabled()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                Log.e((String)"PrmtReader", (String)"ScanBluetooth : ", (Throwable)e);
            }
        }
        mBluetoothUtils = new BluetoothUtils();
        mBluetoothUtils.initialize(mContext, this.mHandler);
        mBluetoothUtils.scanBleDevice(true);
    }

    @Override
    public boolean openDevice(Chip chip) {
        BluetoothAdapter bluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
        if (bluetoothAdapter.isEnabled()) {
            bluetoothAdapter.enable();
        }
        while (!bluetoothAdapter.isEnabled()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                Log.e((String)"PrmtReader", (String)"openDevice: ", (Throwable)e);
            }
        }
        if (chip.chipName == 7) {
            return mBluetoothUtils.jcpupower_on() == 0;
        }
        return true;
    }

    @Override
    public boolean closeDevice(Chip chip) {
        if (chip.chipName == 7) {
            mBluetoothUtils.jcpupower_off();
        }
        return true;
    }

    @Override
    public boolean hasCard() {
        return true;
    }

    @Override
    public boolean read(Chip chip) {
        CardAgent.log("read: begin");
        if (chip.chipName == 1) {
            return this.read4442(2, 0, 256, chip.buf);
        }
        if (chip.chipName == 0) {
            if (chip.secret != null) {
                for (int i = 0; i < chip.secret.length(); i += 4) {
                    String pwd = chip.secret.substring(i, i + 4);
                    if (!this.verify102Pwd(pwd)) continue;
                    chip.secret = pwd;
                    return this.read102(178, chip.buf, null);
                }
                return false;
            }
            return this.read102(178, chip.buf, null);
        }
        if (chip.chipName == 7) {
            return this.resetCPUCard() != null;
        }
        if (chip.chipName == 6) {
            if (chip.secret != null) {
                CardAgent.log("read zone2 begin: begin");
                String[] kmms = chip.secret.split("\\|");
                String area2WritePwd = this.get1608AreaReadPwd(2, kmms);
                if (area2WritePwd != null) {
                    for (int i = 0; i < area2WritePwd.length(); i += 6) {
                        String pwd = area2WritePwd.substring(i, i + 6);
                        if (!this.verify1608Pwd((byte)2, (byte)1, HexDump.hexStringToByteArray(pwd))) continue;
                        return this.read1608(2, 0, chip.buf);
                    }
                }
                return false;
            }
            if (chip.secret_1608 != null) {
                Log.d((String)TAG, (String)"read1608 zone 7 begin");
                String[] kmms = chip.secret_1608.split("\\|");
                String area2WritePwd = this.get1608AreaReadPwd(7, kmms);
                for (int i = 0; i < (area2WritePwd != null ? area2WritePwd.length() : 0); i += 6) {
                    String pwd = area2WritePwd.substring(i, i + 6);
                    if (!this.verify1608Pwd((byte)7, (byte)1, HexDump.hexStringToByteArray(pwd))) continue;
                    return this.read1608(7, 0, chip.buf);
                }
                return false;
            }
            Log.d((String)TAG, (String)"read1608 zone config begin");
            return this.read1608Config(8, 0, 128, chip.buf);
        }
        if (chip.chipName == 11) {
            if (chip.secret == null) {
                return PrmtReader.read153Config(3, 0, 64, chip.buf);
            }
            String[] kmms = chip.secret.split("\\|");
            if (kmms.length == 0) {
                return false;
            }
            String area2WritePwd = this.get1608AreaReadPwd(0, kmms);
            for (int i = 0; i < area2WritePwd.length(); i += 6) {
                String pwd = area2WritePwd.substring(i, i + 6);
                if (!this.verify153Pwd((byte)0, HexDump.hexStringToByteArray(pwd))) continue;
                for (int j = 0; j < 3; ++j) {
                    boolean result = PrmtReader.read153(j, 0, 64, chip.buf);
                    if (result) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public static boolean read153Config(int area, int offset, int len, byte[] buf) {
        try {
            String result = mBluetoothUtils.read(area, 0, offset, len).replace(" ", "");
            byte[] data = HexDump.hexStringToByteArray(result);
            System.arraycopy(data, 0, buf, 192, 64);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static boolean read153(int area, int offset, int len, byte[] buf) {
        byte[] data = null;
        try {
            String result = mBluetoothUtils.read(area, 0, offset, len).replace(" ", "");
            data = HexDump.hexStringToByteArray(result);
            System.arraycopy(data, 0, buf, 64 * area, len);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static boolean write153(int area, int offset, int len, byte[] data) {
        try {
            String result = mBluetoothUtils.write(area, offset, len, HexDump.toHexString(data), 0).replace(" ", "");
            if (!"1".equals(result)) {
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    @Override
    public boolean write(Chip chip, int block, int offset, int len, byte[] buf, byte[] secret) {
        if (chip.chipName == 0) {
            return this.write102(block, offset, len, buf, HexDump.toHexString(secret));
        }
        if (chip.chipName == 1) {
            return this.write4442(2, offset, len, buf, HexDump.toHexString(secret));
        }
        if (chip.chipName == 6) {
            if (this.verify1608Pwd((byte)block, (byte)0, secret)) {
                return this.write1608(block, offset, len, buf);
            }
            return false;
        }
        if (chip.chipName == 11) {
            return PrmtReader.write153(block, offset, len, buf);
        }
        return false;
    }

    public boolean write4442(int block, int offset, int len, byte[] buf, String key) {
        if (this.get4442PwdAttemptCnt() <= 0) {
            return false;
        }
        if (key != null && !key.equals("null") && !this.verify4442Pwd(key)) {
            return false;
        }
        if (len > 12) {
            String result = mBluetoothUtils.write(2, (int)((byte)offset), 12, HexDump.toHexString(buf), 2);
            if (!"1".equals(result)) {
                return false;
            }
            int length = len - 12;
            result = mBluetoothUtils.write(2, (int)((byte)(offset + 12)), length, HexDump.toHexString(buf, 12, length), 2);
            return "1".equals(result);
        }
        if (offset >= 128) {
            offset = (byte)offset;
        }
        String result = mBluetoothUtils.write(2, offset, len, HexDump.toHexString(buf), 2);
        return "1".equals(result);
    }

    public boolean write102(int block, int offset, int len, byte[] buf, String key) {
        if (this.get102PwdAttemptCnt() <= 0) {
            return false;
        }
        if (key != null && !key.equals("null") && !this.verify102Pwd(key)) {
            return false;
        }
        String result = "-1";
        if (offset < 22) {
            for (int i = 0; i < len; i += 8) {
                int length = i + 8 > len ? len - i : 8;
                int off = offset + i;
                result = mBluetoothUtils.write(0, off, length, HexDump.toHexString(buf, i, length), 3);
            }
        } else if (offset > 22 && offset < 92) {
            for (int i = 0; i < len; i += 8) {
                int length = i + 8 > len ? len - i : 8;
                int off = offset + i - 22;
                result = mBluetoothUtils.write(1, off, length, HexDump.toHexString(buf, i, length), 3);
            }
        } else {
            for (int i = 0; i < len; i += 8) {
                int length = i + 8 > len ? len - i : 8;
                int off = offset + i - 22 - 70;
                result = mBluetoothUtils.write(2, off, length, HexDump.toHexString(buf, i, length), 3);
            }
        }
        return "1".equals(result);
    }

    @Override
    public boolean verifyPwd(Chip chip, int block, byte[] secret) {
        if (chip.chipName == 0) {
            for (int i = 0; i < secret.length; i += 2) {
                if (!this.verify102Pwd(HexDump.toHexString(new byte[]{secret[i], secret[i + 1]}))) continue;
                return true;
            }
            return false;
        }
        if (chip.chipName == 1) {
            for (int i = 0; i < secret.length; i += 3) {
                if (!this.verify4442Pwd(HexDump.toHexString(new byte[]{secret[i], secret[i + 1], secret[i + 2]}))) continue;
                return true;
            }
            return false;
        }
        if (chip.chipName == 11) {
            for (int i = 0; i < secret.length; i += 3) {
                if (!this.verify153Pwd((byte)1, new byte[]{secret[i], secret[i + 1], secret[i + 2]})) continue;
                return true;
            }
            return false;
        }
        return chip.chipName != 6;
    }

    @Override
    public boolean changePwd(Chip chip, int block, byte[] oldSecret, byte[] newSecret) {
        if (chip.chipName == 0) {
            return this.change102Pwd(oldSecret, newSecret);
        }
        if (chip.chipName == 1) {
            return this.change4442Pwd(oldSecret, newSecret);
        }
        return true;
    }

    public boolean change102Pwd(byte[] oldKey, byte[] newKey) {
        if (this.get102PwdAttemptCnt() <= 0) {
            return false;
        }
        if (oldKey != null && !this.verify102Pwd(HexDump.toHexString(oldKey))) {
            return false;
        }
        String result = mBluetoothUtils.write(0, 10, 2, HexDump.toHexString(newKey), 3);
        return "1".equals(result);
    }

    public boolean change4442Pwd(byte[] oldKey, byte[] newKey) {
        if (this.get4442PwdAttemptCnt() <= 0) {
            return false;
        }
        if (oldKey != null && !this.verify4442Pwd(HexDump.toHexString(oldKey))) {
            return false;
        }
        String result = mBluetoothUtils.write(0, 1, 3, HexDump.toHexString(newKey), 2);
        return "1".equals(result);
    }

    @Override
    public Chip getNvlChip() {
        String ct;
        Chip chip = null;
        if (PrmtReader.mBluetoothUtils.mGattCallback == null) {
            mBluetoothUtils.scanBleDevice(true);
        }
        if ("2".equals(ct = mBluetoothUtils.CheckCard())) {
            chip = new Chip(1);
        } else if ("3".equals(ct)) {
            chip = new Chip(0);
        } else if ("7".equals(ct)) {
            chip = new Chip(6);
        } else if ("5".equals(ct)) {
            chip = new Chip(7);
        } else if ("0".equals(ct)) {
            chip = new Chip(11);
        }
        if (chip != null) {
            return chip;
        }
        return null;
    }

    public boolean read4442(int zone, int start, int length, byte[] buf) {
        if (this.get4442PwdAttemptCnt() <= 0) {
            return false;
        }
        String result = mBluetoothUtils.read(2, 2, 0, 128).replaceAll(" ", "");
        Log.d((String)"TAG", (String)("read4442: result " + result));
        if ("-1".equals(result)) {
            return false;
        }
        String result2 = mBluetoothUtils.read(2, 2, 128, 128).replaceAll(" ", "");
        Log.d((String)"TAG", (String)("read4442: result2 " + result2));
        if ("-1".equals(result2)) {
            return false;
        }
        byte[] bt = HexDump.hexStringToByteArray(result);
        byte[] bt2 = HexDump.hexStringToByteArray(result2);
        if (bt.length > 0) {
            System.arraycopy(bt, 0, buf, 0, bt.length);
            System.arraycopy(bt2, 0, buf, bt.length, bt2.length);
            return true;
        }
        return false;
    }

    public boolean read102(int length, byte[] buf, String key) {
        if (this.get102PwdAttemptCnt() <= 0) {
            return false;
        }
        if (key != null && !this.verify102Pwd(key)) {
            return false;
        }
        String result = mBluetoothUtils.read(0, 3, 0, 178).replaceAll(" ", "");
        byte[] bt = HexDump.hexStringToByteArray(result);
        System.arraycopy(bt, 0, buf, 0, bt.length);
        return true;
    }

    public byte[] readcard(int zone, int start, int length) {
        byte[] buf = new byte[length];
        if (length > 32) {
            byte[] bytes;
            int a = length / 32;
            int b = length % 32;
            for (int i = 0; i < a; ++i) {
                bytes = mBluetoothUtils.rd_datRW(zone, start + 32 * i, 32);
                if (bytes == null && bytes.length != 32) {
                    return null;
                }
                System.arraycopy(bytes, 0, buf, 0 + 32 * i, 32);
            }
            if (b != 0) {
                bytes = mBluetoothUtils.rd_datRW(zone, length - 32 * a, b);
                if (bytes == null && bytes.length != b) {
                    return null;
                }
                System.arraycopy(bytes, 0, buf, 32 * a, b);
            }
            return buf;
        }
        buf = mBluetoothUtils.rd_datRW(zone, start, length);
        if (buf == null && buf.length != length) {
            return null;
        }
        return buf;
    }

    public boolean verify102Pwd(String key) {
        String ret = mBluetoothUtils.checkPwd(0, key, 3);
        return "1".equals(ret);
    }

    public boolean verify4442Pwd(String key) {
        String ret = mBluetoothUtils.checkPwd(0, key, 2);
        return "1".equals(ret);
    }

    public int get4442PwdAttemptCnt() {
        String result = mBluetoothUtils.read(0, 2, 0, 1).replaceAll(" ", "");
        Log.d((String)"prmtreader", (String)("get4442PwdAttemptCnt: result " + result));
        byte[] count = HexDump.hexStringToByteArray(result);
        if (count.length == 1) {
            if ((count[0] & 7) == 7) {
                return 3;
            }
            if ((count[0] & 6) == 6) {
                return 2;
            }
            if ((count[0] & 4) == 4) {
                return 1;
            }
            return 0;
        }
        return -1;
    }

    public int get102PwdAttemptCnt() {
        String result = mBluetoothUtils.read(0, 3, 12, 1).replaceAll(" ", "");
        byte[] count = HexDump.hexStringToByteArray(result);
        if (count.length == 1) {
            if ((count[0] & 0xF0) == 240) {
                return 4;
            }
            if ((count[0] & 0xF0) == 112) {
                return 3;
            }
            if ((count[0] & 0xF0) == 48) {
                return 2;
            }
            if ((count[0] & 0xF0) == 16) {
                return 1;
            }
            return 0;
        }
        return -1;
    }

    @Override
    public byte[] resetCPUCard() {
        byte[] data = HexDump.hexStringToByteArray("3b690000574429083016101b1f");
        int ret = mBluetoothUtils.jcpureset();
        if (ret != 0) {
            return null;
        }
        return data;
    }

    @Override
    public byte[] resetRFCard() {
        return new byte[0];
    }

    @Override
    public byte[] resetPSAMCard() {
        byte[] data = new byte[8];
        return data;
    }

    @Override
    public byte[] CPUsendAPDU(byte[] APDU) {
        byte[] apdu = new byte[APDU[2]];
        System.arraycopy(APDU, 3, apdu, 0, APDU[2]);
        String sendData = HexDump.toHexString(apdu);
        ReadCard readCard = new ReadCard();
        int ret = mBluetoothUtils.jcpucmd(sendData, readCard);
        if (ret != 0) {
            return null;
        }
        return HexDump.hexStringToByteArray(readCard.strRecv);
    }

    @Override
    public byte[] RFsendAPDU(byte[] apdu) {
        return new byte[0];
    }

    @Override
    public byte[] PSAMsendAPDU(byte[] apdu) {
        byte[] data = new byte[8];
        return data;
    }

    private String get1608AreaReadPwd(int area, String[] pwd) {
        return pwd[(area + 1) * 2 - 1];
    }

    public boolean verify1608Pwd(byte area, byte type, byte[] key) {
        try {
            int qy = area * 2 + (1 - type);
            String result = mBluetoothUtils.checkPwd(qy, HexDump.toHexString(key), 7);
            CardAgent.log("verify1608Pwd area \uff1a " + area + ",type = " + qy + ", result = " + result);
            return "1".equals(result);
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean verify153Pwd(byte type, byte[] key) {
        try {
            String result = mBluetoothUtils.checkPwd((int)type, HexDump.toHexString(key), 0);
            return "1".equals(result);
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean read1608(int area, int offset, byte[] buf) {
        try {
            String result1 = mBluetoothUtils.read(area, 7, offset, 128).replaceAll(" ", "");
            String result2 = mBluetoothUtils.read(area, 7, 128, 128).replaceAll(" ", "");
            byte[] data = HexDump.hexStringToByteArray(result1);
            byte[] data2 = HexDump.hexStringToByteArray(result2);
            if (data.length > 0) {
                if (area == 2) {
                    System.arraycopy(data, 0, buf, 384, 128);
                    System.arraycopy(data2, 0, buf, 512, 128);
                } else {
                    System.arraycopy(data, 0, buf, 128, 128);
                    System.arraycopy(data2, 0, buf, 256, 128);
                }
            }
            return data.length > 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean read1608Config(int area, int offset, int len, byte[] buf) {
        byte[] data = null;
        try {
            String result = mBluetoothUtils.read(8, 7, offset, len).replaceAll(" ", "");
            data = HexDump.hexStringToByteArray(result);
            if (data.length > 0) {
                System.arraycopy(data, 0, buf, 0, 128);
            }
            return data.length > 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean write1608(int area, int offset, int len, byte[] buf) {
        if (len > 12) {
            String result = mBluetoothUtils.write(area, (int)((byte)offset), 12, HexDump.toHexString(buf, 0, 12), 7);
            if (!"1".equals(result)) {
                return false;
            }
            int length = len - 12;
            result = mBluetoothUtils.write(area, (int)((byte)(offset + 12)), length, HexDump.toHexString(buf, 12, length), 7);
            return "1".equals(result);
        }
        String result = mBluetoothUtils.write(area, (int)((byte)offset), len, HexDump.toHexString(buf), 7);
        return "1".equals(result);
    }

    static {
        isScan = false;
    }
}

