/*
 * Decompiled with CFR 0.152.
 */
package com.aofeng.hybrid.plugin;

import android.app.Activity;
import android.support.annotation.RequiresApi;
import android.telephony.TelephonyManager;
import android.util.Log;
import android.webkit.WebResourceRequest;
import android.webkit.WebResourceResponse;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.aofeng.hybrid.util.CommUtil;
import com.aofeng.hybrid.util.LogUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Date;

public class AFWebViewClient
extends WebViewClient {
    private static final String TAG = "AFWebViewClient";
    private Activity mActivity;

    public AFWebViewClient(Activity activity) {
        this.mActivity = activity;
    }

    public boolean shouldOverrideUrlLoading(WebView view, String url) {
        LogUtil.d(TAG, "shouldOverrideUrlLoading\uff1a" + url);
        String rnd = "stamp=" + new Date().getTime() + "&sn=" + ((TelephonyManager)view.getContext().getSystemService("phone")).getDeviceId();
        if (!url.contains("?")) {
            url = url + "?";
        }
        url = url + rnd;
        view.loadUrl(url);
        return false;
    }

    public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
        LogUtil.e(TAG, "onReceivedError = " + failingUrl);
        LogUtil.e(TAG, "errorCode = " + errorCode + " description " + description);
        super.onReceivedError(view, errorCode, description, failingUrl);
    }

    public void onPageFinished(WebView view, String url) {
        super.onPageFinished(view, url);
        view.clearCache(true);
        if (this.mActivity != null) {
            this.mActivity.setTitle((CharSequence)view.getTitle());
        }
    }

    public WebResourceResponse shouldInterceptRequest(WebView view, String url) {
        if (url.endsWith(".wasm")) {
            try {
                String[] s = url.split("/");
                url = CommUtil.getSharedPreference(view.getContext(), "LOCAL_PATH_PREFIX") + "www/" + s[s.length - 1];
                if (new File(url).exists()) {
                    WebResourceResponse webResourceResponse = new WebResourceResponse("application/wasm", "utf-8", (InputStream)new FileInputStream(url));
                    return webResourceResponse;
                }
            }
            catch (FileNotFoundException e) {
                Log.e((String)TAG, (String)e.getMessage());
            }
        }
        return super.shouldInterceptRequest(view, url);
    }

    @RequiresApi(api=21)
    public WebResourceResponse shouldInterceptRequest(WebView view, WebResourceRequest request) {
        String url = request.getUrl().toString();
        if (url.endsWith(".wasm")) {
            try {
                String[] s = url.split("/");
                url = CommUtil.getSharedPreference(view.getContext(), "LOCAL_PATH_PREFIX") + "www/" + s[s.length - 1];
                if (new File(url).exists()) {
                    WebResourceResponse webResourceResponse = new WebResourceResponse("application/wasm", "utf-8", (InputStream)new FileInputStream(url));
                    return webResourceResponse;
                }
                url = CommUtil.getSharedPreference(view.getContext(), "LOCAL_PATH_PREFIX") + "www/static/" + s[s.length - 1];
                if (new File(url).exists()) {
                    WebResourceResponse webResourceResponse = new WebResourceResponse("application/wasm", "utf-8", (InputStream)new FileInputStream(url));
                    return webResourceResponse;
                }
            }
            catch (FileNotFoundException e) {
                Log.e((String)TAG, (String)e.getMessage());
            }
        }
        return super.shouldInterceptRequest(view, request);
    }
}

