/*
 * Decompiled with CFR 0.152.
 */
package com.aofeng.hybrid.application;

import android.app.Activity;
import android.app.Application;
import android.app.Service;
import android.content.Context;
import android.os.Build;
import com.aofeng.hybrid.android.db.DatabaseHelper;
import com.aofeng.hybrid.orm.DatabaseManager;
import com.aofeng.hybrid.pos.device.Device;
import com.aofeng.hybrid.pos.printer.AfPrinter;
import com.aofeng.hybrid.pos.printer.PrintAgent;
import com.aofeng.hybrid.pos.reader.CardAgent;
import com.aofeng.hybrid.pos.reader.ICardReader;
import com.aofeng.hybrid.util.CommUtil;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONObject;

public class AFApplication
extends Application {
    public static String APP_DATA = null;
    public static Service service;
    public static int STATUS_COUNTER;
    public static int POS_STATUS_COUNTER;
    public static int BASE_INTERVAL;
    public static String SN;
    public static Device device;
    public static CardAgent card;
    public static PrintAgent printer;
    public static List<Activity> atvlist;

    public static void addActivity(Activity activity) {
        atvlist.add(activity);
    }

    public static void removeActivity(Activity activity) {
        atvlist.remove(activity);
    }

    public static void finishAll() {
        for (Activity activity : atvlist) {
            if (activity.isFinishing()) continue;
            activity.finish();
        }
    }

    public void onCreate() {
        super.onCreate();
        Context ctx = this.getApplicationContext();
        DatabaseManager.initializeInstance(new DatabaseHelper(ctx));
    }

    public static void initPos(Context context) throws Exception {
        JSONObject config = CommUtil.getHybridContext(context);
        card = new CardAgent();
        printer = new PrintAgent();
        String[] drp = AFApplication.getDRPStr(config);
        if (config.has("pos") && "true".equals(config.getString("pos").toLowerCase()) || config.has("bluetooth") && "true".equals(config.getString("bluetooth").toLowerCase())) {
            card.setCloudUrl(config.getString("cloud_url"));
            ICardReader cr = (ICardReader)Class.forName(drp[1]).getConstructor(new Class[0]).newInstance(new Object[0]);
            AfPrinter ap = (AfPrinter)Class.forName(drp[2]).getConstructor(new Class[0]).newInstance(new Object[0]);
            String socket_url = config.has("socket_url") ? config.getString("socket_url") : "";
            card.setSocketUrl(socket_url);
            card.setReader(cr);
            printer.setPrinter(ap);
        }
        if (config.has("pos") && "true".equals(config.getString("pos").toLowerCase())) {
            device = (Device)Class.forName(drp[0]).getConstructor(new Class[0]).newInstance(new Object[0]);
            device.initDevice(context);
            SN = device.getSN();
        }
    }

    public static String[] getDRPStr(JSONObject config) throws Exception {
        String printer;
        String reader;
        String factory = Build.MANUFACTURER;
        String[] drp = new String[]{"", "", ""};
        if ("Centerm".equals(factory)) {
            drp[0] = "com.aofeng.hybrid.pos.device.CTDevice";
            drp[1] = "com.aofeng.hybrid.pos.reader.CTChangAnReader";
            drp[2] = "com.aofeng.hybrid.pos.printer.CTPrinter";
        } else if ("LANDI".equals(factory)) {
            drp[0] = "com.aofeng.hybrid.pos.device.LDDevice";
            drp[1] = "com.aofeng.hybrid.pos.reader.LDChangAnReader";
            drp[2] = "com.aofeng.hybrid.pos.printer.LDPrinter";
        }
        String device = config.getString("device");
        if (!"".equals(device)) {
            drp[0] = device;
        }
        if (!"".equals(reader = config.getString("reader"))) {
            drp[1] = reader;
        }
        if (!"".equals(printer = config.getString("printer"))) {
            drp[2] = printer;
        }
        return drp;
    }

    static {
        STATUS_COUNTER = 15;
        POS_STATUS_COUNTER = 600;
        BASE_INTERVAL = 300000;
        SN = "";
        atvlist = new ArrayList<Activity>();
    }
}

