/*
 * Decompiled with CFR 0.152.
 */
package com.aofeng.hybrid.util;

import android.app.Activity;
import android.content.Context;
import android.media.MediaRecorder;
import android.os.Build;
import android.support.v4.app.ActivityCompat;
import android.support.v4.content.ContextCompat;
import com.aofeng.hybrid.application.AFApplication;
import com.aofeng.hybrid.util.LogUtil;
import java.io.File;
import java.io.IOException;

public class AudioClipManager {
    private static final String TAG = "AudioClipManager\u7c7b\uff0c\u540e\u53f0\u65e0\u9650\u5236\u5f55\u97f3";
    private static AudioClipManager instance;
    private static MediaRecorder mRecorder;
    private static boolean shouldStop;
    private static String FILE_PATH;
    private static String FILE_NAME;
    private Activity activity;
    private static final int AUTIO_MAX_DURATION = 3600000;
    private final String[] permissions = new String[]{"android.permission.RECORD_AUDIO"};

    private AudioClipManager() {
    }

    public static synchronized AudioClipManager getInstance() {
        if (instance == null) {
            instance = new AudioClipManager();
        }
        return instance;
    }

    public boolean startRecorder(Activity activity, String fileName) {
        try {
            if (mRecorder == null) {
                mRecorder = new MediaRecorder();
            }
            if (Build.VERSION.SDK_INT >= 23) {
                this.checkPermission(activity);
            }
            FILE_PATH = AFApplication.APP_DATA + fileName;
            FILE_NAME = fileName;
            this.activity = activity;
            mRecorder.setAudioSource(1);
            mRecorder.setOutputFormat(1);
            mRecorder.setAudioEncoder(1);
            mRecorder.setMaxDuration(3600000);
            mRecorder.setOutputFile(FILE_PATH);
            mRecorder.prepare();
            mRecorder.start();
            LogUtil.v(TAG, "\u540e\u53f0\u5f55\u97f3\u5f00\u59cb\uff0c\u6700\u957f\u65f6\u95f41\u5c0f\u65f6");
        }
        catch (IOException e) {
            LogUtil.e("AudioClipManager\u7c7b\uff0c\u540e\u53f0\u65e0\u9650\u5236\u5f55\u97f3\u5f55\u97f3\u5f00\u59cb\u5f02\u5e38", e.toString());
            if (null != mRecorder) {
                mRecorder.stop();
                mRecorder.reset();
            }
            return false;
        }
        return true;
    }

    public boolean stopRecorder(boolean isdelFile) {
        try {
            if (mRecorder != null) {
                mRecorder.stop();
                mRecorder.release();
                mRecorder = null;
                LogUtil.v("AudioClipManager\u7c7b\uff0c\u540e\u53f0\u65e0\u9650\u5236\u5f55\u97f3\u505c\u6b62\u5f55\u97f3", "\u6210\u529f");
            }
            if (isdelFile && !"".equals(FILE_PATH) && null == mRecorder) {
                boolean b = this.delAudioClipFile(FILE_PATH);
                if (b) {
                    LogUtil.v("AudioClipManager\u7c7b\uff0c\u540e\u53f0\u65e0\u9650\u5236\u5f55\u97f3\u5220\u9664\u4e0a\u6b21\u5f55\u97f3\u6587\u4ef6", "\u5220\u9664\u6210\u529f");
                } else {
                    LogUtil.e("AudioClipManager\u7c7b\uff0c\u540e\u53f0\u65e0\u9650\u5236\u5f55\u97f3\u5220\u9664\u4e0a\u6b21\u5f55\u97f3\u6587\u4ef6", "\u5220\u9664\u5931\u8d25");
                }
            }
            FILE_PATH = "";
        }
        catch (IllegalStateException e) {
            return false;
        }
        return true;
    }

    public boolean delAudioClipFile(String filePath) {
        try {
            int n;
            if (filePath.startsWith("file://")) {
                filePath = filePath.substring("file://".length());
            }
            if ((n = filePath.indexOf("?")) > 0) {
                filePath = filePath.substring(0, n);
            }
            File file = new File(filePath);
            file.delete();
        }
        catch (Exception e) {
            LogUtil.e("AudioClipManager\u7c7b\uff0c\u540e\u53f0\u65e0\u9650\u5236\u5f55\u97f3\u5220\u9664\u5f55\u97f3\u6587\u4ef6\u5931\u8d25", "\u6587\u4ef6\u5730\u5740" + filePath);
            return false;
        }
        return true;
    }

    public void checkPermission(Activity activity) {
        if (ContextCompat.checkSelfPermission((Context)activity, (String)"android.permission.RECORD_AUDIO") != 0) {
            ActivityCompat.requestPermissions((Activity)activity, (String[])this.permissions, (int)1);
        } else {
            LogUtil.v(TAG, "\u5df2\u7533\u8bf7\u6743\u9650");
        }
    }

    static {
        FILE_PATH = "";
        FILE_NAME = "";
    }
}

