/*
 * Decompiled with CFR 0.152.
 */
package com.aofeng.hybrid.service;

import android.content.Context;
import com.aofeng.hybrid.orm.JSonMapConverter;
import com.aofeng.hybrid.orm.SqlHelper;
import com.aofeng.hybrid.service.GenericService;
import com.aofeng.hybrid.service.SqlMapper;
import com.aofeng.hybrid.util.CommUtil;
import com.aofeng.hybrid.util.ExpressionHelper;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlService
extends GenericService {
    private static final Logger log = LoggerFactory.getLogger(SqlService.class);

    public SqlService(Context context) {
        super(context);
    }

    @Override
    public JSONObject action(JSONObject json) {
        JSONObject result = new JSONObject();
        try {
            result.put("code", 500);
            result.put("data", (Object)"\u4e0d\u53ef\u5904\u7406\u5f02\u5e38\u3002");
            if (json.has("alias")) {
                JSONArray array;
                JSONObject data = new JSONObject();
                if (json.has("count")) {
                    JSONObject sumJSON = this.getSumAndCnt(json.getString("alias"), json);
                    data.put("sum", (Object)sumJSON);
                    log.debug("\u5f97\u5230\u884c\u6570\uff1a" + sumJSON);
                }
                if (json.has("pageNo")) {
                    array = this.find(json.getString("alias"), json.getJSONObject("criteria"), json.getInt("pageNo"), json.getInt("pageSize"));
                    result.put("code", 200);
                    data.put("rows", (Object)array);
                    result.put("data", (Object)data);
                    log.debug("\u5f97\u5230\u6570\u636e" + data.toString());
                    return result;
                }
                array = this.find(json.getString("alias"), json.getJSONObject("criteria"), -1, -1);
                result.put("code", 200);
                data.put("rows", (Object)array);
                result.put("data", (Object)data);
                log.debug("\u5f97\u5230\u6570\u636e" + data.toString());
                return result;
            }
            if (json.has("cmd")) {
                SqlHelper.run(this.context, json.getString("sql"));
                result.put("code", 200);
                result.put("data", (Object)"");
                return result;
            }
            if (json.has("cmd2")) {
                SqlHelper.run(this.context, json.getString("sql"), "cmd2");
                result.put("code", 200);
                result.put("data", (Object)"");
                return result;
            }
            JSONArray rows = SqlHelper.list(this.context, json.getString("sql"));
            result.put("code", 200);
            result.put("data", (Object)rows);
            return result;
        }
        catch (Exception e) {
            try {
                result.put("code", 500);
                result.put("data", (Object)e.getMessage());
                return result;
            }
            catch (Exception ex) {
                return result;
            }
        }
    }

    public void run(String sql) throws Exception {
        SqlHelper.run(this.context, sql);
    }

    public JSONObject getSumAndCnt(String sqlModuleName, JSONObject jsonCriteria) throws Exception {
        JSONObject param = jsonCriteria.getJSONObject("criteria");
        Map<String, Object> params = JSonMapConverter.toMap(param);
        String sql = this.call(sqlModuleName, params);
        JSONArray sums = null;
        if (jsonCriteria.has("sums")) {
            sums = jsonCriteria.getJSONArray("sums");
        }
        sql = this.attachSumsOnSql(sql, sums);
        return SqlHelper.singleRow(this.context, sql);
    }

    public JSONArray find(String sqlModuleName, JSONObject jsonCriteria, int pageNo, int pageSize) throws Exception {
        Map<String, Object> params = JSonMapConverter.toMap(jsonCriteria);
        String sql = this.call(sqlModuleName, params).replace("\n", "").replace("\t", "");
        return SqlHelper.pagedList(this.context, sql, pageNo, pageSize);
    }

    private String attachSumsOnSql(String rawSql, JSONArray sums) throws Exception {
        String sql = "select ";
        if (sums != null) {
            for (int i = 0; i < sums.length(); ++i) {
                String name = (String)sums.get(i);
                sql = sql + "sum(" + name + ") " + name + ", ";
            }
        }
        sql = sql + "count(*) n from ( " + rawSql + ") ___t___";
        return sql;
    }

    public String call(String alias, Map<String, Object> params) {
        String path = SqlMapper.getSql(this.context, alias);
        String sql = CommUtil.readFile(CommUtil.getFilePath(this.context) + "sqls/" + path);
        sql = "$" + sql;
        for (String key : this.services.keySet()) {
            params.put(key, this.services.get(key));
        }
        sql = ExpressionHelper.run(sql, params).toString();
        return sql;
    }
}

