/*
 * Decompiled with CFR 0.152.
 */
package com.aofeng.hybrid.android.zbar.camera;

import android.app.Activity;
import android.content.Context;
import android.graphics.Point;
import android.graphics.Rect;
import android.hardware.Camera;
import android.os.Build;
import android.os.Handler;
import android.view.SurfaceHolder;
import com.aofeng.hybrid.android.peripheral.CaptureActivity;
import com.aofeng.hybrid.android.zbar.camera.AutoFocusCallback;
import com.aofeng.hybrid.android.zbar.camera.CameraConfigurationManager;
import com.aofeng.hybrid.android.zbar.camera.FlashlightManager;
import com.aofeng.hybrid.android.zbar.camera.PreviewCallback;
import java.io.IOException;

public final class CameraManager {
    private static CameraManager cameraManager;
    static final int SDK_INT;
    private final Context context;
    private final CameraConfigurationManager configManager;
    private Camera camera;
    private Rect framingRect;
    private Rect framingRectInPreview;
    private boolean initialized;
    private boolean previewing;
    private final boolean useOneShotPreviewCallback;
    private final PreviewCallback previewCallback;
    private final AutoFocusCallback autoFocusCallback;
    int IndexCamera;

    public static void init(Context context) {
        if (cameraManager == null) {
            cameraManager = new CameraManager(context);
        }
    }

    public static CameraManager get() {
        return cameraManager;
    }

    private CameraManager(Context context) {
        this.context = context;
        this.configManager = new CameraConfigurationManager(context);
        this.useOneShotPreviewCallback = Integer.parseInt(Build.VERSION.SDK) > 3;
        this.previewCallback = new PreviewCallback(this.configManager, this.useOneShotPreviewCallback);
        this.autoFocusCallback = new AutoFocusCallback();
    }

    private int FindFrontCamera() {
        int cameraCount = 0;
        Camera.CameraInfo cameraInfo = new Camera.CameraInfo();
        cameraCount = Camera.getNumberOfCameras();
        for (int camIdx = 0; camIdx < cameraCount; ++camIdx) {
            Camera.getCameraInfo((int)camIdx, (Camera.CameraInfo)cameraInfo);
            if (cameraInfo.facing != 1) continue;
            return camIdx;
        }
        return -1;
    }

    private int FindBackCamera() {
        int cameraCount = 0;
        Camera.CameraInfo cameraInfo = new Camera.CameraInfo();
        cameraCount = Camera.getNumberOfCameras();
        for (int camIdx = 0; camIdx < cameraCount; ++camIdx) {
            Camera.getCameraInfo((int)camIdx, (Camera.CameraInfo)cameraInfo);
            if (cameraInfo.facing != 0) continue;
            return camIdx;
        }
        return -1;
    }

    public void openDriver(SurfaceHolder holder, String FrontCamera) throws IOException {
        if (this.camera == null) {
            int BackIndex = this.FindBackCamera();
            int FrontaIndex = this.FindFrontCamera();
            this.IndexCamera = BackIndex == -1 || FrontaIndex != -1 && "true".equals(FrontCamera.toLowerCase()) ? FrontaIndex : BackIndex;
            this.camera = Camera.open((int)this.IndexCamera);
            if (this.camera == null) {
                throw new IOException();
            }
            this.camera.setPreviewDisplay(holder);
            if (!this.initialized) {
                this.initialized = true;
                this.configManager.initFromCameraParameters(this.camera);
            }
            this.configManager.setDesiredCameraParameters(this.camera, FrontCamera);
            FlashlightManager.enableFlashlight();
        }
    }

    private void setCameraDisplayOrientation() {
        int result;
        Camera.CameraInfo info = new Camera.CameraInfo();
        Camera.getCameraInfo((int)this.IndexCamera, (Camera.CameraInfo)info);
        int rotation = ((Activity)CaptureActivity.context).getWindowManager().getDefaultDisplay().getRotation();
        int degrees = 0;
        switch (rotation) {
            case 0: {
                degrees = 0;
                break;
            }
            case 1: {
                degrees = 90;
                break;
            }
            case 2: {
                degrees = 180;
                break;
            }
            case 3: {
                degrees = 270;
            }
        }
        if (info.facing == 1) {
            result = (info.orientation + degrees) % 360;
            result = (360 - result) % 360;
        } else {
            result = (info.orientation - degrees + 360) % 360;
        }
        this.camera.setDisplayOrientation(result);
    }

    public void closeDriver() {
        if (this.camera != null) {
            FlashlightManager.disableFlashlight();
            this.camera.release();
            this.camera = null;
        }
    }

    public void startPreview() {
        if (this.camera != null && !this.previewing) {
            this.camera.startPreview();
            this.previewing = true;
        }
    }

    public void stopPreview() {
        if (this.camera != null && this.previewing) {
            if (!this.useOneShotPreviewCallback) {
                this.camera.setPreviewCallback(null);
            }
            this.camera.stopPreview();
            this.previewCallback.setHandler(null, 0);
            this.autoFocusCallback.setHandler(null, 0);
            this.previewing = false;
        }
    }

    public void requestPreviewFrame(Handler handler, int message) {
        if (this.camera != null && this.previewing) {
            this.previewCallback.setHandler(handler, message);
            if (this.useOneShotPreviewCallback) {
                this.camera.setOneShotPreviewCallback((Camera.PreviewCallback)this.previewCallback);
            } else {
                this.camera.setPreviewCallback((Camera.PreviewCallback)this.previewCallback);
            }
        }
    }

    public void requestAutoFocus(Handler handler, int message) {
        if (this.camera != null && this.previewing) {
            this.autoFocusCallback.setHandler(handler, message);
            this.camera.autoFocus((Camera.AutoFocusCallback)this.autoFocusCallback);
        }
    }

    public Rect getFramingRect() {
        Point localPoint = this.configManager.getScreenResolution();
        if (this.framingRect == null) {
            if (this.camera == null) {
                return null;
            }
            float density = this.context.getResources().getDisplayMetrics().density;
            int width = localPoint.x - 2 * (int)(10.0f * density);
            int height = localPoint.y / 3;
            int left = (localPoint.x - width) / 2;
            int top = (localPoint.y - height) / 2;
            this.framingRect = new Rect(left, top, left + width, top + height);
        }
        return this.framingRect;
    }

    public Rect getFramingRectInPreview() {
        if (this.framingRectInPreview == null) {
            Rect rect = new Rect(this.getFramingRect());
            Point cameraResolution = this.configManager.getCameraResolution();
            Point screenResolution = this.configManager.getScreenResolution();
            rect.left = rect.left * cameraResolution.y / screenResolution.x;
            rect.right = rect.right * cameraResolution.y / screenResolution.x;
            rect.top = rect.top * cameraResolution.x / screenResolution.y;
            rect.bottom = rect.bottom * cameraResolution.x / screenResolution.y;
            this.framingRectInPreview = rect;
        }
        return this.framingRectInPreview;
    }

    public Context getContext() {
        return this.context;
    }

    public void openLight() {
        if (this.camera != null) {
            Camera.Parameters parameter = this.camera.getParameters();
            parameter.setFlashMode("torch");
            this.camera.setParameters(parameter);
        }
    }

    public void offLight() {
        if (this.camera != null) {
            Camera.Parameters parameter = this.camera.getParameters();
            parameter.setFlashMode("off");
            this.camera.setParameters(parameter);
        }
    }

    static {
        int sdkInt;
        try {
            sdkInt = Integer.parseInt(Build.VERSION.SDK);
        }
        catch (NumberFormatException nfe) {
            sdkInt = 10000;
        }
        SDK_INT = sdkInt;
    }
}

