/*
 * Decompiled with CFR 0.152.
 */
package com.aofeng.hybrid.android.sign;

import com.aofeng.hybrid.android.sign.ControllerPoint;

public class Bezier {
    private ControllerPoint mControl = new ControllerPoint();
    private ControllerPoint mDestination = new ControllerPoint();
    private ControllerPoint mNextControl = new ControllerPoint();
    private ControllerPoint mSource = new ControllerPoint();

    public void init(ControllerPoint last, ControllerPoint cur) {
        this.init(last.x, last.y, last.width, cur.x, cur.y, cur.width);
    }

    public void init(float lastx, float lasty, float lastWidth, float x, float y, float width) {
        this.mSource.set(lastx, lasty, lastWidth);
        float xmid = this.getMid(lastx, x);
        float ymid = this.getMid(lasty, y);
        float wmid = this.getMid(lastWidth, width);
        this.mDestination.set(xmid, ymid, wmid);
        this.mControl.set(this.getMid(lastx, xmid), this.getMid(lasty, ymid), this.getMid(lastWidth, wmid));
        this.mNextControl.set(x, y, width);
    }

    public void addNode(ControllerPoint cur) {
        this.addNode(cur.x, cur.y, cur.width);
    }

    public void addNode(float x, float y, float width) {
        this.mSource.set(this.mDestination);
        this.mControl.set(this.mNextControl);
        this.mDestination.set(this.getMid(this.mNextControl.x, x), this.getMid(this.mNextControl.y, y), this.getMid(this.mNextControl.width, width));
        this.mNextControl.set(x, y, width);
    }

    public void end() {
        this.mSource.set(this.mDestination);
        float x = this.getMid(this.mNextControl.x, this.mSource.x);
        float y = this.getMid(this.mNextControl.y, this.mSource.y);
        float w = this.getMid(this.mNextControl.width, this.mSource.width);
        this.mControl.set(x, y, w);
        this.mDestination.set(this.mNextControl);
    }

    public ControllerPoint getPoint(double t) {
        float x = (float)this.getX(t);
        float y = (float)this.getY(t);
        float w = (float)this.getW(t);
        ControllerPoint point = new ControllerPoint();
        point.set(x, y, w);
        return point;
    }

    private double getValue(double p0, double p1, double p2, double t) {
        double A = p2 - 2.0 * p1 + p0;
        double B = 2.0 * (p1 - p0);
        double C = p0;
        return A * t * t + B * t + C;
    }

    private double getX(double t) {
        return this.getValue(this.mSource.x, this.mControl.x, this.mDestination.x, t);
    }

    private double getY(double t) {
        return this.getValue(this.mSource.y, this.mControl.y, this.mDestination.y, t);
    }

    private double getW(double t) {
        return this.getWidth(this.mSource.width, this.mDestination.width, t);
    }

    private float getMid(float x1, float x2) {
        return (float)((double)(x1 + x2) / 2.0);
    }

    private double getWidth(double w0, double w1, double t) {
        return w0 + (w1 - w0) * t;
    }
}

