/*
 * Decompiled with CFR 0.152.
 */
package com.aofeng.hybrid.android.receiver;

import android.content.Context;
import android.location.Criteria;
import android.location.GpsSatellite;
import android.location.GpsStatus;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.os.Bundle;
import android.os.Handler;
import android.telephony.PhoneStateListener;
import android.telephony.SignalStrength;
import android.telephony.TelephonyManager;
import com.aofeng.hybrid.util.CommUtil;
import com.aofeng.hybrid.util.LogUtil;
import java.text.SimpleDateFormat;
import java.util.Iterator;

public class PhoneStatusReceiver {
    public static int MAX_SIGNAL_DBM_VALUE = 31;
    private Context context;
    public static LocationListener locListener;

    public PhoneStatusReceiver(Context context) {
        this.context = context;
    }

    public void setupReceivers() {
        this.setupPhoneStateReceiver();
        PhoneStatusReceiver.setupGPSReceiver(this.context);
    }

    public static void setupGPSReceiver(final Context context) {
        Criteria criteria = new Criteria();
        criteria.setAccuracy(1);
        criteria.setAltitudeRequired(true);
        criteria.setBearingRequired(true);
        criteria.setCostAllowed(true);
        criteria.setPowerRequirement(1);
        final LocationManager locationManager = (LocationManager)context.getSystemService("location");
        final String provider = locationManager.getBestProvider(criteria, true);
        Handler mainHandler = new Handler(context.getMainLooper());
        if (provider == null) {
            LogUtil.e("\u4f4d\u7f6e", "\u4f4d\u7f6e\u76d1\u542c\u5931\u6548");
            if (locListener != null) {
                mainHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        locationManager.removeUpdates(locListener);
                        locListener = null;
                    }
                });
            }
            CommUtil.setSharedPreference(context, "longitude", "0");
            CommUtil.setSharedPreference(context, "latitude", "0");
            CommUtil.setSharedPreference(context, "altitude", "0");
            CommUtil.setSharedPreference(context, "provider", "0");
            return;
        }
        Location location = locationManager.getLastKnownLocation(provider);
        LogUtil.e("\u4f4d\u7f6e", "\u4f4d\u7f6e\u76d1\u542c\u6fc0\u6d3b");
        if (location == null) {
            CommUtil.setSharedPreference(context, "longitude", "0");
            CommUtil.setSharedPreference(context, "latitude", "0");
            CommUtil.setSharedPreference(context, "altitude", "0");
            CommUtil.setSharedPreference(context, "provider", "0");
        } else {
            CommUtil.setSharedPreference(context, "longitude", location.getLongitude() + "");
            CommUtil.setSharedPreference(context, "latitude", location.getLatitude() + "");
            CommUtil.setSharedPreference(context, "altitude", location.getAltitude() + "");
            CommUtil.setSharedPreference(context, "provider", location.getProvider());
        }
        if (locListener == null) {
            locListener = new LocationListener(){

                public void onLocationChanged(Location location) {
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    LogUtil.e("\u4f4d\u7f6e", "\u6536\u5230\u4f4d\u7f6e\u6539\u53d8=>\u65f6\u95f4:" + sdf.format(location.getTime()) + ",\u7ecf\u5ea6\uff1a" + location.getLongitude() + ",\u7eac\u5ea6:" + location.getLatitude() + ",\u6d77\u62d4:" + location.getAltitude() + ",\u4f9b\u5e94\u65b9:" + location.getProvider() + ",\u901f\u5ea6:" + location.getSpeed() + ",\u65b9\u5411:" + location.getBearing() + "\uff0c\u536b\u661f\u6570:" + CommUtil.getSharedPreference(context, "satellite"));
                    CommUtil.setSharedPreference(context, "longitude", location.getLongitude() + "");
                    CommUtil.setSharedPreference(context, "latitude", location.getLatitude() + "");
                    CommUtil.setSharedPreference(context, "altitude", location.getAltitude() + "");
                    CommUtil.setSharedPreference(context, "provider", location.getProvider());
                }

                public void onStatusChanged(String provider, int status, Bundle extras) {
                    LogUtil.d("onStatusChanged", "GPS\u72b6\u6001\u53d1\u751f\u53d8\u5316");
                }

                public void onProviderEnabled(String provider) {
                    LogUtil.d("onProviderEnabled", "GPS\u5f00\u542f\u89e6\u53d1");
                }

                public void onProviderDisabled(String provider) {
                    LogUtil.d("onProviderDisabled", "GPS\u7981\u7528\u89e6\u53d1");
                }
            };
            mainHandler.post(new Runnable(){

                @Override
                public void run() {
                    locationManager.requestLocationUpdates(provider, 1000L, 10.0f, locListener);
                }
            });
        }
        GpsStatus.Listener listener = new GpsStatus.Listener(){

            public void onGpsStatusChanged(int event) {
                switch (event) {
                    case 3: {
                        LogUtil.d("GpsListener", "\u7b2c\u4e00\u6b21\u5b9a\u4f4d");
                        break;
                    }
                    case 4: {
                        int count;
                        LogUtil.d("GpsListener", "\u536b\u661f\u72b6\u6001\u6539\u53d8");
                        GpsStatus gpsStatus = locationManager.getGpsStatus(null);
                        int maxSatellites = gpsStatus.getMaxSatellites();
                        Iterator iters = gpsStatus.getSatellites().iterator();
                        for (count = 0; iters.hasNext() && count <= maxSatellites; ++count) {
                            GpsSatellite s = (GpsSatellite)iters.next();
                        }
                        LogUtil.e("GpsListener:", "\u641c\u7d22\u5230=>" + count + "\u9897\u536b\u661f");
                        CommUtil.setSharedPreference(context, "satellite", count + "");
                        break;
                    }
                    case 1: {
                        LogUtil.d("GpsListener", "\u5b9a\u4f4d\u542f\u52a8");
                        break;
                    }
                    case 2: {
                        LogUtil.d("GpsListener", "\u5b9a\u4f4d\u7ed3\u675f");
                    }
                }
            }
        };
    }

    private void setupPhoneStateReceiver() {
        TelephonyManager tm = (TelephonyManager)this.context.getSystemService("phone");
        tm.listen((PhoneStateListener)new AFPhoneStateListener(), 256);
        CommUtil.setSharedPreference(this.context, "signalStrength", "0");
    }

    private int get4DegreeSignalStrength(int dbm) {
        if (dbm > -65) {
            return 4;
        }
        if (dbm > -79) {
            return 3;
        }
        if (dbm > -89) {
            return 2;
        }
        if (dbm > -99) {
            return 1;
        }
        return 0;
    }

    private class AFPhoneStateListener
    extends PhoneStateListener {
        private AFPhoneStateListener() {
        }

        public void onSignalStrengthsChanged(SignalStrength signalStrength) {
            super.onSignalStrengthsChanged(signalStrength);
            TelephonyManager tm = (TelephonyManager)PhoneStatusReceiver.this.context.getSystemService("phone");
            int pt = tm.getPhoneType();
            int dbm = pt == 1 ? signalStrength.getGsmSignalStrength() : (pt == 2 ? signalStrength.getCdmaDbm() : 0);
            CommUtil.setSharedPreference(PhoneStatusReceiver.this.context, "signalStrength", PhoneStatusReceiver.this.get4DegreeSignalStrength(dbm) + "");
        }
    }
}

