/*
 * Decompiled with CFR 0.152.
 */
package com.aofeng.hybrid.util;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCallback;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattDescriptor;
import android.bluetooth.BluetoothGattService;
import android.os.Handler;
import android.support.annotation.RequiresApi;
import android.util.Log;
import android.webkit.WebView;
import com.aofeng.hybrid.util.HexDump;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

@RequiresApi(api=18)
public class BluetoothTools {
    @SuppressLint(value={"StaticFieldLeak"})
    private static final BluetoothAdapter mBtAdapter = BluetoothAdapter.getDefaultAdapter();
    private static WebView webView;
    private static List<BluetoothDevice> bleDevices;
    private static BluetoothGatt mGatt;
    private static BluetoothGattCharacteristic WCharacter;
    private static BluetoothGattCharacteristic RCharacter;
    private static final BluetoothAdapter.LeScanCallback mLeScanCallback;

    public static void scanBle(WebView webView, boolean isScan, String uuid, long scanTime) {
        if (!mBtAdapter.isEnabled()) {
            mBtAdapter.enable();
        }
        while (!mBtAdapter.isEnabled()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                Log.e((String)"PrmtReader", (String)"ScanBluetooth : ", (Throwable)e);
            }
        }
        BluetoothTools.webView = webView;
        bleDevices = new ArrayList<BluetoothDevice>();
        if (isScan) {
            new Handler().postDelayed(new Runnable(){

                @Override
                public void run() {
                    mBtAdapter.stopLeScan(mLeScanCallback);
                }
            }, scanTime * 1000L);
            UUID[] uuids = null;
            if (uuid != null) {
                String[] ids = uuid.split(",");
                uuids = new UUID[ids.length];
                for (int i = 0; i < ids.length; ++i) {
                    uuids[i] = UUID.fromString(ids[i]);
                }
            }
            mBtAdapter.startLeScan(uuids, mLeScanCallback);
        } else {
            mBtAdapter.stopLeScan(mLeScanCallback);
        }
    }

    public static void connectBle(String address, final String WUUID, final String RUUID) {
        mBtAdapter.stopLeScan(mLeScanCallback);
        BluetoothDevice mCurDevice = mBtAdapter.getRemoteDevice(address);
        if (mGatt == null) {
            mGatt = mCurDevice.connectGatt(webView.getContext(), false, new BluetoothGattCallback(){

                public void onConnectionStateChange(BluetoothGatt gatt, int status, int newState) {
                    switch (newState) {
                        case 2: {
                            ((Activity)webView.getContext()).runOnUiThread(new Runnable(){

                                @Override
                                public void run() {
                                    webView.loadUrl(String.format("javascript:HostApp.__callback__(\"%s\",\"%s\");", "CONN", "\u84dd\u7259\u5df2\u8fde\u63a5"));
                                }
                            });
                            gatt.discoverServices();
                            break;
                        }
                        case 0: {
                            ((Activity)webView.getContext()).runOnUiThread(new Runnable(){

                                @Override
                                public void run() {
                                    webView.loadUrl(String.format("javascript:HostApp.__callback__(\"%s\",\"%s\");", "CONN", "\u84dd\u7259\u5df2\u65ad\u5f00"));
                                }
                            });
                            break;
                        }
                        case 1: {
                            break;
                        }
                    }
                }

                public void onServicesDiscovered(BluetoothGatt gatt, int status) {
                    if (status == 0) {
                        List bgss = gatt.getServices();
                        for (BluetoothGattService bgs : bgss) {
                            WCharacter = bgs.getCharacteristic(UUID.fromString(WUUID));
                            if (WCharacter == null) continue;
                            break;
                        }
                        if (RUUID != null) {
                            for (BluetoothGattService bgs : bgss) {
                                List descriptorList;
                                RCharacter = bgs.getCharacteristic(UUID.fromString(RUUID));
                                if (RCharacter == null) continue;
                                boolean isEnableNotification = gatt.setCharacteristicNotification(RCharacter, true);
                                if (!isEnableNotification || (descriptorList = RCharacter.getDescriptors()) == null || descriptorList.size() <= 0) break;
                                for (BluetoothGattDescriptor descriptor : descriptorList) {
                                    descriptor.setValue(BluetoothGattDescriptor.ENABLE_NOTIFICATION_VALUE);
                                    gatt.writeDescriptor(descriptor);
                                }
                            }
                        }
                    }
                }

                public void onCharacteristicWrite(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic, int status) {
                    String message = HexDump.toHexString(characteristic.getValue());
                    Log.e((String)"onCharacteristicWrite\u4e2d", (String)message);
                    if (status == 0) {
                        Log.e((String)"onCharacteristicWrite\u4e2d", (String)"\u53d1\u9001\u6210\u529f");
                        ((Activity)webView.getContext()).runOnUiThread(new Runnable(){

                            @Override
                            public void run() {
                                webView.loadUrl(String.format("javascript:HostApp.__callback__(\"%s\",\"%s\");", "WRITE", "\u53d1\u9001\u6210\u529f"));
                            }
                        });
                    } else if (status == 257) {
                        Log.e((String)"onCharacteristicWrite\u4e2d", (String)"\u53d1\u9001\u5931\u8d25");
                        ((Activity)webView.getContext()).runOnUiThread(new Runnable(){

                            @Override
                            public void run() {
                                webView.loadUrl(String.format("javascript:HostApp.__callback__(\"%s\",\"%s\");", "WRITE", "\u53d1\u9001\u5931\u8d25"));
                            }
                        });
                    } else if (status == 3) {
                        Log.e((String)"onCharacteristicWrite\u4e2d", (String)"\u65e0\u6743\u9650");
                        ((Activity)webView.getContext()).runOnUiThread(new Runnable(){

                            @Override
                            public void run() {
                                webView.loadUrl(String.format("javascript:HostApp.__callback__(\"%s\",\"%s\");", "WRITE", "\u65e0\u6743\u9650"));
                            }
                        });
                    }
                }

                public void onCharacteristicChanged(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic) {
                    final String message = HexDump.toHexString(characteristic.getValue());
                    Log.e((String)"onCharacteristicRead\u4e2d", (String)message);
                    ((Activity)webView.getContext()).runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            webView.loadUrl(String.format("javascript:HostApp.__callback__(\"%s\",\"%s\");", "BACK", message));
                        }
                    });
                }
            });
        } else {
            mGatt.connect();
            mGatt.discoverServices();
        }
    }

    public static void wirteBle(String data) {
        WCharacter.setValue(HexDump.hexStringToByteArray(data));
        mGatt.writeCharacteristic(WCharacter);
    }

    public static void unconnectBle(WebView webView) {
        if (mGatt != null) {
            mGatt.disconnect();
            mGatt.close();
            mGatt = null;
        }
    }

    static {
        mLeScanCallback = new BluetoothAdapter.LeScanCallback(){

            public void onLeScan(final BluetoothDevice device, int rssi, byte[] scanRecord) {
                if (!bleDevices.contains(device)) {
                    bleDevices.add(device);
                    ((Activity)webView.getContext()).runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            webView.loadUrl(String.format("javascript:HostApp.__callback__(\"%s\",\"%s\");", device.getName(), device.getAddress()));
                        }
                    });
                }
            }
        };
    }
}

