/*
 * Decompiled with CFR 0.152.
 */
package com.aofeng.hybrid.android.receiver;

import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.TrafficStats;
import android.os.Environment;
import android.os.StatFs;
import android.telephony.TelephonyManager;
import com.aofeng.hybrid.util.CommUtil;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.json.JSONObject;

public class PhoneStatus {
    public static JSONObject getPhoneStatus(Context context, Date date) throws Exception {
        JSONObject jo = new JSONObject();
        jo.put("f_battery_level", PhoneStatus.getBatteryLevel(context));
        jo.put("f_internal_quote", PhoneStatus.getFreeInternalSDCapacity());
        jo.put("f_sn", (Object)PhoneStatus.getDeviceId(context));
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        String ymdToday = sdf.format(date);
        PhoneStatus.getTraffic(context);
        jo.put("f_traffic", (Object)Integer.valueOf(PhoneStatus.getPrefValue(context, "traffic_" + ymdToday + "_acc")));
        jo.put("f_signal_strength", (Object)Integer.valueOf(PhoneStatus.getPrefValue(context, "signalStrength")));
        jo.put("f_longitude", (Object)PhoneStatus.getPrefValue(context, "longitude"));
        jo.put("f_latitude", (Object)PhoneStatus.getPrefValue(context, "latitude"));
        jo.put("f_altitude", (Object)PhoneStatus.getPrefValue(context, "altitude"));
        jo.put("f_provider", (Object)PhoneStatus.getPrefValue(context, "provider"));
        return jo;
    }

    public static JSONObject getDailyPhoneStatus(Context context, String ymd) throws Exception {
        JSONObject map = new JSONObject();
        PhoneStatus.getTraffic(context);
        map.put("f_traffic", (Object)Integer.valueOf(PhoneStatus.getPrefValue(context, "traffic_" + ymd.replace("-", "") + "_acc")));
        map.put("f_sn", (Object)PhoneStatus.getDeviceId(context));
        return map;
    }

    public static int getBatteryLevel(Context context) {
        Intent intent = context.registerReceiver(null, new IntentFilter("android.intent.action.BATTERY_CHANGED"));
        int level = intent.getIntExtra("level", 0);
        int scale = intent.getIntExtra("scale", 100);
        return level * 100 / scale;
    }

    private static String getTraffic(Context context) {
        try {
            int uid = context.getPackageManager().getApplicationInfo((String)context.getApplicationContext().getPackageName(), (int)0).uid;
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
            Date dt = new Date();
            String ymdToday = sdf.format(dt);
            boolean hasToday = PhoneStatus.hasPrefValue(context, "traffic_" + ymdToday + "_base");
            dt = new Date(new Date().getTime() - 86400000L);
            String ymdYesterday = sdf.format(dt);
            boolean hasYesterday = PhoneStatus.hasPrefValue(context, "traffic_" + ymdYesterday + "_base");
            if (hasToday) {
                PhoneStatus.updateTodayTraffic(context, ymdToday, uid);
            } else {
                PhoneStatus.createTodayAndUpdateYesterdayTraffic(context, ymdToday, ymdYesterday, uid, hasYesterday);
            }
            PhoneStatus.eliminateRedundancy(context, ymdToday);
            return Long.parseLong(PhoneStatus.getPrefValue(context, "traffic_" + ymdToday + "_acc")) / 1024L + "";
        }
        catch (Exception e) {
            return "0";
        }
    }

    private static void eliminateRedundancy(Context context, String ymdToday) {
    }

    private static void createTodayAndUpdateYesterdayTraffic(Context context, String ymdToday, String ymdYesterday, int uid, boolean hasYesterday) {
        long trafficYesterday;
        long trafficNow = PhoneStatus.getTrafficByUid(uid);
        PhoneStatus.setPrefValue(context, "traffic_" + ymdToday + "_base", trafficNow);
        PhoneStatus.setPrefValue(context, "traffic_" + ymdToday + "_acc", 0L);
        if (hasYesterday && trafficNow > (trafficYesterday = Long.parseLong(PhoneStatus.getPrefValue(context, "traffic_" + ymdYesterday + "_base")))) {
            long delta = trafficNow - trafficYesterday;
            long acc = Long.parseLong(PhoneStatus.getPrefValue(context, "traffic_" + ymdYesterday + "_acc"));
            PhoneStatus.setPrefValue(context, "traffic_" + ymdYesterday + "_acc", acc + delta / 2L);
            PhoneStatus.setPrefValue(context, "traffic_" + ymdToday + "_acc", delta / 2L);
        }
    }

    private static void updateTodayTraffic(Context context, String ymdToday, int uid) {
        long delta;
        long trafficNow = PhoneStatus.getTrafficByUid(uid);
        long trafficBase = Long.parseLong(PhoneStatus.getPrefValue(context, "traffic_" + ymdToday + "_base"));
        long trafficAcc = Long.parseLong(PhoneStatus.getPrefValue(context, "traffic_" + ymdToday + "_acc"));
        if (trafficNow < trafficBase) {
            delta = trafficNow;
            PhoneStatus.setPrefValue(context, "traffic_" + ymdToday + "_base", delta);
        } else {
            delta = trafficNow - trafficBase;
        }
        PhoneStatus.setPrefValue(context, "traffic_" + ymdToday + "_acc", delta + trafficAcc);
        PhoneStatus.setPrefValue(context, "traffic_" + ymdToday + "_base", trafficNow);
    }

    private static void setPrefValue(Context context, String key, long delta) {
        CommUtil.setSharedPreference(context, key, delta + "");
    }

    private static long getTrafficByUid(int uid) {
        return TrafficStats.getUidTxBytes((int)uid) + TrafficStats.getUidRxBytes((int)uid);
    }

    private static boolean hasPrefValue(Context context, String key) {
        return !CommUtil.getSharedPreference(context, key).equals("");
    }

    private static String getPrefValue(Context context, String key) {
        return CommUtil.getSharedPreference(context, key);
    }

    public static long getFreeInternalSDCapacity() {
        StatFs sf = new StatFs(Environment.getDataDirectory().getPath());
        long quote = sf.getAvailableBlocks();
        quote *= (long)sf.getBlockSize();
        quote /= 1024L;
        return quote /= 1024L;
    }

    public static String getDeviceId(Context context) {
        return ((TelephonyManager)context.getSystemService("phone")).getDeviceId();
    }
}

