/*
 * Decompiled with CFR 0.152.
 */
package com.aofeng.hybrid.pos.reader;

import android.os.Bundle;
import android.util.Log;
import com.aofeng.hybrid.activity.MainActivity;
import com.aofeng.hybrid.pos.device.CTYSDevice;
import com.aofeng.hybrid.pos.reader.Chip;
import com.aofeng.hybrid.pos.reader.ICardReader;
import com.aofeng.hybrid.util.HexDump;
import com.ums.upos.sdk.card.industry.IndustryCardApdu;
import com.ums.upos.sdk.card.industry.IndustryCardManager;
import com.ums.upos.sdk.cardslot.CardInfoEntity;
import com.ums.upos.sdk.cardslot.CardSlotManager;
import com.ums.upos.sdk.cardslot.CardSlotTypeEnum;
import com.ums.upos.sdk.cardslot.CardTypeEnum;
import com.ums.upos.sdk.cardslot.OnCardInfoListener;
import com.ums.upos.sdk.exception.CallServiceException;
import com.ums.upos.sdk.exception.SdkException;
import java.util.HashMap;
import java.util.HashSet;

public class CTYSNativeReader
implements ICardReader {
    private static CardSlotManager cardSlotManager = new CardSlotManager();
    private static IndustryCardManager industryCardManager = new IndustryCardManager();
    private static boolean findCardStatus = false;
    private static CardSlotTypeEnum cardTypeEnum;

    @Override
    public boolean openDevice(Chip chip) {
        if (!CTYSDevice.islogin && !CTYSDevice.login(MainActivity.context)) {
            return false;
        }
        CTYSNativeReader.findCard();
        return true;
    }

    public static void hasCardState(boolean bool) {
        findCardStatus = bool;
    }

    @Override
    public boolean closeDevice(Chip chip) {
        CTYSNativeReader.hasCardState(false);
        try {
            industryCardManager.quit();
        }
        catch (SdkException e) {
            Log.e((String)"closeDevice", (String)("SdkException-" + e.getMessage()));
        }
        catch (CallServiceException e) {
            Log.e((String)"closeDevice", (String)("CallServiceException" + e.getMessage()));
        }
        return true;
    }

    @Override
    public boolean read(Chip chip) {
        try {
            if (chip.chipName == 1) {
                return CTYSNativeReader.read4442(0, 256, chip.buf);
            }
            if (chip.chipName == 0) {
                if (chip.secret != null) {
                    for (int i = 0; i < chip.secret.length(); i += 4) {
                        String pwd = chip.secret.substring(i, i + 4);
                        if (!CTYSNativeReader.verify102Pwd(HexDump.hexStringToByteArray(pwd))) continue;
                        chip.secret = pwd;
                        return CTYSNativeReader.read102(0, 178, chip.buf, HexDump.hexStringToByteArray(pwd));
                    }
                    return false;
                }
                return CTYSNativeReader.read102(0, 178, chip.buf, null);
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    @Override
    public boolean write(Chip chip, int block, int offset, int len, byte[] buf, byte[] secret) {
        try {
            if (chip.chipName == 1) {
                return CTYSNativeReader.write4442(offset, len, buf, secret);
            }
            if (chip.chipName == 0) {
                return CTYSNativeReader.write102(offset, len, buf, secret);
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    public static boolean write102(int offset, int len, byte[] buf, byte[] secret) {
        if (secret != null && !CTYSNativeReader.verify102Pwd(secret)) {
            return false;
        }
        int ret = -1;
        try {
            IndustryCardApdu industryCardApdu = new IndustryCardApdu();
            industryCardApdu.setCla((byte)0);
            industryCardApdu.setIns((byte)-48);
            industryCardApdu.setP1((byte)0);
            industryCardApdu.setP2((byte)offset);
            industryCardApdu.setLc(len);
            industryCardApdu.setDataIn(buf);
            ret = industryCardManager.exchange(industryCardApdu);
            return ret == 0 && industryCardApdu.getSwa() == -112 && industryCardApdu.getSwb() == 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean write4442(int offset, int len, byte[] buf, byte[] secret) {
        if (secret != null && !CTYSNativeReader.verify4442Pwd(secret)) {
            return false;
        }
        int ret = -1;
        try {
            IndustryCardApdu industryCardApdu = new IndustryCardApdu();
            industryCardApdu.setCla((byte)0);
            industryCardApdu.setIns((byte)-48);
            industryCardApdu.setP1((byte)0);
            industryCardApdu.setP2((byte)offset);
            industryCardApdu.setLc(len);
            industryCardApdu.setDataIn(buf);
            ret = industryCardManager.exchange(industryCardApdu);
            return ret == 0 && industryCardApdu.getSwa() == -112 && industryCardApdu.getSwb() == 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void findCard() {
        HashSet<CardSlotTypeEnum> slotTypes = new HashSet<CardSlotTypeEnum>();
        slotTypes.add(CardSlotTypeEnum.ICC1);
        HashSet<CardTypeEnum> cardTypes = new HashSet<CardTypeEnum>();
        cardTypes.add(CardTypeEnum.CPUCARD);
        int timeout = 1;
        try {
            HashMap<CardSlotTypeEnum, Bundle> options = new HashMap<CardSlotTypeEnum, Bundle>();
            Bundle bundle = new Bundle();
            bundle.putBoolean("lrc_check", false);
            options.put(CardSlotTypeEnum.RF, bundle);
            cardSlotManager.setConfig(options);
            cardSlotManager.readCard(slotTypes, cardTypes, timeout, new OnCardInfoListener(){

                public void onCardInfo(int arg0, CardInfoEntity arg1) {
                    if (arg0 == -6002) {
                        CTYSNativeReader.hasCardState(true);
                        cardTypeEnum = arg1.getmSlotType();
                    }
                    try {
                        cardSlotManager.stopRead();
                    }
                    catch (SdkException e) {
                        Log.e((String)"findCard", (String)("SdkException" + e.getMessage()));
                    }
                    catch (CallServiceException e) {
                        Log.e((String)"findCard", (String)("CallServiceException" + e.getMessage()));
                    }
                }
            }, null);
            Thread.sleep(1500L);
            byte[] buf = new byte[4];
            boolean bl = industryCardManager.init(buf, cardTypeEnum);
        }
        catch (SdkException e) {
            Log.e((String)"findCard", (String)("SdkException" + e.getMessage()));
        }
        catch (CallServiceException e) {
            Log.e((String)"findCard", (String)("CallServiceException" + e.getMessage()));
        }
        catch (InterruptedException e) {
            Log.e((String)"findCard", (String)("InterruptedException" + e.getMessage()));
        }
    }

    @Override
    public boolean verifyPwd(Chip chip, int block, byte[] secret) {
        if (chip.chipName == 0) {
            for (int i = 0; i < secret.length; i += 2) {
                if (!CTYSNativeReader.verify102Pwd(new byte[]{secret[i], secret[i + 1]})) continue;
                return true;
            }
            return false;
        }
        if (chip.chipName == 1) {
            for (int i = 0; i < secret.length; i += 3) {
                if (!CTYSNativeReader.verify4442Pwd(new byte[]{secret[i], secret[i + 1], secret[i + 2]})) continue;
                return true;
            }
            return false;
        }
        return chip.chipName != 6;
    }

    @Override
    public Chip getNvlChip() {
        if (!CTYSDevice.islogin) {
            return null;
        }
        int ct = CTYSNativeReader.getCardType();
        if (ct == 1) {
            return new Chip(1);
        }
        if (ct == 0) {
            return new Chip(0);
        }
        if (ct == 3) {
            return new Chip(3);
        }
        if (ct == 6) {
            return new Chip(6);
        }
        if (ct == 7) {
            return new Chip(7);
        }
        return null;
    }

    public static int getCardType() {
        byte[] buf = new byte[4];
        try {
            String cardType;
            if (!findCardStatus) {
                CTYSNativeReader.findCard();
            }
            if ("AT88SC102".equals(cardType = industryCardManager.getCardType())) {
                return 0;
            }
            if ("SLE44X2".equals(cardType)) {
                return 1;
            }
        }
        catch (Exception e) {
            return -1;
        }
        return -1;
    }

    @Override
    public boolean hasCard() {
        try {
            if (!findCardStatus) {
                CTYSNativeReader.findCard();
            }
            return cardSlotManager.checkIcCardExist();
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean verify102Pwd(byte[] secret) {
        int ret = -1;
        try {
            IndustryCardApdu industryCardApdu = new IndustryCardApdu();
            industryCardApdu.setCla((byte)0);
            industryCardApdu.setIns((byte)32);
            industryCardApdu.setP1((byte)0);
            industryCardApdu.setP2((byte)0);
            industryCardApdu.setLc(secret.length);
            industryCardApdu.setDataIn(secret);
            ret = industryCardManager.exchange(industryCardApdu);
            return ret == 0 && industryCardApdu.getSwa() == -112 && industryCardApdu.getSwb() == 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean verify4442Pwd(byte[] secret) {
        int ret = -1;
        try {
            IndustryCardApdu industryCardApdu = new IndustryCardApdu();
            industryCardApdu.setCla((byte)0);
            industryCardApdu.setIns((byte)32);
            industryCardApdu.setP1((byte)0);
            industryCardApdu.setP2((byte)0);
            industryCardApdu.setLc(secret.length);
            industryCardApdu.setDataIn(secret);
            ret = industryCardManager.exchange(industryCardApdu);
            return ret == 0 && industryCardApdu.getSwa() == -112 && industryCardApdu.getSwb() == 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public boolean changePwd(Chip chip, int block, byte[] oldSecret, byte[] newSecret) {
        if (chip.chipName == 0) {
            return CTYSNativeReader.change102Pwd(oldSecret, newSecret);
        }
        if (chip.chipName == 1) {
            return CTYSNativeReader.change4442Pwd(oldSecret, newSecret);
        }
        return chip.chipName != 6;
    }

    public static boolean change102Pwd(byte[] oldKey, byte[] newKey) {
        if (oldKey != null && !CTYSNativeReader.verify102Pwd(oldKey)) {
            return false;
        }
        int ret = -1;
        try {
            IndustryCardApdu industryCardApdu = new IndustryCardApdu();
            industryCardApdu.setCla((byte)0);
            industryCardApdu.setIns((byte)-48);
            industryCardApdu.setP1((byte)0);
            industryCardApdu.setP2((byte)10);
            industryCardApdu.setLc(newKey.length);
            industryCardApdu.setDataIn(newKey);
            ret = industryCardManager.exchange(industryCardApdu);
            return ret == 0 && industryCardApdu.getSwa() == -112 && industryCardApdu.getSwb() == 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean change4442Pwd(byte[] oldKey, byte[] newKey) {
        if (oldKey != null && !CTYSNativeReader.verify4442Pwd(oldKey)) {
            return false;
        }
        int ret = -1;
        try {
            IndustryCardApdu industryCardApdu = new IndustryCardApdu();
            industryCardApdu.setCla((byte)0);
            industryCardApdu.setIns((byte)-48);
            industryCardApdu.setP1((byte)-64);
            industryCardApdu.setP2((byte)1);
            industryCardApdu.setLc(newKey.length);
            industryCardApdu.setDataIn(newKey);
            ret = industryCardManager.exchange(industryCardApdu);
            return ret == 0 && industryCardApdu.getSwa() == -112 && industryCardApdu.getSwb() == 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean read102(int offset, int length, byte[] data, byte[] key) {
        if (key != null && !CTYSNativeReader.verify102Pwd(key)) {
            return false;
        }
        int ret = -1;
        IndustryCardApdu industryCardApdu = new IndustryCardApdu();
        industryCardApdu.setCla((byte)0);
        industryCardApdu.setIns((byte)-80);
        industryCardApdu.setP1((byte)0);
        int len = 22;
        try {
            for (int i = offset; i < length + offset; i += 22) {
                if (i >= 132) {
                    industryCardApdu.setP1((byte)1);
                }
                if (length + offset - i < 22) {
                    len = length + offset - i;
                }
                industryCardApdu.setP2((byte)i);
                industryCardApdu.setLe(length);
                ret = industryCardManager.exchange(industryCardApdu);
                if (ret != 0 || industryCardApdu.getSwa() != -112 || industryCardApdu.getSwb() != 0) {
                    return false;
                }
                System.arraycopy(industryCardApdu.getDataOut(), 0, data, i, len);
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean read4442(int offset, int length, byte[] data) {
        int ret = -1;
        IndustryCardApdu industryCardApdu = new IndustryCardApdu();
        industryCardApdu.setCla((byte)0);
        industryCardApdu.setIns((byte)-80);
        industryCardApdu.setP1((byte)0);
        industryCardApdu.setP2((byte)offset);
        try {
            if (length >= 254) {
                industryCardApdu.setLe(253);
                ret = industryCardManager.exchange(industryCardApdu);
                if (ret != 0 || industryCardApdu.getSwa() != -112 || industryCardApdu.getSwb() != 0) {
                    return false;
                }
                System.arraycopy(industryCardApdu.getDataOut(), 0, data, 0, industryCardApdu.getDataOutLen());
                industryCardApdu.setLe(length - 253);
                industryCardApdu.setP2((byte)-3);
                ret = industryCardManager.exchange(industryCardApdu);
                if (ret != 0 || industryCardApdu.getSwa() != -112 || industryCardApdu.getSwb() != 0) {
                    return false;
                }
                System.arraycopy(industryCardApdu.getDataOut(), 0, data, 253, industryCardApdu.getDataOutLen());
                return true;
            }
            industryCardApdu.setLe(length);
            ret = industryCardManager.exchange(industryCardApdu);
            if (ret != 0) {
                return false;
            }
            System.arraycopy(industryCardApdu.getDataOut(), 0, data, 0, industryCardApdu.getDataOutLen());
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public byte[] resetCPUCard() {
        return new byte[0];
    }

    @Override
    public byte[] resetRFCard() {
        return new byte[0];
    }

    @Override
    public byte[] resetPSAMCard() {
        return new byte[0];
    }

    @Override
    public byte[] CPUsendAPDU(byte[] apdu) {
        return new byte[0];
    }

    @Override
    public byte[] RFsendAPDU(byte[] apdu) {
        return new byte[0];
    }

    @Override
    public byte[] PSAMsendAPDU(byte[] apdu) {
        return new byte[0];
    }
}

