/*
 * Decompiled with CFR 0.152.
 */
package com.aofeng.hybrid.android.sign;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.view.MotionEvent;
import com.aofeng.hybrid.android.sign.Bezier;
import com.aofeng.hybrid.android.sign.ControllerPoint;
import com.aofeng.hybrid.android.sign.MotionElement;
import java.util.ArrayList;

public class StrokePen {
    protected float DIS_VEL_CAL_FACTOR = 0.02f;
    protected float WIDTH_THRES_MAX = 10.0f;
    protected int STEPFACTOR = 10;
    private ArrayList<ControllerPoint> mPointList = new ArrayList();
    private ArrayList<ControllerPoint> mHWPointList = new ArrayList();
    private Bezier mBezier = new Bezier();
    private ControllerPoint mLastPoint = new ControllerPoint(0.0f, 0.0f);
    private double mBaseWidth;
    private double mLastVel;
    private double mLastWidth;
    private ControllerPoint curPoint;
    private Paint mPaint;

    public void clear() {
        this.mPointList.clear();
        this.mHWPointList.clear();
    }

    public StrokePen(Context context) {
    }

    public void draw(Canvas canvas) {
        this.mPaint.setStyle(Paint.Style.FILL);
        if (this.mHWPointList == null || this.mHWPointList.size() < 1) {
            return;
        }
        if (this.mHWPointList.size() < 2) {
            ControllerPoint controllerPoint = this.mHWPointList.get(0);
        } else {
            this.curPoint = this.mHWPointList.get(0);
            for (int i = 1; i < this.mHWPointList.size(); ++i) {
                ControllerPoint point = this.mHWPointList.get(i);
                this.drawToPoint(canvas, point, this.mPaint);
                this.curPoint = point;
            }
        }
    }

    public MotionElement createMotionElement(MotionEvent motionEvent) {
        System.out.println("shiming== 0000==" + motionEvent.getToolType(0));
        System.out.println("shiming==" + motionEvent.getPressure());
        System.out.println("shiming==" + motionEvent.getEventTime());
        MotionElement motionElement = new MotionElement(motionEvent.getX(), motionEvent.getY(), motionEvent.getPressure(), motionEvent.getToolType(0));
        return motionElement;
    }

    public void onDown(MotionElement mElement) {
        this.mPaint.setXfermode(null);
        this.mPointList.clear();
        this.mHWPointList.clear();
        ControllerPoint curPoint = new ControllerPoint(mElement.x, mElement.y);
        this.mLastWidth = mElement.tooltype == 2 ? (double)mElement.pressure * this.mBaseWidth : 0.8 * this.mBaseWidth;
        curPoint.width = (float)this.mLastWidth;
        this.mLastVel = 0.0;
        this.mPointList.add(curPoint);
        this.mLastPoint = curPoint;
    }

    public void onMove(MotionElement mElement) {
        double curWidth;
        ControllerPoint curPoint = new ControllerPoint(mElement.x, mElement.y);
        double deltaX = curPoint.x - this.mLastPoint.x;
        double deltaY = curPoint.y - this.mLastPoint.y;
        double curDis = Math.hypot(deltaX, deltaY);
        double curVel = curDis * (double)this.DIS_VEL_CAL_FACTOR;
        System.out.println("shiming===" + curDis + " " + curVel + " " + deltaX + " " + deltaY);
        if (this.mPointList.size() < 2) {
            System.out.println("shiming==dian shao");
            curWidth = mElement.tooltype == 2 ? (double)mElement.pressure * this.mBaseWidth : this.calcNewWidth(curVel, this.mLastVel, curDis, 1.5, this.mLastWidth);
            curPoint.width = (float)curWidth;
            this.mBezier.init(this.mLastPoint, curPoint);
        } else {
            System.out.println("shiming==dian duo");
            this.mLastVel = curVel;
            if (mElement.tooltype == 2) {
                curWidth = (double)mElement.pressure * this.mBaseWidth;
            } else {
                curWidth = this.calcNewWidth(curVel, this.mLastVel, curDis, 1.5, this.mLastWidth);
                System.out.println("shiming==" + curVel + " " + this.mLastVel + " " + curDis + " " + this.mLastWidth);
                System.out.println("shiming==dian duo" + curWidth);
            }
            curPoint.width = (float)curWidth;
            this.mBezier.addNode(curPoint);
        }
        this.mLastWidth = curWidth;
        this.mPointList.add(curPoint);
        int steps = 1 + (int)curDis / this.STEPFACTOR;
        System.out.println("shiming-- steps" + steps);
        double step = 1.0 / (double)steps;
        for (double t = 0.0; t < 1.0; t += step) {
            ControllerPoint point = this.mBezier.getPoint(t);
            this.mHWPointList.add(point);
        }
        this.mLastPoint = curPoint;
    }

    public void onUp(MotionElement mElement, Canvas canvas) {
        ControllerPoint point;
        double t;
        ControllerPoint curPoint = new ControllerPoint(mElement.x, mElement.y);
        double deltaX = curPoint.x - this.mLastPoint.x;
        double deltaY = curPoint.y - this.mLastPoint.y;
        double curDis = Math.hypot(deltaX, deltaY);
        curPoint.width = mElement.tooltype == 2 ? (float)((double)mElement.pressure * this.mBaseWidth) : 0.0f;
        this.mPointList.add(curPoint);
        this.mBezier.addNode(curPoint);
        int steps = 1 + (int)curDis / this.STEPFACTOR;
        double step = 1.0 / (double)steps;
        for (t = 0.0; t < 1.0; t += step) {
            point = this.mBezier.getPoint(t);
            this.mHWPointList.add(point);
        }
        this.mBezier.end();
        for (t = 0.0; t < 1.0; t += step) {
            point = this.mBezier.getPoint(t);
            this.mHWPointList.add(point);
        }
        this.draw(canvas);
    }

    private void drawToPoint(Canvas canvas, ControllerPoint point, Paint paint) {
        if (this.curPoint.x == point.x && this.curPoint.y == point.y) {
            return;
        }
        this.drawLine(canvas, this.curPoint.x, this.curPoint.y, this.curPoint.width, point.x, point.y, point.width, paint);
    }

    private double calcNewWidth(double curVel, double lastVel, double curDis, double factor, double lastWidth) {
        double calVel = curVel * 0.6 + lastVel * 0.4;
        double vfac = Math.log(factor * 2.0) * -calVel;
        double calWidth = this.mBaseWidth * Math.exp(vfac);
        double mMoveThres = curDis * (double)0.01f;
        if (mMoveThres > (double)this.WIDTH_THRES_MAX) {
            mMoveThres = this.WIDTH_THRES_MAX;
        }
        if (Math.abs(calWidth - this.mBaseWidth) / this.mBaseWidth > mMoveThres) {
            calWidth = calWidth > this.mBaseWidth ? this.mBaseWidth * (1.0 + mMoveThres) : this.mBaseWidth * (1.0 - mMoveThres);
        } else if (Math.abs(calWidth - lastWidth) / lastWidth > mMoveThres) {
            calWidth = calWidth > lastWidth ? lastWidth * (1.0 + mMoveThres) : lastWidth * (1.0 - mMoveThres);
        }
        return calWidth;
    }

    private void drawLine(Canvas canvas, double x0, double y0, double w0, double x1, double y1, double w1, Paint paint) {
        double curDis = Math.hypot(x0 - x1, y0 - y1);
        int steps = 1;
        steps = paint.getStrokeWidth() < 6.0f ? 1 + (int)(curDis / 2.0) : (paint.getStrokeWidth() > 60.0f ? 1 + (int)(curDis / 4.0) : 1 + (int)(curDis / 3.0));
        double deltaX = (x1 - x0) / (double)steps;
        double deltaY = (y1 - y0) / (double)steps;
        double deltaW = (w1 - w0) / (double)steps;
        double x = x0;
        double y = y0;
        double w = w0;
        for (int i = 0; i < steps; ++i) {
            RectF oval = new RectF();
            oval.set((float)(x - w / 4.0), (float)(y - w / 2.0), (float)(x + w / 4.0), (float)(y + w / 2.0));
            canvas.drawOval(oval, paint);
            x += deltaX;
            y += deltaY;
            w += deltaW;
        }
    }

    public void setPaint(Paint paint) {
        this.mPaint = paint;
        this.mBaseWidth = paint.getStrokeWidth();
    }
}

