/*
 * Decompiled with CFR 0.152.
 */
package com.aofeng.hybrid.pos.reader;

import com.aofeng.hybrid.application.AFApplication;
import com.aofeng.hybrid.pos.reader.ICardReader;
import com.aofeng.hybrid.util.CommUtil;
import com.aofeng.hybrid.util.HexDump;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;
import org.json.JSONObject;

public class CPUService
extends Thread {
    private ICardReader reader;
    private String body;

    public CPUService() {
    }

    CPUService(String body) {
        this.body = body;
        this.reader = AFApplication.card.getReader();
    }

    @Override
    public void run() {
        try {
            JSONObject json = new JSONObject(this.body);
            String UUID2 = (String)json.get("GUID");
            String url = json.getString("socket_url");
            JSONObject job = new JSONObject();
            HttpClient hc = CommUtil.getCardServiceHttpClient();
            while (true) {
                String results;
                job.put("UUID", (Object)UUID2);
                HttpPost httpPost = new HttpPost(url + "getAPDU2");
                httpPost.setEntity((HttpEntity)new StringEntity(job.toString(), "UTF8"));
                HttpResponse response = hc.execute((HttpUriRequest)httpPost);
                if (response.getStatusLine().getStatusCode() == 200 && response.getEntity() != null && (results = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF8")) != null && !"".equals(results)) {
                    byte[] result;
                    String str = results.substring(37);
                    String byteStr = "";
                    if ("cpu_reset".equals(str)) {
                        result = this.reader.resetCPUCard();
                        byteStr = result == null ? "6A82" : HexDump.toHexString(result);
                    } else if ("sam_reset".equals(str)) {
                        result = this.reader.resetPSAMCard();
                        byteStr = result == null ? "6A82" : HexDump.toHexString(result);
                    } else {
                        byte[] result2;
                        byte[] apdu;
                        String apdustr;
                        String[] strs = str.split(";");
                        if ("cpu_protocol".equals(strs[0])) {
                            System.out.println("\u539f\u59cb\u6570\u636e:" + strs[2]);
                            apdustr = strs[2];
                            apdu = HexDump.hexStringToByteArray(apdustr);
                            result2 = this.reader.CPUsendAPDU(apdu);
                            byteStr = result2 == null ? "6A82" : HexDump.toHexString(result2);
                        } else if ("sam_protocol".equals(strs[0])) {
                            System.out.println("\u539f\u59cb\u6570\u636e:" + strs[2]);
                            apdustr = strs[2];
                            apdu = HexDump.hexStringToByteArray(apdustr);
                            result2 = this.reader.PSAMsendAPDU(apdu);
                            byteStr = result2 == null ? "6A82" : HexDump.toHexString(result2);
                        }
                    }
                    System.out.println("\u8fd4\u56de\u6570\u636e:" + byteStr);
                    job = new JSONObject();
                    job.put("requesData", (Object)results);
                    job.put("result", (Object)byteStr);
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

