/*
 * Decompiled with CFR 0.152.
 */
package com.aofeng.hybrid.android.service;

import android.app.Service;
import android.content.Intent;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.Messenger;
import android.os.RemoteException;
import android.util.Log;
import java.util.ArrayList;

public abstract class AbstractService
extends Service {
    static final int MSG_REGISTER_CLIENT = 9991;
    static final int MSG_UNREGISTER_CLIENT = 9992;
    ArrayList<Messenger> mClients = new ArrayList();
    final Messenger mMessenger = new Messenger((Handler)new IncomingHandler());

    public void onCreate() {
        super.onCreate();
        this.onStartService();
        Log.e((String)"MyService", (String)"Service Started.");
    }

    public IBinder onBind(Intent intent) {
        return this.mMessenger.getBinder();
    }

    public void onDestroy() {
        super.onDestroy();
        this.onStopService();
        Log.i((String)"MyService", (String)"Service Stopped.");
    }

    protected void send(Message msg) {
        for (int i = this.mClients.size() - 1; i >= 0; --i) {
            try {
                Log.i((String)"MyService", (String)("Sending message to clients: " + msg));
                this.mClients.get(i).send(msg);
                continue;
            }
            catch (RemoteException e) {
                Log.e((String)"MyService", (String)("Client is dead. Removing from list: " + i));
                this.mClients.remove(i);
            }
        }
    }

    public abstract void onStartService();

    public abstract void onStopService();

    public abstract void onReceiveMessage(Message var1);

    private class IncomingHandler
    extends Handler {
        private IncomingHandler() {
        }

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 9991: {
                    Log.i((String)"MyService", (String)("Client registered: " + msg.replyTo));
                    AbstractService.this.mClients.add(msg.replyTo);
                    break;
                }
                case 9992: {
                    Log.i((String)"MyService", (String)("Client un-registered: " + msg.replyTo));
                    AbstractService.this.mClients.remove(msg.replyTo);
                    break;
                }
                default: {
                    AbstractService.this.onReceiveMessage(msg);
                }
            }
        }
    }
}

