/*
 * Decompiled with CFR 0.152.
 */
package com.aofeng.hybrid.pos.reader;

import android.bluetooth.BluetoothDevice;
import android.content.Context;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import com.aofeng.hybrid.pos.device.BlueDevice;
import com.aofeng.hybrid.pos.reader.Chip;
import com.aofeng.hybrid.pos.reader.ICardReader;
import com.aofeng.hybrid.util.HexDump;
import com.example.reader.BluetoothUtils;
import java.util.List;

public class PrmtReader
implements ICardReader {
    public static BluetoothUtils mBluetoothUtils;
    public static BluetoothDevice device;
    private Context mContext;
    public static String bluePrefix;
    public static BlueDevice blueDevice;
    private Handler mHandler = new Handler(){

        public void handleMessage(Message msg) {
            if (3 == msg.what) {
                List bluetoothDeviceArrayList = PrmtReader.mBluetoothUtils.mLeDevices;
                if (PrmtReader.mBluetoothUtils.mBluetoothGatt == null) {
                    for (BluetoothDevice devices : bluetoothDeviceArrayList) {
                        Log.d((String)"PrmtReader", (String)("name = " + devices.getName()));
                        if (devices.getName() == null || device != null) continue;
                        int ret = mBluetoothUtils.Connect(devices);
                        Log.d((String)"PrmtReader", (String)("ret = " + ret));
                        if (ret != 1) continue;
                        device = devices;
                        blueDevice = new BlueDevice(device.getName(), device.getAddress(), device);
                        Log.d((String)"PrmtReader", (String)"\u8fde\u63a5\u84dd\u7259\u6210\u529f");
                        Log.d((String)"PrmtReader", (String)("name = " + devices.getName()));
                        mBluetoothUtils.scanBleDevice(false);
                        break;
                    }
                }
            }
        }
    };

    public void ScanBluetooth(Context mContext, String bluePrefix) {
        this.mContext = mContext;
        PrmtReader.bluePrefix = bluePrefix;
        mBluetoothUtils = new BluetoothUtils();
        mBluetoothUtils.initialize(this.mContext, this.mHandler);
        mBluetoothUtils.scanBleDevice(true);
    }

    @Override
    public boolean openDevice(Chip chip) {
        return true;
    }

    @Override
    public boolean closeDevice(Chip chip) {
        return true;
    }

    @Override
    public boolean hasCard() {
        return true;
    }

    @Override
    public boolean read(Chip chip) {
        if (chip.chipName == 1) {
            return this.read4442(2, 0, 256, chip.buf);
        }
        if (chip.chipName == 0) {
            if (chip.secret != null) {
                for (int i = 0; i < chip.secret.length(); i += 4) {
                    String pwd = chip.secret.substring(i, i + 4);
                    if (!this.verify102Pwd(pwd)) continue;
                    chip.secret = pwd;
                    return this.read102(178, chip.buf, null);
                }
                return false;
            }
            return this.read102(178, chip.buf, null);
        }
        if (chip.chipName == 6) {
            if (chip.secret != null) {
                String[] kmms = chip.secret.split("\\|");
                String area2WritePwd = this.get1608AreaPwd(2, 0, kmms);
                for (int i = 0; i < area2WritePwd.length(); i += 6) {
                    String pwd = area2WritePwd.substring(i, i + 6);
                    if (!this.verify1608Pwd((byte)2, (byte)1, HexDump.hexStringToByteArray(pwd))) continue;
                    return this.read1608(2, 0, 256, chip.buf);
                }
                return false;
            }
            if (chip.secret_1608 != null) {
                String[] kmms = chip.secret_1608.split("\\|");
                String area2WritePwd = this.get1608AreaPwd(7, 0, kmms);
                for (int i = 0; i < area2WritePwd.length(); i += 6) {
                    String pwd = area2WritePwd.substring(i, i + 6);
                    if (!this.verify1608Pwd((byte)7, (byte)1, HexDump.hexStringToByteArray(pwd))) continue;
                    return this.read1608(7, 0, 256, chip.buf);
                }
                return false;
            }
            return this.read1608Config(8, 0, 128, chip.buf);
        }
        return false;
    }

    @Override
    public boolean write(Chip chip, int block, int offset, int len, byte[] buf, byte[] secret) {
        if (chip.chipName == 0) {
            return this.write102(block, offset, len, buf, HexDump.toHexString(secret));
        }
        if (chip.chipName == 1) {
            return this.write4442(2, offset, len, buf, HexDump.toHexString(secret));
        }
        if (chip.chipName == 6) {
            if (this.verify1608Pwd((byte)block, (byte)0, secret)) {
                return this.write1608(block, offset, buf);
            }
            return false;
        }
        return false;
    }

    public boolean write4442(int block, int offset, int len, byte[] buf, String key) {
        if (this.get4442PwdAttemptCnt() <= 0) {
            return false;
        }
        if (key != null && !key.equals("null") && !this.verify4442Pwd(key)) {
            return false;
        }
        String result = mBluetoothUtils.write(2, offset, len, HexDump.toHexString(buf), 2);
        return "1".equals(result);
    }

    public boolean write102(int block, int offset, int len, byte[] buf, String key) {
        if (this.get102PwdAttemptCnt() <= 0) {
            return false;
        }
        if (key != null && !key.equals("null") && !this.verify102Pwd(key)) {
            return false;
        }
        String result = "-1";
        if (offset < 22) {
            for (int i = 0; i < len; i += 8) {
                int length = i + 8 > len ? len - i : 8;
                int off = offset + i;
                result = mBluetoothUtils.write(0, off, length, HexDump.toHexString(buf, i, length), 3);
            }
        } else if (offset > 22 && offset < 92) {
            for (int i = 0; i < len; i += 8) {
                int length = i + 8 > len ? len - i : 8;
                int off = offset + i - 22;
                result = mBluetoothUtils.write(1, off, length, HexDump.toHexString(buf, i, length), 3);
            }
        } else {
            for (int i = 0; i < len; i += 8) {
                int length = i + 8 > len ? len - i : 8;
                int off = offset + i - 22 - 70;
                result = mBluetoothUtils.write(2, off, length, HexDump.toHexString(buf, i, length), 3);
            }
        }
        return "1".equals(result);
    }

    @Override
    public boolean verifyPwd(Chip chip, int block, byte[] secret) {
        if (chip.chipName == 0) {
            for (int i = 0; i < secret.length; i += 2) {
                if (!this.verify102Pwd(HexDump.toHexString(new byte[]{secret[i], secret[i + 1]}))) continue;
                return true;
            }
            return false;
        }
        if (chip.chipName == 1) {
            for (int i = 0; i < secret.length; i += 3) {
                if (!this.verify4442Pwd(HexDump.toHexString(new byte[]{secret[i], secret[i + 1], secret[i + 2]}))) continue;
                return true;
            }
            return false;
        }
        return chip.chipName != 6;
    }

    @Override
    public boolean changePwd(Chip chip, int block, byte[] oldSecret, byte[] newSecret) {
        if (chip.chipName == 0) {
            return this.change102Pwd(oldSecret, newSecret);
        }
        if (chip.chipName == 1) {
            return this.change4442Pwd(oldSecret, newSecret);
        }
        return true;
    }

    public boolean change102Pwd(byte[] oldKey, byte[] newKey) {
        if (this.get102PwdAttemptCnt() <= 0) {
            return false;
        }
        if (oldKey != null && !this.verify102Pwd(HexDump.toHexString(oldKey))) {
            return false;
        }
        String result = mBluetoothUtils.write(0, 10, 2, HexDump.toHexString(newKey), 3);
        return "1".equals(result);
    }

    public boolean change4442Pwd(byte[] oldKey, byte[] newKey) {
        if (this.get4442PwdAttemptCnt() <= 0) {
            return false;
        }
        if (oldKey != null && !this.verify4442Pwd(HexDump.toHexString(oldKey))) {
            return false;
        }
        String result = mBluetoothUtils.write(0, 1, 3, HexDump.toHexString(newKey), 2);
        return "1".equals(result);
    }

    @Override
    public Chip getNvlChip() {
        Chip chip = null;
        String ct = mBluetoothUtils.CheckCard();
        if ("2".equals(ct)) {
            chip = new Chip(1);
        } else if ("3".equals(ct)) {
            chip = new Chip(0);
        } else if ("7".equals(ct)) {
            chip = new Chip(6);
        }
        if (chip != null) {
            return chip;
        }
        return null;
    }

    public boolean read4442(int zone, int start, int length, byte[] buf) {
        if (this.get4442PwdAttemptCnt() <= 0) {
            return false;
        }
        String result = mBluetoothUtils.read(2, 2, 0, 256).replaceAll(" ", "");
        byte[] bt = HexDump.hexStringToByteArray(result);
        if (bt.length > 0) {
            System.arraycopy(bt, 0, buf, 0, bt.length);
            return true;
        }
        return false;
    }

    public boolean read102(int length, byte[] buf, String key) {
        if (this.get102PwdAttemptCnt() <= 0) {
            return false;
        }
        if (key != null && !this.verify102Pwd(key)) {
            return false;
        }
        String result = mBluetoothUtils.read(0, 3, 0, 178).replaceAll(" ", "");
        byte[] bt = HexDump.hexStringToByteArray(result);
        System.arraycopy(bt, 0, buf, 0, bt.length);
        return true;
    }

    public byte[] readcard(int zone, int start, int length) {
        byte[] buf = new byte[length];
        if (length > 32) {
            byte[] bytes;
            int a = length / 32;
            int b = length % 32;
            for (int i = 0; i < a; ++i) {
                bytes = mBluetoothUtils.rd_datRW(zone, start + 32 * i, 32);
                if (bytes == null && bytes.length != 32) {
                    return null;
                }
                System.arraycopy(bytes, 0, buf, 0 + 32 * i, 32);
            }
            if (b != 0) {
                bytes = mBluetoothUtils.rd_datRW(zone, length - 32 * a, b);
                if (bytes == null && bytes.length != b) {
                    return null;
                }
                System.arraycopy(bytes, 0, buf, 32 * a, b);
            }
            return buf;
        }
        buf = mBluetoothUtils.rd_datRW(zone, start, length);
        if (buf == null && buf.length != length) {
            return null;
        }
        return buf;
    }

    public boolean verify102Pwd(String key) {
        String ret = mBluetoothUtils.checkPwd(0, key, 3);
        return "1".equals(ret);
    }

    public boolean verify4442Pwd(String key) {
        String ret = mBluetoothUtils.checkPwd(0, key, 2);
        return "1".equals(ret);
    }

    public int get4442PwdAttemptCnt() {
        String result = mBluetoothUtils.read(0, 2, 0, 1).replaceAll(" ", "");
        byte[] count = HexDump.hexStringToByteArray(result);
        if (count.length == 1) {
            if ((count[0] & 7) == 7) {
                return 3;
            }
            if ((count[0] & 6) == 6) {
                return 2;
            }
            if ((count[0] & 4) == 4) {
                return 1;
            }
            return 0;
        }
        return -1;
    }

    public int get102PwdAttemptCnt() {
        String result = mBluetoothUtils.read(0, 3, 12, 1).replaceAll(" ", "");
        byte[] count = HexDump.hexStringToByteArray(result);
        if (count.length == 1) {
            if ((count[0] & 0xF0) == 240) {
                return 4;
            }
            if ((count[0] & 0xF0) == 112) {
                return 3;
            }
            if ((count[0] & 0xF0) == 48) {
                return 2;
            }
            if ((count[0] & 0xF0) == 16) {
                return 1;
            }
            return 0;
        }
        return -1;
    }

    @Override
    public byte[] resetCPUCard() {
        byte[] data = new byte[8];
        return data;
    }

    @Override
    public byte[] resetRFCard() {
        return new byte[0];
    }

    @Override
    public byte[] resetPSAMCard() {
        byte[] data = new byte[8];
        return data;
    }

    @Override
    public byte[] CPUsendAPDU(byte[] apdu) {
        byte[] data = new byte[8];
        return data;
    }

    @Override
    public byte[] RFsendAPDU(byte[] apdu) {
        return new byte[0];
    }

    @Override
    public byte[] PSAMsendAPDU(byte[] apdu) {
        byte[] data = new byte[8];
        return data;
    }

    private String get1608AreaPwd(int area, int type, String[] pwd) {
        if (type == 0) {
            return pwd[(area + 1) * 2 - 1];
        }
        if (type == 1) {
            return pwd[(area + 1) * 2 - 2];
        }
        return null;
    }

    public boolean verify1608Pwd(byte area, byte type, byte[] key) {
        try {
            String result = mBluetoothUtils.checkPwd(area * 2 + 1 - type, HexDump.toHexString(key), 7);
            return "1".equals(result);
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean read1608(int area, int offset, int len, byte[] buf) {
        byte[] data = null;
        try {
            String result = mBluetoothUtils.read(area, 7, offset, len).replaceAll(" ", "");
            data = HexDump.hexStringToByteArray(result);
            if (data.length > 0) {
                System.arraycopy(buf, 0, data, 0, data.length);
            }
            return data.length > 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean read1608Config(int area, int offset, int len, byte[] buf) {
        byte[] data = null;
        try {
            String result = mBluetoothUtils.read(8, 7, offset, len).replaceAll(" ", "");
            data = HexDump.hexStringToByteArray(result);
            if (data.length > 0) {
                System.arraycopy(buf, 0, data, 0, data.length);
            }
            return data.length > 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean write1608(int area, int offset, byte[] data) {
        try {
            String result = mBluetoothUtils.write(area, offset, data.length, HexDump.toHexString(data), 7);
            return "1".equals(result);
        }
        catch (Exception e) {
            return false;
        }
    }
}

