/*
 * Decompiled with CFR 0.152.
 */
package com.aofeng.hybrid.android.zbar.decode;

import android.graphics.Rect;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import com.aofeng.hybrid.R;
import com.aofeng.hybrid.android.peripheral.CaptureActivity;
import java.util.Iterator;
import net.sourceforge.zbar.Image;
import net.sourceforge.zbar.ImageScanner;
import net.sourceforge.zbar.Symbol;
import net.sourceforge.zbar.SymbolSet;

final class DecodeHandler
extends Handler {
    private static final String TAG = DecodeHandler.class.getSimpleName();
    private final CaptureActivity activity;
    private ImageScanner scanner;

    public DecodeHandler(CaptureActivity activity) {
        this.activity = activity;
        this.scanner = new ImageScanner();
        this.scanner.setConfig(0, 256, 3);
        this.scanner.setConfig(0, 257, 3);
    }

    public void handleMessage(Message message) {
        if (message.what == R.id.decode) {
            this.decode((byte[])message.obj, message.arg1, message.arg2);
        } else if (message.what == R.id.quit) {
            Looper.myLooper().quit();
        }
    }

    private void decode(byte[] data, int width, int height) {
        Message message;
        Image barcode = new Image(width, height, "Y800");
        Rect scanImageRect = this.activity.getViewfinderView().getScanImageRect(height, width);
        barcode.setCrop(scanImageRect.top, scanImageRect.left, scanImageRect.bottom, scanImageRect.right);
        barcode.setData(data);
        int result = this.scanner.scanImage(barcode);
        String strResult = "";
        if (result != 0) {
            Symbol sym;
            SymbolSet syms = this.scanner.getResults();
            Iterator iterator = syms.iterator();
            while (iterator.hasNext() && (strResult = (sym = (Symbol)iterator.next()).getData().trim()).isEmpty()) {
            }
        }
        if (!strResult.isEmpty()) {
            message = Message.obtain((Handler)this.activity.getHandler(), (int)R.id.decode_succeeded, (Object)strResult);
            Log.d((String)TAG, (String)"Sending decode succeeded message...");
            message.sendToTarget();
        } else {
            message = Message.obtain((Handler)this.activity.getHandler(), (int)R.id.decode_failed);
            message.sendToTarget();
        }
    }

    static {
        System.loadLibrary("iconv");
    }
}

