/*
 * Decompiled with CFR 0.152.
 */
package com.aofeng.hybrid.android.sign;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import com.aofeng.hybrid.android.sign.BasePenExtend;
import com.aofeng.hybrid.android.sign.ControllerPoint;

public class SteelPen
extends BasePenExtend {
    public SteelPen(Context context) {
        super(context);
    }

    @Override
    protected void drawNeetToDo(Canvas canvas) {
        for (int i = 1; i < this.mHWPointList.size(); ++i) {
            ControllerPoint point = (ControllerPoint)this.mHWPointList.get(i);
            this.drawToPoint(canvas, point, this.mPaint);
            this.mCurPoint = point;
        }
    }

    @Override
    protected void moveNeetToDo(double curDis) {
        int steps = 1 + (int)curDis / 10;
        double step = 1.0 / (double)steps;
        for (double t = 0.0; t < 1.0; t += step) {
            ControllerPoint point = this.mBezier.getPoint(t);
            this.mHWPointList.add(point);
        }
    }

    @Override
    protected void doNeetToDo(Canvas canvas, ControllerPoint point, Paint paint) {
        this.drawLine(canvas, this.mCurPoint.x, this.mCurPoint.y, this.mCurPoint.width, point.x, point.y, point.width, paint);
    }

    private void drawLine(Canvas canvas, double x0, double y0, double w0, double x1, double y1, double w1, Paint paint) {
        double curDis = Math.hypot(x0 - x1, y0 - y1);
        int steps = 1;
        steps = paint.getStrokeWidth() < 6.0f ? 1 + (int)(curDis / 2.0) : (paint.getStrokeWidth() > 60.0f ? 1 + (int)(curDis / 4.0) : 1 + (int)(curDis / 3.0));
        double deltaX = (x1 - x0) / (double)steps;
        double deltaY = (y1 - y0) / (double)steps;
        double deltaW = (w1 - w0) / (double)steps;
        double x = x0;
        double y = y0;
        double w = w0;
        for (int i = 0; i < steps; ++i) {
            RectF oval = new RectF();
            oval.set((float)(x - w / 4.0), (float)(y - w / 2.0), (float)(x + w / 4.0), (float)(y + w / 2.0));
            canvas.drawOval(oval, paint);
            x += deltaX;
            y += deltaY;
            w += deltaW;
        }
    }
}

