/*
 * Decompiled with CFR 0.152.
 */
package com.aofeng.hybrid.android.sign;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Xfermode;
import com.aofeng.hybrid.R;
import com.aofeng.hybrid.android.sign.BasePenExtend;
import com.aofeng.hybrid.android.sign.ControllerPoint;

public class BrushPen
extends BasePenExtend {
    private Bitmap mBitmap;
    protected Rect mOldRect = new Rect();
    protected RectF mNeedDrawRect = new RectF();
    protected Bitmap mOriginBitmap;

    public BrushPen(Context context) {
        super(context);
        this.initTexture();
    }

    @Override
    public void setPaint(Paint paint) {
        super.setPaint(paint);
        this.setBitmap(this.mOriginBitmap);
    }

    private void initTexture() {
        this.mOriginBitmap = BitmapFactory.decodeResource((Resources)this.mContext.getResources(), (int)R.mipmap.brush);
    }

    private void setBitmap(Bitmap bitmap) {
        Canvas canvas = new Canvas();
        this.mBitmap = Bitmap.createBitmap((int)bitmap.getWidth(), (int)bitmap.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        this.mBitmap.eraseColor(Color.rgb((int)Color.red((int)this.mPaint.getColor()), (int)Color.green((int)this.mPaint.getColor()), (int)Color.blue((int)this.mPaint.getColor())));
        canvas.setBitmap(this.mBitmap);
        Paint paint = new Paint();
        paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.DST_IN));
        canvas.drawBitmap(bitmap, 0.0f, 0.0f, paint);
        this.mOldRect.set(0, 0, this.mBitmap.getWidth() / 4, this.mBitmap.getHeight() / 4);
    }

    private ControllerPoint getWithPointAlphaPoint(ControllerPoint point) {
        ControllerPoint nPoint = new ControllerPoint();
        nPoint.x = point.x;
        nPoint.y = point.y;
        nPoint.width = point.width;
        int alpha = (int)((double)(255.0f * point.width) / this.mBaseWidth / 2.0);
        if (alpha < 10) {
            alpha = 10;
        } else if (alpha > 255) {
            alpha = 255;
        }
        nPoint.alpha = alpha;
        return nPoint;
    }

    @Override
    protected void doNeetToDo(Canvas canvas, ControllerPoint point, Paint paint) {
        this.drawLine(canvas, this.mCurPoint.x, this.mCurPoint.y, this.mCurPoint.width, this.mCurPoint.alpha, point.x, point.y, point.width, point.alpha, paint);
    }

    protected void drawLine(Canvas canvas, double x0, double y0, double w0, int a0, double x1, double y1, double w1, int a1, Paint paint) {
        double curDis = Math.hypot(x0 - x1, y0 - y1);
        int factor = 2;
        if (paint.getStrokeWidth() < 6.0f) {
            factor = 1;
        } else if (paint.getStrokeWidth() > 60.0f) {
            factor = 3;
        }
        int steps = 1 + (int)(curDis / (double)factor);
        double deltaX = (x1 - x0) / (double)steps;
        double deltaY = (y1 - y0) / (double)steps;
        double deltaW = (w1 - w0) / (double)steps;
        double deltaA = (a1 - a0) / steps;
        double x = x0;
        double y = y0;
        double w = w0;
        double a = a0;
        for (int i = 0; i < steps; ++i) {
            if (w < 1.5) {
                w = 1.5;
            }
            this.mNeedDrawRect.set((float)(x - w / 2.0), (float)(y - w / 2.0), (float)(x + w / 2.0), (float)(y + w / 2.0));
            paint.setAlpha((int)(a / 3.0));
            canvas.drawBitmap(this.mBitmap, this.mOldRect, this.mNeedDrawRect, paint);
            x += deltaX;
            y += deltaY;
            w += deltaW;
            a += deltaA;
        }
    }

    @Override
    protected void drawNeetToDo(Canvas canvas) {
        for (int i = 1; i < this.mHWPointList.size(); ++i) {
            ControllerPoint point = (ControllerPoint)this.mHWPointList.get(i);
            this.drawToPoint(canvas, point, this.mPaint);
            this.mCurPoint = point;
        }
    }

    @Override
    protected void moveNeetToDo(double curDis) {
        int steps = 1 + (int)curDis / 10;
        double step = 1.0 / (double)steps;
        for (double t = 0.0; t < 1.0; t += step) {
            ControllerPoint point = this.mBezier.getPoint(t);
            point = this.getWithPointAlphaPoint(point);
            this.mHWPointList.add(point);
        }
    }

    @Override
    protected Paint getNewPaint(Paint paint) {
        return new Paint(paint);
    }
}

